/*
 * Decompiled with CFR 0.152.
 */
package gcewing.projectblue;

import codechicken.multipart.TMultiPart;
import gcewing.projectblue.IPBRenderer;
import gcewing.projectblue.Vector3;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class PBStaticRenderer
implements IPBRenderer {
    Tessellator tess;
    int glMode;
    World world;
    Block block;
    int blockX;
    int blockY;
    int blockZ;
    double x0;
    double y0;
    double z0;
    float cmr = 1.0f;
    float cmg = 1.0f;
    float cmb = 1.0f;
    float red = 1.0f;
    float green = 1.0f;
    float blue = 1.0f;
    float alpha = 1.0f;

    public PBStaticRenderer(TMultiPart part) {
        this(part.world(), null, part.x(), part.y(), part.z());
    }

    public PBStaticRenderer(World world, Block block, int blockX, int blockY, int blockZ) {
        if (block == null && world != null) {
            block = world.func_147439_a(blockX, blockY, blockZ);
        }
        this.world = world;
        this.block = block;
        this.blockX = blockX;
        this.blockY = blockY;
        this.blockZ = blockZ;
        this.tess = Tessellator.field_78398_a;
        this.tess.func_78380_c(0xF000F0);
        this.tess.func_78386_a(1.0f, 1.0f, 1.0f);
    }

    public void setAlpha(double alpha) {
        this.alpha = (float)alpha;
    }

    @Override
    public void begin(int mode) {
        this.glMode = mode;
    }

    @Override
    public void bindTexture(ResourceLocation loc) {
        throw new RuntimeException("PBStaticRenderer cannot change texture atlas");
    }

    @Override
    public void setColor(double red, double green, double blue) {
        this.red = (float)red;
        this.green = (float)green;
        this.blue = (float)blue;
    }

    @Override
    public void setEmissive(boolean state) {
    }

    @Override
    public void lightFace(Vector3 p, Vector3 n) {
        float bm;
        if (this.world != null) {
            int br = this.block.func_149677_c((IBlockAccess)this.world, (int)Math.floor(p.x + this.x0 + 0.01 * n.x), (int)Math.floor(p.y + this.y0 + 0.01 * n.y), (int)Math.floor(p.z + this.z0 + 0.01 * n.z));
            this.tess.func_78380_c(br);
            bm = (float)(0.6 * n.x * n.x + 0.8 * n.z * n.z + (n.y > 0.0 ? 1.0 : 0.5) * n.y * n.y);
        } else {
            bm = 1.0f;
        }
        this.tess.func_78369_a(bm * this.cmr * this.red, bm * this.cmg * this.green, bm * this.cmb * this.blue, this.alpha);
    }

    @Override
    public void renderVertex(int indexInFace, Vector3 p, Vector3 n, double u, double v) {
        this.tess.func_78375_b((float)n.x, (float)n.y, (float)n.z);
        this.tess.func_78374_a(p.x, p.y, p.z, u, v);
        if (indexInFace == 2 && this.glMode == 4) {
            this.tess.func_78374_a(p.x, p.y, p.z, u, v);
        }
    }

    @Override
    public void end() {
    }
}

