/*
 * Decompiled with CFR 0.152.
 */
package gcewing.projectblue;

import gcewing.projectblue.BaseGui;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiTextField;

public class BaseGuiFields {

    public static class FloatField
    extends StringField {
        public double minValue = Double.MIN_VALUE;
        public double maxValue = Double.MAX_VALUE;

        public FloatField(int charsWide, String format, BaseGui.Ref target) {
            super(charsWide, target);
            this.format = format;
            this.charsAllowed = "0123456789.-eE";
        }

        @Override
        protected Object parseValue(String text) {
            double value = 0.0;
            if (text.length() > 0) {
                value = Double.parseDouble(text);
            }
            if (value < this.minValue) {
                value = this.minValue;
            }
            if (value > this.maxValue) {
                value = this.maxValue;
            }
            return new Double(value);
        }
    }

    public static class IntField
    extends StringField {
        public int minValue = Integer.MIN_VALUE;
        public int maxValue = Integer.MAX_VALUE;

        public IntField(int charsWide, BaseGui.Ref target) {
            super(charsWide, target);
            this.format = "%d";
            this.charsAllowed = "0123456789-";
        }

        @Override
        protected Object parseValue(String text) {
            int value = 0;
            if (text.length() > 0) {
                value = Integer.parseInt(text);
            }
            if (value < this.minValue) {
                value = this.minValue;
            }
            if (value > this.maxValue) {
                value = this.maxValue;
            }
            return new Integer(value);
        }
    }

    public static class StringField
    extends BaseGui.Widget {
        public int left;
        public int top;
        public Object targeObject;
        public BaseGui.Ref target;
        public String format;
        public String charsAllowed;
        protected GuiTextField base;
        protected BaseGui.IWidgetContainer parent;
        protected boolean isOpen;

        public StringField(int charsWide, BaseGui.Ref target) {
            this((charsWide + 1) * 6, 12, target);
        }

        public StringField(int width, int height, BaseGui.Ref target) {
            super(width, height);
            this.base = new GuiTextField(Minecraft.func_71410_x().field_71466_p, 0, 0, width, height);
            this.target = target;
        }

        @Override
        public void draw(BaseGui.Screen scr, int mouseX, int mouseY) {
            if (!this.isOpen) {
                this.load();
            }
            this.base.func_146194_f();
        }

        @Override
        public void mousePressed(BaseGui.MouseCoords m, int button) {
            this.open();
            this.base.func_146192_a(m.x, m.y, button);
        }

        @Override
        public boolean keyPressed(char c, int key) {
            if (key == 1) {
                this.close();
                return false;
            }
            if (c == '\r') {
                this.close();
                return true;
            }
            if (c < ' ' || c == '\u007f' || key == 14 || key == 199 || key == 203 || key == 205 || key == 207 || key == 211 || this.charAllowed(c)) {
                this.open();
                this.base.func_146201_a(c, key);
                return true;
            }
            return false;
        }

        protected boolean charAllowed(char c) {
            return this.charsAllowed == null || this.charsAllowed.indexOf(c) >= 0;
        }

        @Override
        public void focusChanged(boolean state) {
            if (state) {
                this.open();
            } else {
                this.close();
            }
            this.base.func_146195_b(state);
        }

        protected void open() {
            if (!this.isOpen) {
                this.isOpen = true;
                this.load();
            }
        }

        @Override
        public void close() {
            if (this.isOpen) {
                this.save();
                this.isOpen = false;
            }
        }

        protected void load() {
            this.base.func_146180_a(this.formatValue(this.target.get()));
        }

        protected void save() {
            try {
                this.target.set(this.parseValue(this.base.func_146179_b()));
            }
            catch (IllegalArgumentException e) {
                this.load();
            }
        }

        protected String formatValue(Object value) {
            if (this.format != null) {
                return String.format(this.format, value);
            }
            return (String)value;
        }

        protected Object parseValue(String text) {
            return text;
        }
    }
}

