/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.opis.swing.panels.timingclient;

import java.awt.Component;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.DefaultTableModel;
import mcp.mobius.opis.api.IMessageHandler;
import mcp.mobius.opis.api.ITabPanel;
import mcp.mobius.opis.data.holders.clienttypes.DataRenderEvent;
import mcp.mobius.opis.data.holders.newtypes.CachedString;
import mcp.mobius.opis.data.holders.newtypes.DataEvent;
import mcp.mobius.opis.data.holders.newtypes.DataTiming;
import mcp.mobius.opis.network.PacketBase;
import mcp.mobius.opis.network.enums.Message;
import mcp.mobius.opis.swing.SelectedTab;
import mcp.mobius.opis.swing.actions.ActionRunOpisClient;
import mcp.mobius.opis.swing.widgets.JTableStats;
import mcp.mobius.shadow.net.miginfocom.swing.MigLayout;

public class PanelEventClient
extends JPanel
implements ITabPanel,
IMessageHandler {
    private static final long serialVersionUID = -1580335760456742927L;
    private JTableStats table;
    private JButton btnRunRender;

    public PanelEventClient() {
        this.setLayout(new MigLayout("", "[grow][grow][]", "[][grow][]"));
        this.btnRunRender = new JButton("Run Render");
        this.add((Component)this.btnRunRender, "cell 2 0");
        this.btnRunRender.addActionListener(new ActionRunOpisClient());
        JScrollPane scrollPane = new JScrollPane();
        this.add((Component)scrollPane, "cell 0 1 3 1,grow");
        this.table = new JTableStats(new String[]{"Event", "Mod", "Class", "Handler", "Calls", "Timing"}, new Class[]{CachedString.class, CachedString.class, CachedString.class, CachedString.class, Long.class, DataTiming.class}, new int[]{2, 2, 2, 2, 0, 0});
        scrollPane.setViewportView(this.table);
    }

    public void setTable(ArrayList<DataRenderEvent> data) {
        DefaultTableModel model = this.table.getModel();
        int row = this.updateData(this.table, model, DataEvent.class);
        for (DataRenderEvent o : data) {
            model.addRow(new Object[]{o.event, o.mod, o.package_, o.handler, o.nCalls, o.update});
        }
        this.dataUpdated(this.table, model, row);
    }

    public JTableStats getTable() {
        return this.table;
    }

    public <U> int updateData(JTable table, DefaultTableModel model, Class<U> datatype) {
        int row = table.getSelectedRow();
        if (model.getRowCount() > 0) {
            for (int i = model.getRowCount() - 1; i >= 0; --i) {
                model.removeRow(i);
            }
        }
        return row;
    }

    public void dataUpdated(JTable table, DefaultTableModel model, int row) {
        model.fireTableDataChanged();
        try {
            table.setRowSelectionInterval(row, row);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public JButton getBtnRunRender() {
        return this.btnRunRender;
    }

    @Override
    public boolean handleMessage(Message msg, PacketBase rawdata) {
        return false;
    }

    @Override
    public SelectedTab getSelectedTab() {
        return SelectedTab.CLIENTEVENTS;
    }

    @Override
    public boolean refreshOnString() {
        return false;
    }

    @Override
    public boolean refresh() {
        return false;
    }
}

