/*
 * Decompiled with CFR 0.152.
 */
package openmodularturrets.tileentity.turrets;

import net.minecraft.entity.Entity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import openmodularturrets.entity.projectiles.RocketProjectile;
import openmodularturrets.entity.projectiles.TurretProjectile;
import openmodularturrets.handler.ConfigHandler;
import openmodularturrets.items.Items;
import openmodularturrets.tileentity.turrets.TurretHead;

public class RocketTurretTileEntity
extends TurretHead {
    public RocketTurretTileEntity() {
        this.turretTier = 4;
    }

    @Override
    public int getTurretRange() {
        return ConfigHandler.getRocketTurretSettings().getRange();
    }

    @Override
    public int getTurretPowerUsage() {
        return ConfigHandler.getRocketTurretSettings().getPowerUsage();
    }

    @Override
    public int getTurretFireRate() {
        return ConfigHandler.getRocketTurretSettings().getFireRate();
    }

    @Override
    public double getTurretAccuracy() {
        return ConfigHandler.getRocketTurretSettings().getAccuracy() / 10.0;
    }

    @Override
    public boolean requiresAmmo() {
        return true;
    }

    @Override
    public boolean requiresSpecificAmmo() {
        return true;
    }

    @Override
    public Item getAmmo() {
        return Items.rocketCraftable;
    }

    @Override
    public TurretProjectile createProjectile(World world, Entity target, ItemStack ammo) {
        return new RocketProjectile(world, target, ammo, this.getBase());
    }

    @Override
    public String getLaunchSoundEffect() {
        return "rocket";
    }
}

