/*
 * Decompiled with CFR 0.152.
 */
package openmods.calc.types.multi;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import openmods.calc.BinaryOperator;
import openmods.calc.FixedCallable;
import openmods.calc.Frame;
import openmods.calc.FrameFactory;
import openmods.calc.ICallable;
import openmods.calc.IExecutable;
import openmods.calc.LocalSymbolMap;
import openmods.calc.SingleReturnCallable;
import openmods.calc.SymbolCall;
import openmods.calc.SymbolMap;
import openmods.calc.Value;
import openmods.calc.parsing.BinaryOpNode;
import openmods.calc.parsing.BracketContainerNode;
import openmods.calc.parsing.ICompilerState;
import openmods.calc.parsing.IExprNode;
import openmods.calc.parsing.ISymbolCallStateTransition;
import openmods.calc.parsing.SameStateSymbolTransition;
import openmods.calc.parsing.SymbolCallNode;
import openmods.calc.types.multi.BindPatternEvaluator;
import openmods.calc.types.multi.BindPatternTranslator;
import openmods.calc.types.multi.CallableValue;
import openmods.calc.types.multi.Code;
import openmods.calc.types.multi.IBindPattern;
import openmods.calc.types.multi.MetaObjectUtils;
import openmods.calc.types.multi.TypeDomain;
import openmods.calc.types.multi.TypedCalcUtils;
import openmods.calc.types.multi.TypedValue;
import openmods.utils.OptionalInt;
import openmods.utils.Stack;

public class MatchExpressionFactory {
    private static final String SYMBOL_DEFAULT_ACTION = "default";
    private static final String SYMBOL_GUARDED_ACTION = "guarded";
    private static final String SYMBOL_PATTERN_VAR = "var";
    private final TypeDomain domain;
    private final BinaryOperator<TypedValue> split;
    private final BinaryOperator<TypedValue> lambda;
    private final BindPatternEvaluator patternEvaluator;
    private final BindPatternTranslator patternTranslator;
    private final Function<IExprNode<TypedValue>, PatternCompiler> caseNodeCoverter = new Function<IExprNode<TypedValue>, PatternCompiler>(){

        public PatternCompiler apply(IExprNode<TypedValue> input) {
            Preconditions.checkState((boolean)(input instanceof BinaryOpNode), (Object)"Invalid 'match' syntax");
            BinaryOpNode patternNode = (BinaryOpNode)input;
            List<IExprNode<TypedValue>> varMatchers = this.extractVarMatchers(patternNode.left);
            if (patternNode.operator == MatchExpressionFactory.this.lambda) {
                return new PatternCompiler(varMatchers, (List<? extends ActionCompiler>)ImmutableList.of((Object)new DefaultActionCompiler(patternNode.right)));
            }
            if (patternNode.operator == MatchExpressionFactory.this.split) {
                ArrayList compilers = Lists.newArrayList();
                this.extractGuards(compilers, patternNode.right);
                return new PatternCompiler(varMatchers, compilers);
            }
            throw new IllegalStateException("Invalid 'match' syntax, expected '->' between pattern and action or \\ between pattern and guarded actions, got" + patternNode.operator);
        }

        private List<IExprNode<TypedValue>> extractVarMatchers(IExprNode<TypedValue> arg) {
            if (arg instanceof BracketContainerNode) {
                return ImmutableList.copyOf(arg.getChildren());
            }
            throw new IllegalStateException("Expected argument list, got " + arg);
        }

        private void extractGuards(List<ActionCompiler> compilers, IExprNode<TypedValue> clause) {
            if (clause instanceof BinaryOpNode) {
                BinaryOpNode op = (BinaryOpNode)clause;
                if (op.operator == MatchExpressionFactory.this.split) {
                    Preconditions.checkState((boolean)(op.left instanceof BinaryOpNode), (String)"Invalid 'match' syntax: expected guard -> action on left side of \\, got: ", (Object[])new Object[]{op.left});
                    BinaryOpNode left = (BinaryOpNode)op.left;
                    Preconditions.checkState((left.operator == MatchExpressionFactory.this.lambda ? 1 : 0) != 0, (String)"Invalid 'match' syntax: expected guard -> action on left side of \\, got: %s", (Object[])new Object[]{left.operator});
                    compilers.add(this.extractGuardedPattern(left));
                    this.extractGuards(compilers, op.right);
                } else if (op.operator == MatchExpressionFactory.this.lambda) {
                    compilers.add(this.extractGuardedPattern(op));
                } else {
                    compilers.add(new DefaultActionCompiler(clause));
                }
            } else {
                compilers.add(new DefaultActionCompiler(clause));
            }
        }

        private ActionCompiler extractGuardedPattern(BinaryOpNode<TypedValue> op) {
            return new GuardedActionCompiler(op.left, op.right);
        }
    };

    public MatchExpressionFactory(TypeDomain domain, BinaryOperator<TypedValue> split, BinaryOperator<TypedValue> lambda) {
        this.domain = domain;
        this.split = split;
        this.lambda = lambda;
        this.domain.registerType(PatternMatcher.class, "case");
        this.patternEvaluator = new BindPatternEvaluator(this.domain);
        this.patternTranslator = new BindPatternTranslator();
    }

    public ISymbolCallStateTransition<TypedValue> createStateTransition(ICompilerState<TypedValue> compilerState) {
        return new MatchStateTransition(compilerState);
    }

    public void registerSymbols(SymbolMap<TypedValue> env, SymbolMap<TypedValue> patternEnv) {
        env.put("match", (TypedValue)((Object)new MatchSymbol()));
        env.put("case", (TypedValue)((Object)new CaseSymbol(patternEnv)));
    }

    private class MatchSymbol
    extends SingleReturnCallable<TypedValue> {
        private MatchSymbol() {
        }

        @Override
        public TypedValue call(Frame<TypedValue> frame, OptionalInt argumentsCount) {
            Preconditions.checkArgument((boolean)argumentsCount.isPresent(), (Object)"'match' must be called with argument count");
            Stack<TypedValue> stack = frame.stack();
            ArrayList patterns = Lists.newArrayList();
            for (int i = 0; i < argumentsCount.get(); ++i) {
                TypedValue arg = stack.pop();
                patterns.add(arg.as(PatternMatcher.class));
            }
            return CallableValue.wrap(MatchExpressionFactory.this.domain, new MatchingFunction(frame.symbols(), Lists.reverse((List)patterns)));
        }
    }

    private static class MatchingFunction
    implements ICallable<TypedValue> {
        private final SymbolMap<TypedValue> defineScope;
        private final List<PatternMatcher> cases;

        public MatchingFunction(SymbolMap<TypedValue> defineScope, List<PatternMatcher> cases) {
            this.defineScope = defineScope;
            this.cases = ImmutableList.copyOf(cases);
        }

        @Override
        public void call(Frame<TypedValue> frame, OptionalInt argumentsCount, OptionalInt returnsCount) {
            Stack<TypedValue> stack = frame.stack();
            Frame<TypedValue> env = FrameFactory.createProtectionFrame(this.defineScope);
            for (PatternMatcher matchCase : this.cases) {
                Stack<TypedValue> valuesToMatchStack;
                ImmutableList valuesToMatch;
                LocalSymbolMap<TypedValue> matchedSymbols;
                Optional<Code> match;
                int args = matchCase.requiredArgs();
                if ((!argumentsCount.isPresent() ? stack.size() < args : argumentsCount.get() != args) || !(match = matchCase.match(env, matchedSymbols = new LocalSymbolMap<TypedValue>(this.defineScope), (List<TypedValue>)(valuesToMatch = ImmutableList.copyOf(valuesToMatchStack = stack.substack(args))))).isPresent()) continue;
                valuesToMatchStack.clear();
                Frame<TypedValue> matchedFrame = FrameFactory.newClosureFrame(matchedSymbols, frame, 0);
                ((Code)match.get()).execute(matchedFrame);
                TypedCalcUtils.expectExactReturnCount(returnsCount, matchedFrame.stack().size());
                return;
            }
            throw new MatchFailedException("Can't find matching case");
        }
    }

    public static class MatchFailedException
    extends RuntimeException {
        private static final long serialVersionUID = -6897909046702800612L;

        public MatchFailedException(String message) {
            super(message);
        }
    }

    private class CaseSymbol
    extends FixedCallable<TypedValue> {
        private final SymbolMap<TypedValue> topSymbolMap;

        public CaseSymbol(SymbolMap<TypedValue> topSymbolMap) {
            super(1, 1);
            this.topSymbolMap = topSymbolMap;
        }

        @Override
        public void call(Frame<TypedValue> frame) {
            Stack<TypedValue> stack = frame.stack();
            Code pattern = stack.pop().as(Code.class, "pattern constructor code (first arg)");
            PatternMatcher result = this.evaluatePattern(pattern, this.topSymbolMap);
            stack.push(MatchExpressionFactory.this.domain.create(PatternMatcher.class, result));
        }

        private PatternMatcher evaluatePattern(Code pattern, SymbolMap<TypedValue> topSymbolMap) {
            Frame<TypedValue> executionFrame = FrameFactory.createTopFrame();
            SymbolMap<FixedCallable> executionSymbols = executionFrame.symbols();
            PatternMatcherBuilder builder = new PatternMatcherBuilder();
            executionSymbols.put(MatchExpressionFactory.SYMBOL_PATTERN_VAR, new PatternMatcherBuilderVarSymbol(builder, topSymbolMap));
            executionSymbols.put(MatchExpressionFactory.SYMBOL_GUARDED_ACTION, new PatternMatcherBuilderBuilderGuardedActionSymbol(builder));
            executionSymbols.put(MatchExpressionFactory.SYMBOL_DEFAULT_ACTION, new PatternMatcherBuilderDefaultActionSymbol(builder));
            pattern.execute(executionFrame);
            executionFrame.stack().checkIsEmpty();
            return builder.buildPattern();
        }
    }

    private class PatternMatcherBuilder {
        private final List<IBindPattern> varPatterns = Lists.newArrayList();
        private final List<GuardedAction> guardedActions = Lists.newArrayList();
        private Optional<Code> defaultAction = Optional.absent();
        private boolean firstActionAdded;

        private PatternMatcherBuilder() {
        }

        public void addVarPattern(IBindPattern pattern) {
            Preconditions.checkState((!this.firstActionAdded ? 1 : 0) != 0, (Object)"Trying to add variable pattern after action");
            this.varPatterns.add(pattern);
        }

        public void addGuardedAction(GuardedAction guardedPatternClause) {
            Preconditions.checkState((!this.defaultAction.isPresent() ? 1 : 0) != 0, (Object)"Trying to add guarded action after default");
            this.firstActionAdded = true;
            this.guardedActions.add(guardedPatternClause);
        }

        public void addDefaultAction(Code action) {
            this.firstActionAdded = true;
            this.defaultAction = Optional.of((Object)action);
        }

        public PatternMatcher buildPattern() {
            if (this.guardedActions.isEmpty()) {
                Preconditions.checkState((boolean)this.defaultAction.isPresent(), (Object)"Invalid 'pattern' arguments");
                return new UnguardedPatternMatcher(this.varPatterns, this.defaultAction);
            }
            return new GuardedPatternMatcher(this.varPatterns, this.guardedActions, this.defaultAction);
        }
    }

    private static class PatternMatcherBuilderDefaultActionSymbol
    extends FixedCallable<TypedValue> {
        private final PatternMatcherBuilder parent;

        public PatternMatcherBuilderDefaultActionSymbol(PatternMatcherBuilder parent) {
            super(1, 0);
            this.parent = parent;
        }

        @Override
        public void call(Frame<TypedValue> frame) {
            Stack<TypedValue> stack = frame.stack();
            Code action = stack.pop().as(Code.class, "case action");
            this.parent.addDefaultAction(action);
        }
    }

    private static class PatternMatcherBuilderBuilderGuardedActionSymbol
    extends FixedCallable<TypedValue> {
        private final PatternMatcherBuilder parent;

        public PatternMatcherBuilderBuilderGuardedActionSymbol(PatternMatcherBuilder parent) {
            super(2, 0);
            this.parent = parent;
        }

        @Override
        public void call(Frame<TypedValue> frame) {
            Stack<TypedValue> stack = frame.stack();
            Code action = stack.pop().as(Code.class, "case action");
            Code guard = stack.pop().as(Code.class, "case guard");
            this.parent.addGuardedAction(new GuardedAction(guard, action));
        }
    }

    private class PatternMatcherBuilderVarSymbol
    extends FixedCallable<TypedValue> {
        private final PatternMatcherBuilder parent;
        private final SymbolMap<TypedValue> topSymbolMap;

        public PatternMatcherBuilderVarSymbol(PatternMatcherBuilder parent, SymbolMap<TypedValue> topSymbolMap) {
            super(1, 0);
            this.parent = parent;
            this.topSymbolMap = topSymbolMap;
        }

        @Override
        public void call(Frame<TypedValue> frame) {
            Code pattern = frame.stack().pop().as(Code.class, "variable pattern");
            TypedValue compiledPattern = MatchExpressionFactory.this.patternEvaluator.evaluate(this.topSymbolMap, pattern);
            IBindPattern translatedPattern = MatchExpressionFactory.this.patternTranslator.translatePattern(compiledPattern);
            this.parent.addVarPattern(translatedPattern);
        }
    }

    private class MatchStateTransition
    extends SameStateSymbolTransition<TypedValue> {
        public MatchStateTransition(ICompilerState<TypedValue> compilerState) {
            super(compilerState);
        }

        @Override
        public IExprNode<TypedValue> createRootNode(List<IExprNode<TypedValue>> children) {
            return new MatchNode(children);
        }
    }

    private class MatchNode
    extends SymbolCallNode<TypedValue> {
        public MatchNode(List<IExprNode<TypedValue>> children) {
            super("match", children);
        }

        @Override
        public void flatten(List<IExecutable<TypedValue>> output) {
            int patternCount = 0;
            for (PatternCompiler e : Iterables.transform(this.getChildren(), (Function)MatchExpressionFactory.this.caseNodeCoverter)) {
                e.flatten(output);
                ++patternCount;
            }
            Preconditions.checkArgument((patternCount > 0 ? 1 : 0) != 0, (Object)"'match' expects at least one argument");
            output.add(new SymbolCall("match", patternCount, 1));
        }
    }

    private class PatternCompiler {
        private final List<IExprNode<TypedValue>> argBindPatterns;
        private final List<? extends ActionCompiler> actions;

        public PatternCompiler(List<IExprNode<TypedValue>> bindPatterns, List<? extends ActionCompiler> actions) {
            this.argBindPatterns = bindPatterns;
            this.actions = actions;
        }

        public void flatten(List<IExecutable<TypedValue>> output) {
            ArrayList patternCompileCode = Lists.newArrayList();
            for (IExprNode<TypedValue> iExprNode : this.argBindPatterns) {
                patternCompileCode.add(Value.create(Code.flattenAndWrap(MatchExpressionFactory.this.domain, iExprNode)));
                patternCompileCode.add(new SymbolCall(MatchExpressionFactory.SYMBOL_PATTERN_VAR, 1, 0));
            }
            for (ActionCompiler actionCompiler : this.actions) {
                actionCompiler.flatten(patternCompileCode);
            }
            output.add(Value.create(Code.wrap(MatchExpressionFactory.this.domain, patternCompileCode)));
            output.add(new SymbolCall("case", 1, 1));
        }
    }

    private class DefaultActionCompiler
    implements ActionCompiler {
        private final IExprNode<TypedValue> action;

        public DefaultActionCompiler(IExprNode<TypedValue> action) {
            this.action = action;
        }

        @Override
        public void flatten(List<IExecutable<TypedValue>> output) {
            output.add(Value.create(Code.flattenAndWrap(MatchExpressionFactory.this.domain, this.action)));
            output.add(new SymbolCall(MatchExpressionFactory.SYMBOL_DEFAULT_ACTION, 1, 0));
        }
    }

    private class GuardedActionCompiler
    implements ActionCompiler {
        private final IExprNode<TypedValue> guard;
        private final IExprNode<TypedValue> action;

        public GuardedActionCompiler(IExprNode<TypedValue> guard, IExprNode<TypedValue> action) {
            this.guard = guard;
            this.action = action;
        }

        @Override
        public void flatten(List<IExecutable<TypedValue>> output) {
            output.add(Value.create(Code.flattenAndWrap(MatchExpressionFactory.this.domain, this.guard)));
            output.add(Value.create(Code.flattenAndWrap(MatchExpressionFactory.this.domain, this.action)));
            output.add(new SymbolCall(MatchExpressionFactory.SYMBOL_GUARDED_ACTION, 2, 0));
        }
    }

    private static interface ActionCompiler {
        public void flatten(List<IExecutable<TypedValue>> var1);
    }

    private static class GuardedPatternMatcher
    extends PatternMatcher {
        public final List<GuardedAction> guardedActions;
        public final Optional<Code> defaultAction;

        public GuardedPatternMatcher(List<IBindPattern> patterns, List<GuardedAction> guardedActions, Optional<Code> defaultAction) {
            super(patterns);
            this.guardedActions = ImmutableList.copyOf(guardedActions);
            this.defaultAction = defaultAction;
        }

        @Override
        protected Optional<Code> matchGuard(Frame<TypedValue> env, SymbolMap<TypedValue> output) {
            Frame<TypedValue> clauseEnv = FrameFactory.createProtectionFrame(output);
            Stack<TypedValue> clauseEnvStack = clauseEnv.stack();
            for (GuardedAction clause : this.guardedActions) {
                clause.guard.execute(clauseEnv);
                TypedValue result = clauseEnvStack.popAndExpectEmptyStack();
                if (!MetaObjectUtils.boolValue(env, result)) continue;
                return clause.action;
            }
            return this.defaultAction;
        }
    }

    private static class GuardedAction {
        public final Code guard;
        public final Optional<Code> action;

        public GuardedAction(Code guard, Code action) {
            this.guard = guard;
            this.action = Optional.of((Object)action);
        }
    }

    private static class UnguardedPatternMatcher
    extends PatternMatcher {
        private final Optional<Code> action;

        public UnguardedPatternMatcher(List<IBindPattern> patterns, Optional<Code> action) {
            super(patterns);
            this.action = action;
        }

        @Override
        protected Optional<Code> matchGuard(Frame<TypedValue> env, SymbolMap<TypedValue> output) {
            return this.action;
        }
    }

    private static abstract class PatternMatcher {
        private final List<IBindPattern> argPatterns;

        public PatternMatcher(List<IBindPattern> argPatterns) {
            this.argPatterns = argPatterns;
        }

        public Optional<Code> match(Frame<TypedValue> env, SymbolMap<TypedValue> output, List<TypedValue> values) {
            Preconditions.checkState((values.size() == this.argPatterns.size() ? 1 : 0) != 0, (String)"Invalid usage: expected %s values, got %s", (Object[])new Object[]{this.argPatterns.size(), values.size()});
            for (int i = 0; i < values.size(); ++i) {
                TypedValue value = values.get(i);
                IBindPattern pattern = this.argPatterns.get(i);
                if (pattern.match(env, output, value)) continue;
                return Optional.absent();
            }
            return this.matchGuard(env, output);
        }

        protected abstract Optional<Code> matchGuard(Frame<TypedValue> var1, SymbolMap<TypedValue> var2);

        public int requiredArgs() {
            return this.argPatterns.size();
        }
    }
}

