/*
 * Decompiled with CFR 0.152.
 */
package codechicken.nei.recipe;

import codechicken.nei.ItemList;
import codechicken.nei.api.IRecipeFilter;
import codechicken.nei.recipe.GuiRecipe;
import codechicken.nei.recipe.IRecipeHandler;
import codechicken.nei.recipe.TemplateRecipeHandler;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ForkJoinTask;
import java.util.function.IntPredicate;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;

class SearchRecipeHandler<H extends IRecipeHandler> {
    public H original;
    private List<Integer> filteredRecipes;
    private List<Integer> searchRecipes;

    public SearchRecipeHandler(H handler) {
        this.original = handler;
        if (this.original.numRecipes() == 0) {
            this.filteredRecipes = new ArrayList<Integer>();
        } else {
            Stream<Integer> items = IntStream.range(0, this.original.numRecipes()).boxed();
            IRecipeFilter filter = this.searchingAvailable() ? GuiRecipe.getRecipeListFilter() : null;
            this.filteredRecipes = filter == null ? (List)items.collect(Collectors.toCollection(ArrayList::new)) : (List)items.filter(recipe -> SearchRecipeHandler.mathRecipe(this.original, recipe, filter)).collect(Collectors.toCollection(ArrayList::new));
        }
    }

    protected static boolean mathRecipe(IRecipeHandler handler, int recipe, IRecipeFilter filter) {
        return filter.matches(handler, handler.getIngredientStacks(recipe), handler.getResultStack(recipe), handler.getOtherStacks(recipe));
    }

    public boolean searchingAvailable() {
        return SearchRecipeHandler.searchingAvailable(this.original);
    }

    private static boolean searchingAvailable(IRecipeHandler handler) {
        return handler instanceof TemplateRecipeHandler;
    }

    public static int findFirst(IRecipeHandler handler, IntPredicate predicate) {
        IRecipeFilter filter = SearchRecipeHandler.searchingAvailable(handler) ? GuiRecipe.getRecipeListFilter() : null;
        int refIndex = -1;
        for (int recipeIndex = 0; recipeIndex < handler.numRecipes(); ++recipeIndex) {
            if (filter != null && !SearchRecipeHandler.mathRecipe(handler, recipeIndex, filter)) continue;
            ++refIndex;
            if (!predicate.test(recipeIndex)) continue;
            return refIndex;
        }
        return -1;
    }

    public List<Integer> getSearchResult(IRecipeFilter filter) {
        if (this.filteredRecipes.isEmpty() || !this.searchingAvailable()) {
            return null;
        }
        List filtered = null;
        List recipes = IntStream.range(0, this.filteredRecipes.size()).boxed().collect(Collectors.toCollection(ArrayList::new));
        try {
            filtered = (List)((ForkJoinTask)ItemList.forkJoinPool.submit(() -> recipes.parallelStream().filter(recipe -> SearchRecipeHandler.mathRecipe(this.original, this.filteredRecipes.get((int)recipe), filter)).collect(Collectors.toCollection(ArrayList::new)))).get();
            filtered.sort((a, b) -> a - b);
        }
        catch (InterruptedException | ExecutionException e) {
            e.printStackTrace();
        }
        return filtered;
    }

    public void setSearchIndices(List<Integer> searchRecipes) {
        this.searchRecipes = searchRecipes;
    }

    public int ref(int index) {
        if (this.searchRecipes != null) {
            index = this.searchRecipes.get(index);
        }
        return this.filteredRecipes.get(index);
    }

    public int numRecipes() {
        if (this.searchRecipes != null) {
            return this.searchRecipes.size();
        }
        return this.filteredRecipes.size();
    }
}

