/*
 * Decompiled with CFR 0.152.
 */
package codechicken.nei;

import codechicken.lib.gui.GuiDraw;
import codechicken.nei.FormattedTextField;
import codechicken.nei.ItemList;
import codechicken.nei.ItemPanels;
import codechicken.nei.NEIClientConfig;
import codechicken.nei.SearchTextFormatter;
import codechicken.nei.SearchTokenParser;
import codechicken.nei.TextField;
import codechicken.nei.api.ItemFilter;
import codechicken.nei.recipe.StackInfo;
import codechicken.nei.util.TextHistory;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import net.minecraft.client.Minecraft;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumChatFormatting;
import net.minecraftforge.fluids.FluidStack;

public class SearchField
extends TextField
implements ItemFilter.ItemFilterProvider {
    @Deprecated
    public static List<ISearchProvider> searchProviders = new LinkedList<ISearchProvider>();
    public static final SearchTokenParser searchParser = new SearchTokenParser();
    private static final TextHistory history = new TextHistory();
    private boolean isVisible = true;
    private long lastclicktime;

    public SearchField(String ident) {
        super(ident);
    }

    @Override
    protected void initInternalTextField() {
        this.field = new GuiSearchField();
        this.field.func_146203_f(256);
        this.field.func_146196_d();
    }

    public static boolean searchInventories() {
        return NEIClientConfig.world.nbt.func_74767_n("searchinventories");
    }

    public boolean isVisible() {
        return this.isVisible;
    }

    public void setVisible(boolean visible) {
        this.isVisible = visible;
    }

    @Override
    public int getTextColour() {
        if (ItemPanels.itemPanel.getItems().isEmpty()) {
            return this.focused() ? -3394816 : -6737152;
        }
        return this.focused() ? -2039584 : -7303024;
    }

    @Override
    public void draw(int mousex, int mousey) {
        super.draw(mousex, mousey);
        if (SearchField.searchInventories()) {
            GuiDraw.drawGradientRect((int)(this.field.field_146209_f - 1), (int)(this.field.field_146210_g - 1), (int)1, (int)(this.field.field_146219_i + 2), (int)-256, (int)-4149248);
            GuiDraw.drawGradientRect((int)(this.field.field_146209_f - 1), (int)(this.field.field_146210_g - 1), (int)(this.field.field_146218_h + 2), (int)1, (int)-256, (int)-4149248);
            GuiDraw.drawGradientRect((int)(this.field.field_146209_f + this.field.field_146218_h), (int)(this.field.field_146210_g - 1), (int)1, (int)(this.field.field_146219_i + 2), (int)-256, (int)-4149248);
            GuiDraw.drawGradientRect((int)(this.field.field_146209_f - 1), (int)(this.field.field_146210_g + this.field.field_146219_i), (int)(this.field.field_146218_h + 2), (int)1, (int)-256, (int)-4149248);
        }
    }

    @Override
    public boolean handleClick(int mousex, int mousey, int button) {
        if (button == 0) {
            if (this.focused() && System.currentTimeMillis() - this.lastclicktime < 400L) {
                NEIClientConfig.world.nbt.func_74757_a("searchinventories", !SearchField.searchInventories());
            }
            this.lastclicktime = System.currentTimeMillis();
        }
        return super.handleClick(mousex, mousey, button);
    }

    @Override
    public void onTextChange(String oldText) {
        String newText = this.text();
        if (!newText.equals(oldText)) {
            if (newText.length() > 0) {
                NEIClientConfig.logger.debug("Searching for " + newText);
            }
            NEIClientConfig.setSearchExpression(newText);
            ItemList.updateFilter.restart();
        }
    }

    @Override
    public void lastKeyTyped(int keyID, char keyChar) {
        if (this.isVisible() && NEIClientConfig.isKeyHashDown("gui.search")) {
            this.setFocus(true);
        }
        if (this.focused() && NEIClientConfig.isKeyHashDown("gui.getprevioussearch")) {
            this.handleNavigateHistory(TextHistory.Direction.PREVIOUS);
        }
        if (this.focused() && NEIClientConfig.isKeyHashDown("gui.getnextsearch")) {
            this.handleNavigateHistory(TextHistory.Direction.NEXT);
        }
    }

    @Override
    public String filterText(String s) {
        return EnumChatFormatting.func_110646_a((String)s);
    }

    public static Pattern getPattern(String search) {
        return SearchField.getPattern(search, NEIClientConfig.getIntSetting("inventory.search.patternMode"));
    }

    public static Pattern getPattern(String search, int patternMode) {
        switch (patternMode) {
            case 0: {
                search = Pattern.quote(search);
                break;
            }
            case 1: {
                if (search.length() >= 3 && search.startsWith("r/") && search.endsWith("/")) {
                    search = search.substring(2, search.length() - 1);
                    break;
                }
                Matcher matcher = Pattern.compile("(\\?|\\*)").matcher(search);
                StringBuilder cleanedString = new StringBuilder();
                int lastEndIndex = 0;
                while (matcher.find()) {
                    cleanedString.append(Pattern.quote(search.substring(lastEndIndex, matcher.start())));
                    switch (matcher.group(0).charAt(0)) {
                        case '?': {
                            cleanedString.append(".");
                            break;
                        }
                        case '*': {
                            cleanedString.append(".+?");
                            break;
                        }
                    }
                    lastEndIndex = matcher.end();
                }
                search = cleanedString + Pattern.quote(search.substring(lastEndIndex, search.length()));
                break;
            }
        }
        if (!search.isEmpty()) {
            try {
                return Pattern.compile(search, 74);
            }
            catch (PatternSyntaxException patternSyntaxException) {
                // empty catch block
            }
        }
        return null;
    }

    public static String getEscapedSearchText(ItemStack stack) {
        FluidStack fluidStack = StackInfo.isFluidContainer(stack) ? null : StackInfo.getFluid(stack);
        String displayName = fluidStack != null ? fluidStack.getLocalizedName() : stack.func_82833_r();
        return SearchField.getEscapedSearchText(displayName);
    }

    public static String getEscapedSearchText(String text) {
        text = EnumChatFormatting.func_110646_a((String)text);
        switch (NEIClientConfig.getIntSetting("inventory.search.patternMode")) {
            case 1: {
                text = text.replaceAll("[\\?|\\*]", "\\\\$0");
                break;
            }
            case 2: {
                text = text.replaceAll("[{}()\\[\\].+*?^$\\\\|]", "\\\\$0");
                break;
            }
        }
        if (text.contains(" ") && NEIClientConfig.getBooleanSetting("inventory.search.quoteDropItemName")) {
            text = "\"" + text + "\"";
        }
        return text;
    }

    @Override
    public ItemFilter getFilter() {
        return ((GuiSearchField)this.field).getFilter();
    }

    public static ItemFilter getFilter(String filterText) {
        return searchParser.getFilter(filterText);
    }

    @Override
    public void setFocus(boolean focus) {
        boolean previousFocus = this.field.func_146206_l();
        if (previousFocus != focus) {
            history.add(this.text());
        }
        super.setFocus(focus);
    }

    private boolean handleNavigateHistory(TextHistory.Direction direction) {
        if (this.focused()) {
            return history.get(direction, this.text()).map(newText -> {
                this.setText((String)newText);
                return true;
            }).orElse(false);
        }
        return false;
    }

    public static class GuiSearchField
    extends FormattedTextField {
        protected final SearchTokenParser searchParser;

        public GuiSearchField() {
            this(searchParser);
        }

        public GuiSearchField(SearchTokenParser searchParser) {
            super(Minecraft.func_71410_x().field_71466_p, 0, 0, 0, 0);
            this.searchParser = searchParser;
            this.setFormatter(new SearchTextFormatter(searchParser));
        }

        public ItemFilter getFilter() {
            return this.getFilter(this.func_146179_b());
        }

        public ItemFilter getFilter(String filterText) {
            return this.searchParser.getFilter(filterText);
        }
    }

    public static class SearchParserProvider
    implements SearchTokenParser.ISearchParserProvider {
        protected final Function<Pattern, ItemFilter> createFilter;
        protected final String name;
        protected final char prefix;
        protected final EnumChatFormatting highlightedColor;

        public SearchParserProvider(char prefix, String name, EnumChatFormatting highlightedColor, Function<Pattern, ItemFilter> createFilter) {
            this.prefix = prefix;
            this.name = name;
            this.highlightedColor = highlightedColor;
            this.createFilter = createFilter;
        }

        @Override
        public ItemFilter getFilter(String searchText) {
            Pattern pattern = SearchField.getPattern(searchText);
            if (pattern != null) {
                return this.createFilter(pattern);
            }
            return new ItemList.NothingItemFilter();
        }

        protected ItemFilter createFilter(Pattern pattern) {
            ItemFilter filter = this.createFilter.apply(pattern);
            return filter == null ? new ItemList.NothingItemFilter() : filter;
        }

        @Override
        public char getPrefix() {
            return this.prefix;
        }

        @Override
        public EnumChatFormatting getHighlightedColor() {
            return this.highlightedColor;
        }

        @Override
        public SearchTokenParser.SearchMode getSearchMode() {
            return SearchTokenParser.SearchMode.fromInt(NEIClientConfig.getIntSetting("inventory.search." + this.name + "SearchMode"));
        }
    }

    @Deprecated
    public static interface ISearchProvider {
        public boolean isPrimary();

        public ItemFilter getFilter(String var1);
    }
}

