/*
 * Decompiled with CFR 0.152.
 */
package tonius.neiintegration;

import codechicken.nei.NEIServerUtils;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.ModContainer;
import cpw.mods.fml.common.versioning.DefaultArtifactVersion;
import cpw.mods.fml.common.versioning.VersionParser;
import cpw.mods.fml.common.versioning.VersionRange;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.StatCollector;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidBlock;
import net.minecraftforge.fluids.IFluidContainerItem;
import org.lwjgl.input.Keyboard;
import tonius.neiintegration.NEIIntegration;

public class Utils {
    public static String translate(String unlocalized, boolean prefix) {
        return StatCollector.func_74838_a((String)((prefix ? "neiintegration." : "") + unlocalized));
    }

    public static String translate(String unlocalized) {
        return Utils.translate(unlocalized, true);
    }

    public static boolean areStacksSameTypeCraftingSafe(ItemStack stack1, ItemStack stack2) {
        if (stack1 != null && stack2 != null) {
            return NEIServerUtils.areStacksSameTypeCrafting((ItemStack)stack1, (ItemStack)stack2);
        }
        return false;
    }

    public static List<ItemStack> getItemVariations(ItemStack base) {
        ArrayList<ItemStack> variations = new ArrayList<ItemStack>();
        base.func_77973_b().func_150895_a(base.func_77973_b(), null, variations);
        Iterator itr = variations.iterator();
        while (itr.hasNext()) {
            ItemStack stack = (ItemStack)itr.next();
            if (base.func_77969_a(stack) && stack.func_77942_o()) continue;
            itr.remove();
        }
        if (variations.isEmpty()) {
            return Collections.singletonList(base);
        }
        return variations;
    }

    public static FluidStack getFluidStack(ItemStack stack) {
        if (stack != null) {
            Fluid fluid;
            FluidStack fluidStack = null;
            Block block = Block.func_149634_a((Item)stack.func_77973_b());
            if (stack.func_77973_b() instanceof IFluidContainerItem) {
                fluidStack = ((IFluidContainerItem)stack.func_77973_b()).getFluid(stack);
            }
            if (fluidStack == null) {
                fluidStack = FluidContainerRegistry.getFluidForFilledItem((ItemStack)stack);
            }
            if (fluidStack == null && block instanceof IFluidBlock && (fluid = ((IFluidBlock)block).getFluid()) != null) {
                fluidStack = new FluidStack(fluid, 1000);
            }
            if (fluidStack == null && (block == Blocks.field_150355_j || block == Blocks.field_150358_i)) {
                fluidStack = new FluidStack(FluidRegistry.WATER, 1000);
            }
            if (fluidStack == null && (block == Blocks.field_150353_l || block == Blocks.field_150356_k)) {
                fluidStack = new FluidStack(FluidRegistry.LAVA, 1000);
            }
            return fluidStack;
        }
        return null;
    }

    public static boolean areFluidsSameType(FluidStack fluidStack1, FluidStack fluidStack2) {
        if (fluidStack1 == null || fluidStack2 == null) {
            return false;
        }
        return fluidStack1.getFluid() == fluidStack2.getFluid();
    }

    public static boolean isFluidBlock(ItemStack stack) {
        if (stack == null || stack.func_77973_b() == null) {
            return false;
        }
        Block block = Block.func_149634_a((Item)stack.func_77973_b());
        if (block == null) {
            return false;
        }
        return block instanceof IFluidBlock || block == Blocks.field_150355_j || block == Blocks.field_150358_i || block == Blocks.field_150353_l || block == Blocks.field_150356_k;
    }

    public static boolean isShiftKeyDown() {
        return Keyboard.isKeyDown((int)42) || Keyboard.isKeyDown((int)54);
    }

    public static <T> Class<T> getClass(String name) {
        try {
            return Class.forName(name);
        }
        catch (Exception e) {
            NEIIntegration.log.error("Failed to find class " + name);
            return null;
        }
    }

    public static boolean isModLoaded(String modid) {
        return Loader.isModLoaded((String)modid);
    }

    public static boolean isModLoaded(String modid, String versionRangeString) {
        if (!Utils.isModLoaded(modid)) {
            return false;
        }
        ModContainer mod = (ModContainer)Loader.instance().getIndexedModList().get(modid);
        VersionRange versionRange = VersionParser.parseRange((String)versionRangeString);
        DefaultArtifactVersion required = new DefaultArtifactVersion(modid, versionRange);
        return required.containsVersion(mod.getProcessedVersion());
    }
}

