/*
 * Decompiled with CFR 0.152.
 */
package modtweaker2.mods.mariculture.handlers;

import java.util.LinkedList;
import java.util.List;
import mariculture.api.core.MaricultureHandlers;
import mariculture.api.core.RecipeVat;
import minetweaker.IUndoableAction;
import minetweaker.MineTweakerAPI;
import minetweaker.api.item.IIngredient;
import minetweaker.api.item.IItemStack;
import minetweaker.api.liquid.ILiquidStack;
import modtweaker2.helpers.InputHelper;
import modtweaker2.helpers.LogHelper;
import modtweaker2.helpers.StackHelper;
import modtweaker2.utils.BaseListAddition;
import modtweaker2.utils.BaseListRemoval;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.mariculture.Vat")
public class Vat {
    public static final String name = "Mariculture Vat";

    @ZenMethod
    public static void addRecipe(ILiquidStack fluid1, ILiquidStack fluid2, ILiquidStack outputFluid, int time) {
        Vat.addRecipe(fluid1, fluid2, null, outputFluid, null, time);
    }

    @ZenMethod
    public static void addRecipe(ILiquidStack fluid1, ILiquidStack fluid2, IItemStack outputItem, int time) {
        Vat.addRecipe(fluid1, fluid2, null, null, outputItem, time);
    }

    @ZenMethod
    public static void addRecipe(ILiquidStack fluid1, ILiquidStack fluid2, ILiquidStack outputFluid, IItemStack outputItem, int time) {
        Vat.addRecipe(fluid1, fluid2, null, outputFluid, outputItem, time);
    }

    @ZenMethod
    public static void addRecipe(ILiquidStack fluid1, IItemStack input, ILiquidStack outputFluid, int time) {
        Vat.addRecipe(fluid1, null, input, outputFluid, null, time);
    }

    @ZenMethod
    public static void addRecipe(ILiquidStack fluid1, IItemStack input, IItemStack outputItem, int time) {
        Vat.addRecipe(fluid1, null, input, null, outputItem, time);
    }

    @ZenMethod
    public static void addRecipe(ILiquidStack fluid1, IItemStack input, ILiquidStack outputFluid, IItemStack outputItem, int time) {
        Vat.addRecipe(fluid1, null, input, outputFluid, outputItem, time);
    }

    @ZenMethod
    public static void addRecipe(ILiquidStack fluid1, ILiquidStack fluid2, IItemStack input, ILiquidStack outputFluid, int time) {
        Vat.addRecipe(fluid1, fluid2, input, outputFluid, null, time);
    }

    @ZenMethod
    public static void addRecipe(ILiquidStack fluid1, ILiquidStack fluid2, IItemStack input, IItemStack outputItem, int time) {
        Vat.addRecipe(fluid1, fluid2, input, null, outputItem, time);
    }

    @ZenMethod
    public static void addRecipe(ILiquidStack fluid1, ILiquidStack fluid2, IItemStack input, ILiquidStack outputFluid, IItemStack outputItem, int time) {
        MineTweakerAPI.apply((IUndoableAction)new Add(new RecipeVat((Object)InputHelper.toStack(input), InputHelper.toFluid(fluid1), InputHelper.toFluid(fluid2), InputHelper.toFluid(outputFluid), InputHelper.toStack(outputItem), time)));
    }

    @ZenMethod
    public static void removeRecipe(IIngredient ingredient) {
        LinkedList<RecipeVat> recipes = new LinkedList<RecipeVat>();
        for (RecipeVat r : MaricultureHandlers.vat.getRecipes()) {
            if (r == null) continue;
            if (r.outputItem != null && StackHelper.matches(ingredient, InputHelper.toIItemStack(r.outputItem))) {
                recipes.add(r);
                continue;
            }
            if (r.outputFluid == null || !StackHelper.matches(ingredient, InputHelper.toILiquidStack(r.outputFluid))) continue;
            recipes.add(r);
        }
        if (!recipes.isEmpty()) {
            MineTweakerAPI.apply((IUndoableAction)new Remove(recipes));
        } else {
            LogHelper.logWarning(String.format("No %s Recipes found for %s. Command ignored!", name, ingredient.toString()));
        }
    }

    @ZenMethod
    public static void removeRecipe(IIngredient outputItem, IIngredient outputFluid) {
        LinkedList<RecipeVat> recipes = new LinkedList<RecipeVat>();
        for (RecipeVat r : MaricultureHandlers.vat.getRecipes()) {
            if (r == null || r.outputItem == null || !StackHelper.matches(outputItem, InputHelper.toIItemStack(r.outputItem)) || r.outputFluid == null || !StackHelper.matches(outputFluid, InputHelper.toILiquidStack(r.outputFluid))) continue;
            recipes.add(r);
        }
        if (!recipes.isEmpty()) {
            MineTweakerAPI.apply((IUndoableAction)new Remove(recipes));
        } else {
            LogHelper.logWarning(String.format("No %s Recipes found for %s and %s. Command ignored!", name, outputItem.toString(), outputFluid.toString()));
        }
    }

    private static class Remove
    extends BaseListRemoval<RecipeVat> {
        public Remove(List<RecipeVat> recipes) {
            super(Vat.name, MaricultureHandlers.vat.getRecipes(), recipes);
        }

        @Override
        public String getRecipeInfo(RecipeVat recipe) {
            if (recipe.outputItem != null) {
                return LogHelper.getStackDescription(recipe.outputItem);
            }
            return LogHelper.getStackDescription(recipe.outputFluid);
        }
    }

    private static class Add
    extends BaseListAddition<RecipeVat> {
        public Add(RecipeVat recipe) {
            super(Vat.name, MaricultureHandlers.vat.getRecipes());
            this.recipes.add(recipe);
        }

        @Override
        public String getRecipeInfo(RecipeVat recipe) {
            if (recipe.outputItem != null) {
                return LogHelper.getStackDescription(recipe.outputItem);
            }
            return LogHelper.getStackDescription(recipe.outputFluid);
        }
    }
}

