/*
 * Decompiled with CFR 0.152.
 */
package iguanaman.iguanatweakstconstruct.restriction;

import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import iguanaman.iguanatweakstconstruct.restriction.RestrictionHelper;
import iguanaman.iguanatweakstconstruct.util.TooltipHelper;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.StatCollector;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.oredict.OreDictionary;
import tconstruct.library.TConstructRegistry;
import tconstruct.library.crafting.CastingRecipe;
import tconstruct.library.crafting.PatternBuilder;
import tconstruct.library.event.PartBuilderEvent;
import tconstruct.library.event.SmelteryCastEvent;
import tconstruct.library.tools.CustomMaterial;
import tconstruct.library.tools.ToolMaterial;
import tconstruct.library.util.IPattern;
import tconstruct.library.util.IToolPart;
import tconstruct.weaponry.TinkerWeaponry;

public class PartRestrictionHandler {
    @SubscribeEvent
    public void onPartBuilding(PartBuilderEvent.NormalPart event) {
        PatternBuilder.ItemKey key = PatternBuilder.instance.getItemKey(event.material);
        if (key == null) {
            return;
        }
        if (event.pattern.func_77960_j() == 23 || event.pattern.func_77960_j() == 24) {
            return;
        }
        PatternBuilder.MaterialSet set = (PatternBuilder.MaterialSet)PatternBuilder.instance.materialSets.get(key.key);
        if (set == null) {
            return;
        }
        ToolMaterial mat = TConstructRegistry.getMaterial((int)set.materialID);
        if (RestrictionHelper.isRestricted(event.pattern, mat)) {
            event.setResult(Event.Result.DENY);
        }
    }

    @SubscribeEvent
    public void onPartCasting(SmelteryCastEvent.CastingTable event) {
        if (event.recipe == null || event.recipe.output == null) {
            return;
        }
        if (event.recipe.output.func_77973_b() == TinkerWeaponry.partBolt) {
            return;
        }
        CastingRecipe recipe = event.recipe;
        ItemStack output = recipe.output;
        if (output.func_77973_b() == null || !(output.func_77973_b() instanceof IToolPart)) {
            return;
        }
        IToolPart part = (IToolPart)output.func_77973_b();
        ToolMaterial mat = TConstructRegistry.getMaterial((int)part.getMaterialID(output));
        if (RestrictionHelper.isRestricted(event.recipe.cast, mat)) {
            event.setResult(Event.Result.DENY);
        }
    }

    @SubscribeEvent
    public void onItemToolTip(ItemTooltipEvent event) {
        List<CustomMaterial> customMaterials;
        if (event.entityPlayer == null) {
            return;
        }
        if (!(event.itemStack.func_77973_b() instanceof IPattern)) {
            return;
        }
        if (!TooltipHelper.shiftHeld()) {
            event.toolTip.add(StatCollector.func_74837_a((String)"tooltip.pattern.advanced", (Object[])new Object[]{EnumChatFormatting.YELLOW.toString() + EnumChatFormatting.ITALIC + "Shift" + EnumChatFormatting.RESET + EnumChatFormatting.GRAY}));
            return;
        }
        boolean foundMat = false;
        List<ToolMaterial> materials = RestrictionHelper.getPatternMaterials(event.itemStack);
        if (materials != null) {
            for (ToolMaterial mat : materials) {
                event.toolTip.add(mat.style() + mat.localizedName());
            }
            foundMat = true;
        }
        if ((customMaterials = RestrictionHelper.getPatternCustomMaterials(event.itemStack)) != null) {
            for (CustomMaterial mat : customMaterials) {
                ArrayList ores;
                if (mat.input != null) {
                    event.toolTip.add(mat.input.func_82833_r());
                    continue;
                }
                if (mat.oredict == null || (ores = OreDictionary.getOres((String)mat.oredict)) == null || ores.isEmpty()) continue;
                event.toolTip.add(String.format("%s (%s)", ((ItemStack)ores.get(0)).func_82833_r(), mat.oredict));
            }
            foundMat = true;
        }
        if (!foundMat) {
            event.toolTip.add(EnumChatFormatting.DARK_RED + StatCollector.func_74838_a((String)"tooltip.pattern.noMaterials"));
        }
    }
}

