/*
 * Decompiled with CFR 0.152.
 */
package shedar.mods.ic2.nuclearcontrol.network.message;

import cpw.mods.fml.common.network.ByteBufUtils;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import io.netty.buffer.ByteBuf;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.Container;
import net.minecraft.item.ItemStack;
import shedar.mods.ic2.nuclearcontrol.IC2NuclearControl;
import shedar.mods.ic2.nuclearcontrol.api.IPanelDataSource;
import shedar.mods.ic2.nuclearcontrol.containers.ContainerInfoPanel;
import shedar.mods.ic2.nuclearcontrol.panel.CardWrapperImpl;
import shedar.mods.ic2.nuclearcontrol.tileentities.TileEntityInfoPanel;

public class PacketClientSensor
implements IMessage,
IMessageHandler<PacketClientSensor, IMessage> {
    private int x;
    private int y;
    private int z;
    private int slot;
    private String className;
    private Map<String, Object> fields;
    public static final int FIELD_DOUBLE = 1;
    public static final int FIELD_INT = 2;
    public static final int FIELD_STRING = 3;
    public static final int FIELD_BOOLEAN = 4;
    public static final int FIELD_TAG = 5;
    public static final int FIELD_NULL = 6;
    public static final int FIELD_LONG = 7;

    public PacketClientSensor() {
    }

    public PacketClientSensor(int x, int y, int z, int slot, String className, Map<String, Object> fields) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.slot = slot;
        this.className = className;
        this.fields = fields;
    }

    public void fromBytes(ByteBuf buf) {
        this.x = buf.readInt();
        this.y = buf.readInt();
        this.z = buf.readInt();
        this.slot = buf.readByte();
        this.className = ByteBufUtils.readUTF8String((ByteBuf)buf);
        int fieldCount = buf.readShort();
        this.fields = new HashMap<String, Object>();
        block7: for (int i = 0; i < fieldCount; ++i) {
            String name = ByteBufUtils.readUTF8String((ByteBuf)buf);
            byte type = buf.readByte();
            switch (type) {
                case 2: {
                    this.fields.put(name, buf.readInt());
                    continue block7;
                }
                case 4: {
                    this.fields.put(name, buf.readBoolean());
                    continue block7;
                }
                case 7: {
                    this.fields.put(name, buf.readLong());
                    continue block7;
                }
                case 1: {
                    this.fields.put(name, buf.readDouble());
                    continue block7;
                }
                case 3: {
                    this.fields.put(name, ByteBufUtils.readUTF8String((ByteBuf)buf));
                    continue block7;
                }
                default: {
                    IC2NuclearControl.logger.warn("Invalid field type: %d", new Object[]{type});
                }
            }
        }
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.x);
        buf.writeInt(this.y);
        buf.writeInt(this.z);
        buf.writeByte(this.slot);
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.className);
        buf.writeShort(this.fields.size());
        for (Map.Entry<String, Object> entry : this.fields.entrySet()) {
            ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)entry.getKey());
            Object value = entry.getValue();
            if (value instanceof Long) {
                buf.writeByte(7);
                buf.writeLong(((Long)value).longValue());
                continue;
            }
            if (value instanceof Double) {
                buf.writeByte(1);
                buf.writeDouble(((Double)value).doubleValue());
                continue;
            }
            if (value instanceof Integer) {
                buf.writeByte(2);
                buf.writeInt(((Integer)value).intValue());
                continue;
            }
            if (value instanceof String) {
                buf.writeByte(3);
                ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)((String)value));
                continue;
            }
            if (!(value instanceof Boolean)) continue;
            buf.writeByte(4);
            buf.writeBoolean(((Boolean)value).booleanValue());
        }
    }

    public IMessage onMessage(PacketClientSensor message, MessageContext ctx) {
        EntityPlayerMP player = ctx.getServerHandler().field_147369_b;
        Container openContainer = player.field_71070_bA;
        if (openContainer instanceof ContainerInfoPanel) {
            int x = message.x;
            int y = message.y;
            int z = message.z;
            TileEntityInfoPanel panel = ((ContainerInfoPanel)openContainer).panel;
            if (panel != null && panel.field_145851_c == x && panel.field_145848_d == y && panel.field_145849_e == z && panel == player.field_70170_p.func_147438_o(x, y, z)) {
                ItemStack stack = panel.func_70301_a(message.slot);
                if (stack == null || !(stack.func_77973_b() instanceof IPanelDataSource)) {
                    return null;
                }
                if (!stack.func_77973_b().getClass().getName().equals(message.className)) {
                    IC2NuclearControl.logger.warn("Class mismatch: '%s'!='%s'", new Object[]{message.className, stack.func_77973_b().getClass().getName()});
                    return null;
                }
                CardWrapperImpl helper = new CardWrapperImpl(stack, message.slot);
                for (Map.Entry<String, Object> entry : message.fields.entrySet()) {
                    String name = entry.getKey();
                    Object value = entry.getValue();
                    if (value instanceof Long) {
                        helper.setLong(name, (Long)value);
                        continue;
                    }
                    if (value instanceof Double) {
                        helper.setDouble(name, (Double)value);
                        continue;
                    }
                    if (value instanceof Integer) {
                        helper.setInt(name, (Integer)value);
                        continue;
                    }
                    if (value instanceof String) {
                        helper.setString(name, (String)value);
                        continue;
                    }
                    if (!(value instanceof Boolean)) continue;
                    helper.setBoolean(name, (Boolean)value);
                }
                helper.commit(panel);
            }
        }
        return null;
    }
}

