/*
 * Decompiled with CFR 0.152.
 */
package shedar.mods.ic2.nuclearcontrol.items;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import ic2.api.item.ElectricItem;
import ic2.api.item.IElectricItem;
import ic2.api.reactor.IReactor;
import java.util.List;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import shedar.mods.ic2.nuclearcontrol.items.ItemToolThermometer;
import shedar.mods.ic2.nuclearcontrol.utils.NuclearNetworkHelper;
import shedar.mods.ic2.nuclearcontrol.utils.TextureResolver;

public class ItemToolDigitalThermometer
extends ItemToolThermometer
implements IElectricItem {
    public int tier;
    public int ratio;
    public int transfer;

    public ItemToolDigitalThermometer(int k, int l, int i1) {
        this.func_77656_e(101);
        this.func_111206_d(TextureResolver.getItemTexture("thermometerDigital"));
        this.tier = k;
        this.ratio = l;
        this.transfer = i1;
    }

    @Override
    protected boolean canTakeDamage(ItemStack itemstack, int i) {
        return ElectricItem.manager.discharge(itemstack, (double)(i *= 50), Integer.MAX_VALUE, true, false, true) == (double)i;
    }

    @Override
    protected void messagePlayer(EntityPlayer entityplayer, IReactor reactor) {
        int heat = reactor.getHeat();
        int maxHeat = reactor.getMaxHeat();
        NuclearNetworkHelper.chatMessage(entityplayer, "ThermoDigital:" + heat + ":" + maxHeat * 50 / 100 + ":" + maxHeat * 85 / 100);
    }

    @Override
    protected void damage(ItemStack itemstack, int i, EntityPlayer entityplayer) {
        ElectricItem.manager.use(itemstack, (double)(50 * i), (EntityLivingBase)entityplayer);
    }

    public boolean canProvideEnergy(ItemStack itemStack) {
        return false;
    }

    public Item getChargedItem(ItemStack itemStack) {
        return this;
    }

    public Item getEmptyItem(ItemStack itemStack) {
        return this;
    }

    public double getMaxCharge(ItemStack itemStack) {
        return 12000.0;
    }

    public int getTier(ItemStack itemStack) {
        return this.tier;
    }

    public double getTransferLimit(ItemStack itemStack) {
        return 250.0;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(Item item, CreativeTabs tab, List itemList) {
        ItemStack itemstack = new ItemStack((Item)this, 1);
        ElectricItem.manager.charge(itemstack, 2.147483647E9, Integer.MAX_VALUE, true, false);
        itemList.add(itemstack);
        itemList.add(new ItemStack((Item)this, 1, this.func_77612_l()));
    }
}

