/*
 * Decompiled with CFR 0.152.
 */
package chylex.hee.system.achievements;

import chylex.hee.init.BlockList;
import chylex.hee.init.ItemList;
import chylex.hee.mechanics.compendium.KnowledgeRegistrations;
import chylex.hee.proxy.ModCommonProxy;
import chylex.hee.system.achievements.HeeAchievement;
import chylex.hee.system.achievements.HeeChallenge;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.stats.Achievement;
import net.minecraftforge.common.AchievementPage;

public final class AchievementManager {
    public static final String achievementScreenName = "HEE Achievements";
    public static final String challengeScreenName = "HEE Challenges";
    private static List<HeeAchievement> achievements = new ArrayList<HeeAchievement>();
    private static List<HeeAchievement> challenges = new ArrayList<HeeAchievement>();
    public static Map<String, String> challengeStrings = new HashMap<String, String>();
    public static HeeAchievement ENDER_COMPENDIUM = AchievementManager.addAchievement(8, "enderCompendium", -2, -1, ItemList.special_effects, 23, null);
    public static HeeAchievement GO_INTO_THE_END = AchievementManager.addAchievement(0, "newAdventures", 0, -1, Blocks.field_150380_bt, null);
    public static HeeAchievement DRAGON_ESSENCE = AchievementManager.addAchievement(1, "dragonEssence", 2, -2, ItemList.essence, (Achievement)GO_INTO_THE_END);
    public static HeeAchievement ENHANCED_BREWING_STAND = AchievementManager.addAchievement(11, "enhancedBrewingStand", 4, -2, ItemList.enhanced_brewing_stand, (Achievement)DRAGON_ESSENCE);
    public static HeeAchievement TEMPLE_CALLER = AchievementManager.addAchievement(24, "templeCaller", 1, -4, ItemList.temple_caller, (Achievement)DRAGON_ESSENCE);
    public static HeeAchievement END_POWDER = AchievementManager.addAchievement(2, "endPowder", 0, 1, ItemList.end_powder, (Achievement)GO_INTO_THE_END).setSpecial();
    public static HeeAchievement ENHANCED_ENDER_PEARL = AchievementManager.addAchievement(12, "enhancedEnderPearl", -3, 1, Items.field_151079_bi, (Achievement)END_POWDER);
    public static HeeAchievement ENHANCED_ENDER_PEARL_FULL = AchievementManager.addAchievement(51, "enhancedEnderPearlFull", -4, 3, ItemList.enhanced_ender_pearl, (Achievement)ENHANCED_ENDER_PEARL);
    public static HeeAchievement ENDER_EYE_KILL = AchievementManager.addAchievement(4, "enderEyeKill", 2, 4, Items.field_151061_bv, (Achievement)END_POWDER);
    public static HeeAchievement TP_NEAR_VOID = AchievementManager.addAchievement(52, "tpNearVoid", 3, 6, ItemList.spatial_dash_gem, 32766, (Achievement)ENDER_EYE_KILL);
    public static HeeAchievement TRANSPORT_BEACON = AchievementManager.addAchievement(14, "transportBeacon", -1, 3, BlockList.transport_beacon, (Achievement)END_POWDER);
    public static HeeAchievement STARDUST = AchievementManager.addAchievement(7, "stardust", -1, 5, ItemList.stardust, (Achievement)END_POWDER).setSpecial();
    public static HeeAchievement ENDIUM_INGOT = AchievementManager.addAchievement(9, "endiumIngot", 2, 2, ItemList.endium_ingot, (Achievement)END_POWDER).setSpecial();
    public static HeeAchievement VOID_CHEST = AchievementManager.addAchievement(10, "voidChest", 3, 0, BlockList.void_chest, (Achievement)ENDIUM_INGOT);
    public static HeeAchievement BIOME_COMPASS = AchievementManager.addAchievement(13, "biomeCompass", 4, 2, ItemList.biome_compass, (Achievement)ENDIUM_INGOT);
    public static HeeAchievement BIOME_INFESTED_FOREST = AchievementManager.addAchievement(15, "biomeInfestedForest", 6, -1, BlockList.end_terrain, (Achievement)BIOME_COMPASS);
    public static HeeAchievement CURSE = AchievementManager.addAchievement(18, "curse", 8, -2, ItemList.special_effects, 24, (Achievement)BIOME_INFESTED_FOREST);
    public static HeeAchievement CHARM_POUCH = AchievementManager.addAchievement(19, "charmPouch", 8, -1, ItemList.charm_pouch, (Achievement)BIOME_INFESTED_FOREST);
    public static HeeAchievement BIOME_BURNING_MOUNTAINS = AchievementManager.addAchievement(16, "biomeBurningMountains", 6, 2, BlockList.end_terrain, 1, (Achievement)BIOME_COMPASS);
    public static HeeAchievement FIERY_ESSSENCE = AchievementManager.addAchievement(20, "fieryEssence", 8, 1, ItemList.essence, 1, (Achievement)BIOME_BURNING_MOUNTAINS);
    public static HeeAchievement SCORCHING_PICKAXE = AchievementManager.addAchievement(21, "scorchingPickaxe", 8, 2, ItemList.scorching_pickaxe, (Achievement)BIOME_BURNING_MOUNTAINS);
    public static HeeAchievement BIOME_ENCHANTED_ISLAND = AchievementManager.addAchievement(17, "biomeEnchantedIsland", 6, 5, BlockList.end_terrain, 2, (Achievement)BIOME_COMPASS);
    public static HeeAchievement TRANSFERENCE_GEM = AchievementManager.addAchievement(22, "transferenceGem", 8, 4, ItemList.transference_gem, (Achievement)BIOME_ENCHANTED_ISLAND);
    public static HeeAchievement ENERGY_WAND = AchievementManager.addAchievement(23, "energyWand", 8, 5, ItemList.energy_wand, 1, (Achievement)BIOME_ENCHANTED_ISLAND);
    public static HeeAchievement CHALLENGE_HARD0DEATHS = AchievementManager.addChallenge(0, "hard0Deaths", "hard");
    public static HeeAchievement CHALLENGE_BEDEXPLODE = AchievementManager.addChallenge(1, "bedExplode", "mediumorhard");
    public static HeeAchievement CHALLENGE_NOENDERMAN = AchievementManager.addChallenge(2, "noEnderman", "mediumorhard");

    public static void register() {
        AchievementPage.registerAchievementPage((AchievementPage)new AchievementPage(achievementScreenName, achievements.toArray(new Achievement[achievements.size()])));
        AchievementPage.registerAchievementPage((AchievementPage)new AchievementPage(challengeScreenName, challenges.toArray(new Achievement[challenges.size()])));
    }

    private static HeeAchievement addAchievement(int id, String stringId, int x, int y, Block block, Achievement parentAchievement) {
        return AchievementManager.addAchievement(id, stringId, x, y, new ItemStack(block), parentAchievement);
    }

    private static HeeAchievement addAchievement(int id, String stringId, int x, int y, Block block, int metadata, Achievement parentAchievement) {
        return AchievementManager.addAchievement(id, stringId, x, y, new ItemStack(block, 1, metadata), parentAchievement);
    }

    private static HeeAchievement addAchievement(int id, String stringId, int x, int y, Item item, Achievement parentAchievement) {
        return AchievementManager.addAchievement(id, stringId, x, y, new ItemStack(item), parentAchievement);
    }

    private static HeeAchievement addAchievement(int id, String stringId, int x, int y, Item item, int damage, Achievement parentAchievement) {
        return AchievementManager.addAchievement(id, stringId, x, y, new ItemStack(item, 1, damage), parentAchievement);
    }

    private static HeeAchievement addAchievement(int id, String stringId, int x, int y, ItemStack is, Achievement parentAchievement) {
        HeeAchievement achievement = (HeeAchievement)new HeeAchievement("achievement.hee." + (ModCommonProxy.achievementStartId + 40 + id), stringId, x, y, is, parentAchievement).func_75971_g();
        achievements.add(achievement);
        return achievement;
    }

    private static HeeAchievement addChallenge(int id, String stringId, String difficultyLevel) {
        HeeChallenge challenge = (HeeChallenge)new HeeChallenge("achievement.hee." + (ModCommonProxy.achievementStartId + 120 + id), stringId, -1 + (id % 2 == 0 ? 0 : 1), -2 + id, new ItemStack(Items.field_151048_u)).func_75971_g();
        challenges.add(challenge);
        challengeStrings.put(stringId, difficultyLevel);
        return challenge;
    }

    static {
        GO_INTO_THE_END.setKnowledgeObj(KnowledgeRegistrations.DRAGON_LAIR);
        ENHANCED_ENDER_PEARL.setKnowledgeObj(KnowledgeRegistrations.ENDER_PEARL_ENHANCEMENTS);
        ENHANCED_ENDER_PEARL_FULL.setKnowledgeObj(KnowledgeRegistrations.ENDER_PEARL_ENHANCEMENTS);
        ENDER_EYE_KILL.setKnowledgeObj(KnowledgeRegistrations.ENDER_EYE);
        BIOME_INFESTED_FOREST.setKnowledgeObj(KnowledgeRegistrations.INFESTED_FOREST_BIOME);
        CURSE.setKnowledgeObj(KnowledgeRegistrations.CURSE);
        BIOME_BURNING_MOUNTAINS.setKnowledgeObj(KnowledgeRegistrations.BURNING_MOUNTAINS_BIOME);
        BIOME_ENCHANTED_ISLAND.setKnowledgeObj(KnowledgeRegistrations.ENCHANTED_ISLAND_BIOME);
    }
}

