/*
 * Decompiled with CFR 0.152.
 */
package chylex.hee.entity.boss.dragon.attacks.special;

import chylex.hee.entity.boss.EntityBossDragon;
import chylex.hee.entity.boss.dragon.attacks.special.DragonSpecialAttackBase;
import chylex.hee.entity.boss.dragon.attacks.special.event.CollisionEvent;
import chylex.hee.entity.boss.dragon.attacks.special.event.MotionUpdateEvent;
import chylex.hee.entity.boss.dragon.attacks.special.event.TargetPositionSetEvent;
import chylex.hee.entity.boss.dragon.attacks.special.event.TargetSetEvent;
import chylex.hee.system.util.DragonUtil;
import chylex.hee.system.util.MathUtil;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;

public class DragonAttackDivebomb
extends DragonSpecialAttackBase {
    private static final byte PHASE_FLY_UP = 0;
    private static final byte PHASE_DIVEBOMB = 1;
    private static final byte PHASE_POST_TARGET = 2;
    private static final byte PHASE_END = 3;
    private Entity temp;
    private float speed;
    private byte timer;
    private EntityPlayer tmpTarget;

    public DragonAttackDivebomb(EntityBossDragon dragon, int attackId, int weight) {
        super(dragon, attackId, weight);
    }

    @Override
    public void init() {
        super.init();
        this.tmpTarget = null;
        this.temp = null;
        this.speed = 1.0f;
        this.timer = 0;
    }

    @Override
    public void update() {
        super.update();
        this.speed = 1.0f;
        if (this.phase == 0) {
            if (this.dragon.field_70163_u < 120.0) {
                this.dragon.targetY = 140.0;
            }
            if (this.tmpTarget == null) {
                this.tmpTarget = DragonUtil.getClosestEntity((Entity)this.dragon, this.dragon.attacks.getViablePlayers());
            }
            if (this.tmpTarget == null) {
                this.dragon.targetX += this.dragon.func_70681_au().nextGaussian() * 2.0;
                this.dragon.targetZ += this.dragon.func_70681_au().nextGaussian() * 2.0;
            } else {
                this.dragon.targetX = this.tmpTarget.field_70165_t;
                this.dragon.targetZ = this.tmpTarget.field_70161_v;
            }
            this.timer = (byte)(this.timer + 1);
            if (this.timer > 125 || MathUtil.distance(this.dragon.targetX - this.dragon.field_70165_t, this.dragon.targetZ - this.dragon.field_70161_v) < 6.0) {
                this.tick = 0;
                this.phase = 1;
                this.tmpTarget = null;
            }
        } else if (this.phase == 1) {
            this.dragon.targetY = 20.0;
            this.speed = 3.5f;
            if (this.dragon.field_70181_x == 0.0 && this.tick > 50) {
                this.phase = (byte)3;
            }
            if (this.dragon.field_70163_u <= 30.0) {
                this.phase = (byte)2;
                this.tick = 1;
            }
            if (this.dragon.moveSpeedMp < 3.5) {
                this.dragon.moveSpeedMp += 0.04;
            }
        } else if (this.phase == 2) {
            if (this.tick > 160) {
                this.phase = (byte)3;
            }
            if (this.temp == null) {
                this.temp = this.dragon.attacks.getRandomPlayer();
            }
            if (this.temp != null) {
                this.dragon.targetX = this.temp.field_70165_t;
                this.dragon.targetZ = this.temp.field_70161_v;
            }
            this.dragon.targetY = this.tick < 60 ? 30.0 : 80.0;
            this.speed = 2.0f;
        }
        if (this.phase < 3) {
            this.dragon.target = null;
        }
    }

    @Override
    public boolean hasEnded() {
        return this.phase == 3;
    }

    @Override
    public float overrideMovementSpeed() {
        return this.speed;
    }

    @Override
    public float overrideWingSpeed() {
        return this.phase == 0 ? 1.15f : (this.phase == 1 ? 0.4f : 1.0f);
    }

    @Override
    public void onCollisionEvent(CollisionEvent event) {
        event.velocityX *= 1.5;
        event.velocityY = event.velocityY * (this.phase == 1 ? 8.5 : 6.0);
        event.velocityZ *= 1.5;
    }

    @Override
    public void onMotionUpdateEvent(MotionUpdateEvent event) {
        if (this.phase == 0) {
            event.motionX *= 0.98;
            event.motionZ *= 0.98;
        } else if (this.phase == 1) {
            event.motionX = MathUtil.clamp(event.motionX / this.dragon.moveSpeedMp, -0.01, 0.01);
            event.motionZ = MathUtil.clamp(event.motionZ / this.dragon.moveSpeedMp, -0.01, 0.01);
            if (this.dragon.field_70163_u < 30.0) {
                event.motionY = 0.0;
            }
        }
    }

    @Override
    public void onTargetSetEvent(TargetSetEvent event) {
        event.newTarget = null;
    }

    @Override
    public void onTargetPositionSetEvent(TargetPositionSetEvent event) {
        if (this.phase < 3) {
            event.cancel();
        }
    }
}

