/*
 * Decompiled with CFR 0.152.
 */
package galaxyspace.core.entity.boss;

import cpw.mods.fml.common.network.NetworkRegistry;
import galaxyspace.core.config.GSConfigCore;
import galaxyspace.core.register.GSItems;
import galaxyspace.core.tile.chest.TileEntityTreasureChestT4;
import java.util.List;
import java.util.Random;
import micdoodle8.mods.galacticraft.api.GalacticraftRegistry;
import micdoodle8.mods.galacticraft.api.entity.IEntityBreathable;
import micdoodle8.mods.galacticraft.api.vector.Vector3;
import micdoodle8.mods.galacticraft.core.GalacticraftCore;
import micdoodle8.mods.galacticraft.core.entities.EntityAIArrowAttack;
import micdoodle8.mods.galacticraft.core.entities.IBoss;
import micdoodle8.mods.galacticraft.core.network.IPacket;
import micdoodle8.mods.galacticraft.core.network.PacketSimple;
import micdoodle8.mods.galacticraft.core.tile.TileEntityDungeonSpawner;
import micdoodle8.mods.galacticraft.core.util.ConfigManagerCore;
import micdoodle8.mods.galacticraft.core.util.GCCoreUtil;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IRangedAttackMob;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.boss.IBossDisplayData;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.item.EntityXPOrb;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntitySmallFireball;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.DamageSource;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.MathHelper;
import net.minecraft.util.WeightedRandomChestContent;
import net.minecraft.world.World;
import net.minecraftforge.common.ChestGenHooks;

public class EntityBlazeBoss
extends EntityMob
implements IEntityBreathable,
IBossDisplayData,
IRangedAttackMob,
IBoss {
    protected long ticks = 0L;
    private TileEntityDungeonSpawner spawnereu;
    public int headsRemaining = 3;
    public Entity targetEntity;
    public int deathTicks = 0;
    public int entitiesWithin;
    public int entitiesWithinLast;
    private Vector3 roomCoords;
    private Vector3 roomSize;

    public EntityBlazeBoss(World world) {
        super(world);
        this.func_70105_a(1.5f, 7.0f);
        this.field_70178_ae = true;
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIArrowAttack((IRangedAttackMob)this, 1.0, 25, 20.0f));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIWander((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 8.0f));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, false));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityPlayer.class, 0, true));
    }

    public boolean func_70097_a(DamageSource damageSource, float amount) {
        if (this.func_85032_ar()) {
            return false;
        }
        if ("fireball".equals(damageSource.func_76355_l()) && damageSource.func_76346_g() instanceof EntityPlayer) {
            super.func_70097_a(damageSource, amount);
            return true;
        }
        return super.func_70097_a(damageSource, Math.min(amount, GSConfigCore.baseBossDamage));
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(300.0 * ConfigManagerCore.dungeonBossHealthMod);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a((double)0.05f);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(4.0);
    }

    public EntityBlazeBoss(World world, Vector3 vec) {
        this(world);
        this.func_70107_b(vec.x, vec.y, vec.z);
    }

    public void func_70653_a(Entity entity, float par2, double x, double z) {
    }

    public boolean func_70650_aV() {
        return true;
    }

    protected String func_70639_aQ() {
        return "mob.blaze.breathe";
    }

    protected String func_70621_aR() {
        return "mob.blaze.hit";
    }

    protected String func_70673_aS() {
        return "mob.blaze.death";
    }

    protected void func_70609_aI() {
        float n;
        ++this.deathTicks;
        this.headsRemaining = 0;
        if (this.deathTicks >= 180 && this.deathTicks <= 200) {
            float f = (this.field_70146_Z.nextFloat() - 0.5f) * 1.5f;
            float f2 = (this.field_70146_Z.nextFloat() - 0.5f) * 2.0f;
            float f3 = (this.field_70146_Z.nextFloat() - 0.5f) * 1.5f;
            this.field_70170_p.func_72869_a("hugeexplosion", this.field_70165_t + (double)f, this.field_70163_u + 2.0 + (double)f2, this.field_70161_v + (double)f3, 0.0, 0.0, 0.0);
        }
        if (!this.field_70170_p.field_72995_K) {
            if (this.deathTicks >= 180 && this.deathTicks % 5 == 0) {
                GalacticraftCore.packetPipeline.sendToAllAround((IPacket)new PacketSimple(PacketSimple.EnumSimplePacket.C_PLAY_SOUND_EXPLODE, new Object[0]), new NetworkRegistry.TargetPoint(this.field_70170_p.field_73011_w.field_76574_g, this.field_70165_t, this.field_70163_u, this.field_70161_v, 40.0));
            }
            if (this.deathTicks > 150 && this.deathTicks % 5 == 0) {
                int j;
                for (int i = 30; i > 0; i -= j) {
                    j = EntityXPOrb.func_70527_a((int)i);
                    this.field_70170_p.func_72838_d((Entity)new EntityXPOrb(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, j));
                }
            }
            if (this.deathTicks == 1) {
                GalacticraftCore.packetPipeline.sendToAllAround((IPacket)new PacketSimple(PacketSimple.EnumSimplePacket.C_PLAY_SOUND_BOSS_DEATH, new Object[0]), new NetworkRegistry.TargetPoint(this.field_70170_p.field_73011_w.field_76574_g, this.field_70165_t, this.field_70163_u, this.field_70161_v, 40.0));
            }
        }
        this.func_70091_d(0.0, 0.1f, 0.0);
        this.field_70177_z = n = this.field_70177_z + 20.0f;
        this.field_70761_aq = n;
        if (this.deathTicks == 200 && !this.field_70170_p.field_72995_K) {
            int j;
            for (int i = 20; i > 0; i -= j) {
                j = EntityXPOrb.func_70527_a((int)i);
                this.field_70170_p.func_72838_d((Entity)new EntityXPOrb(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, j));
            }
            for (Object tile : this.field_70170_p.field_147482_g) {
                if (!(tile instanceof TileEntityTreasureChestT4)) continue;
                double d3 = (double)((TileEntityTreasureChestT4)((Object)tile)).field_145851_c + 0.5 - this.field_70165_t;
                double d4 = (double)((TileEntityTreasureChestT4)((Object)tile)).field_145848_d + 0.5 - this.field_70163_u;
                double d5 = (double)((TileEntityTreasureChestT4)((Object)tile)).field_145849_e + 0.5 - this.field_70161_v;
                double dSq = d3 * d3 + d4 * d4 + d5 * d5;
                TileEntityTreasureChestT4 chest = (TileEntityTreasureChestT4)((Object)tile);
                if (!(dSq < 10000.0)) continue;
                if (!chest.locked) {
                    chest.locked = true;
                }
                for (int k = 0; k < chest.func_70302_i_(); ++k) {
                    chest.func_70299_a(k, null);
                }
                ChestGenHooks info = ChestGenHooks.getInfo((String)"dungeonChest");
                WeightedRandomChestContent.func_76293_a((Random)this.field_70146_Z, (WeightedRandomChestContent[])info.getItems(this.field_70146_Z), (IInventory)chest, (int)info.getCount(this.field_70146_Z));
                WeightedRandomChestContent.func_76293_a((Random)this.field_70146_Z, (WeightedRandomChestContent[])info.getItems(this.field_70146_Z), (IInventory)chest, (int)info.getCount(this.field_70146_Z));
                WeightedRandomChestContent.func_76293_a((Random)this.field_70146_Z, (WeightedRandomChestContent[])info.getItems(this.field_70146_Z), (IInventory)chest, (int)info.getCount(this.field_70146_Z));
                chest.func_70299_a(this.field_70146_Z.nextInt(chest.func_70302_i_()), this.getGuaranteedLoot(this.field_70146_Z));
                break;
            }
            this.func_70099_a(new ItemStack(GSItems.Tier4Key, 1), 0.5f);
            super.func_70106_y();
            if (this.spawnereu != null) {
                this.spawnereu.isBossDefeated = true;
                this.spawnereu.boss = null;
                this.spawnereu.spawned = false;
            }
        }
    }

    public void func_70106_y() {
        if (this.spawnereu != null) {
            this.spawnereu.isBossDefeated = false;
            this.spawnereu.boss = null;
            this.spawnereu.spawned = false;
        }
        super.func_70106_y();
    }

    public void func_70636_d() {
        if (this.ticks >= Long.MAX_VALUE) {
            this.ticks = 1L;
        }
        ++this.ticks;
        if (this.func_110143_aJ() <= 0.0f) {
            this.headsRemaining = 0;
        } else if ((double)this.func_110143_aJ() <= (double)this.func_110138_aP() / 3.0) {
            this.headsRemaining = 1;
        } else if ((double)this.func_110143_aJ() <= 2.0 * ((double)this.func_110138_aP() / 3.0)) {
            this.headsRemaining = 2;
        }
        EntityPlayer player = this.field_70170_p.func_72977_a(this.field_70165_t, this.field_70163_u, this.field_70161_v, 20.0);
        if (player != null && !player.equals((Object)this.targetEntity)) {
            if (this.func_70068_e((Entity)player) < 400.0) {
                this.func_70661_as().func_75494_a((Entity)player);
                this.targetEntity = player;
            }
        } else {
            this.targetEntity = null;
        }
        new Vector3((Entity)this);
        if (this.roomCoords != null && this.roomSize != null) {
            List entitiesWithin = this.field_70170_p.func_72872_a(EntityPlayer.class, AxisAlignedBB.func_72330_a((double)(this.roomCoords.intX() - 1), (double)(this.roomCoords.intY() - 1), (double)(this.roomCoords.intZ() - 1), (double)(this.roomCoords.intX() + this.roomSize.intX()), (double)(this.roomCoords.intY() + this.roomSize.intY()), (double)(this.roomCoords.intZ() + this.roomSize.intZ())));
            this.entitiesWithin = entitiesWithin.size();
            if (this.entitiesWithin == 0 && this.entitiesWithinLast != 0) {
                List entitiesWithin2 = this.field_70170_p.func_72872_a(EntityPlayer.class, AxisAlignedBB.func_72330_a((double)(this.roomCoords.intX() - 11), (double)(this.roomCoords.intY() - 11), (double)(this.roomCoords.intZ() - 11), (double)(this.roomCoords.intX() + this.roomSize.intX() + 10), (double)(this.roomCoords.intY() + this.roomSize.intY() + 10), (double)(this.roomCoords.intZ() + this.roomSize.intZ() + 10)));
                for (EntityPlayer p : entitiesWithin2) {
                    p.func_145747_a((IChatComponent)new ChatComponentText(GCCoreUtil.translate((String)"gui.skeletonBoss.message")));
                }
                this.func_70106_y();
                if (this.spawnereu != null) {
                    this.spawnereu.playerCheated = true;
                }
                return;
            }
            this.entitiesWithinLast = this.entitiesWithin;
        }
        super.func_70636_d();
    }

    protected void func_70628_a(boolean hitByPlayer, int looting) {
    }

    public EntityItem func_70099_a(ItemStack itemStack, float par2) {
        EntityItem entityitem = new EntityItem(this.field_70170_p, this.field_70165_t, this.field_70163_u + (double)par2, this.field_70161_v, itemStack);
        entityitem.field_70181_x = -2.0;
        entityitem.field_145804_b = 10;
        if (this.captureDrops) {
            this.capturedDrops.add(entityitem);
        } else {
            this.field_70170_p.func_72838_d((Entity)entityitem);
        }
        return entityitem;
    }

    public boolean canBreath() {
        return true;
    }

    public ItemStack getGuaranteedLoot(Random rand) {
        List stackList = GalacticraftRegistry.getDungeonLoot((int)4);
        return ((ItemStack)stackList.get(rand.nextInt(stackList.size()))).func_77946_l();
    }

    public void func_70014_b(NBTTagCompound nbt) {
        super.func_70014_b(nbt);
        if (this.roomCoords != null) {
            nbt.func_74780_a("roomCoordsX", this.roomCoords.x);
            nbt.func_74780_a("roomCoordsY", this.roomCoords.y);
            nbt.func_74780_a("roomCoordsZ", this.roomCoords.z);
            nbt.func_74780_a("roomSizeX", this.roomSize.x);
            nbt.func_74780_a("roomSizeY", this.roomSize.y);
            nbt.func_74780_a("roomSizeZ", this.roomSize.z);
        }
    }

    public void func_70037_a(NBTTagCompound nbt) {
        super.func_70037_a(nbt);
        this.roomCoords = new Vector3();
        this.roomCoords.x = nbt.func_74769_h("roomCoordsX");
        this.roomCoords.y = nbt.func_74769_h("roomCoordsY");
        this.roomCoords.z = nbt.func_74769_h("roomCoordsZ");
        this.roomSize = new Vector3();
        this.roomSize.x = nbt.func_74769_h("roomSizeX");
        this.roomSize.y = nbt.func_74769_h("roomSizeY");
        this.roomSize.z = nbt.func_74769_h("roomSizeZ");
    }

    private double func_82214_u(int par1) {
        if (par1 <= 0) {
            return this.field_70165_t;
        }
        float f = (this.field_70761_aq + (float)(180 * (par1 - 1))) / 180.0f * (float)Math.PI;
        float f2 = MathHelper.func_76134_b((float)f);
        return this.field_70165_t + (double)f2 * 1.3;
    }

    private double func_82208_v(int par1) {
        return par1 <= 0 ? this.field_70163_u + 6.0 : this.field_70163_u + 4.2;
    }

    private double func_82213_w(int par1) {
        if (par1 <= 0) {
            return this.field_70161_v;
        }
        float f = (this.field_70761_aq + (float)(180 * (par1 - 1))) / 180.0f * (float)Math.PI;
        float f2 = MathHelper.func_76126_a((float)f);
        return this.field_70161_v + (double)f2 * 1.3;
    }

    public void func_82196_d(EntityLivingBase entity, float f) {
        this.func_82216_a(0, entity);
    }

    private void func_82216_a(int par1, EntityLivingBase entity) {
        this.func_82209_a(par1, entity.field_70165_t, entity.field_70163_u + (double)entity.func_70047_e() * 0.5, entity.field_70161_v);
    }

    private void func_82209_a(int par1, double x, double y, double z) {
        this.field_70170_p.func_72889_a((EntityPlayer)null, 1014, (int)this.field_70165_t, (int)this.field_70163_u, (int)this.field_70161_v, 0);
        double d3 = this.func_82214_u(par1);
        double d4 = this.func_82208_v(par1);
        double d5 = this.func_82213_w(par1);
        double d6 = x - d3;
        double d7 = y - d4;
        double d8 = z - d5;
        EntitySmallFireball entityfireball = new EntitySmallFireball(this.field_70170_p, (EntityLivingBase)this, d6 * 0.5, d7 * 0.5, d8 * 0.5);
        entityfireball.field_70163_u = d4;
        entityfireball.field_70165_t = d3;
        entityfireball.field_70161_v = d5;
        this.field_70170_p.func_72838_d((Entity)entityfireball);
    }

    public void setRoom(Vector3 roomCoords, Vector3 roomSize) {
        this.roomCoords = roomCoords;
        this.roomSize = roomSize;
    }

    public void onBossSpawned(TileEntityDungeonSpawner spawner) {
        this.spawnereu = spawner;
    }
}

