/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.core.util;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Random;
import micdoodle8.mods.galacticraft.core.GalacticraftCore;
import micdoodle8.mods.galacticraft.core.network.PacketSimple;
import micdoodle8.mods.galacticraft.core.util.GCLog;
import micdoodle8.mods.galacticraft.core.util.MapUtil;
import micdoodle8.mods.galacticraft.core.util.VersionUtil;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.WorldType;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.biome.WorldChunkManager;
import net.minecraft.world.gen.NoiseGeneratorOctaves;
import net.minecraft.world.gen.layer.GenLayer;
import org.apache.commons.io.FileUtils;

public class MapGen {
    public boolean calculatingMap = false;
    private int ix = 0;
    private int iz = 0;
    private int biomeMapx0 = 0;
    private int biomeMapz0 = 0;
    private int biomeMapz00;
    private final int biomeMapCx;
    private final int biomeMapCz;
    private int biomeMapFactor;
    private WorldChunkManager biomeMapWCM;
    private static GenLayer biomeMapGenLayer;
    public File biomeMapFile;
    private byte[] biomeAndHeightArray = null;
    private int biomeMapSizeX;
    private int biomeMapSizeZ;
    private Random rand = new Random();
    private int[] heights = null;
    private double[] heighttemp = null;
    private WorldType field_147435_p = WorldType.field_77137_b;
    private BiomeGenBase[] biomesGrid = null;
    private BiomeGenBase[] biomesGridHeights = null;
    private int[] biomeCount = null;
    static double[] noiseField3;
    static double[] noiseField1;
    static double[] noiseField2;
    static double[] noiseField4;
    private NoiseGeneratorOctaves noiseGen1;
    private NoiseGeneratorOctaves noiseGen2;
    private NoiseGeneratorOctaves noiseGen3;
    public NoiseGeneratorOctaves noiseGen4;

    public MapGen(World world, int sx, int sz, int cx, int cz, int scale, File file) {
        this.biomeMapCx = cx >> 4;
        this.biomeMapCz = cz >> 4;
        if (file.exists()) {
            return;
        }
        this.biomeMapFile = file;
        this.calculatingMap = true;
        this.biomeMapSizeX = sx;
        this.biomeMapSizeZ = sz;
        this.biomeMapFactor = scale;
        int limitX = this.biomeMapSizeX * this.biomeMapFactor / 32;
        int limitZ = this.biomeMapSizeZ * this.biomeMapFactor / 32;
        this.biomeMapz00 = -limitZ;
        this.biomeMapx0 = -limitX;
        this.biomeMapz0 = this.biomeMapz00;
        this.ix = 0;
        this.iz = 0;
        this.biomeMapWCM = world.func_72959_q();
        try {
            Field bil = this.biomeMapWCM.getClass().getDeclaredField(VersionUtil.getNameDynamic("biomeIndexLayer"));
            bil.setAccessible(true);
            biomeMapGenLayer = (GenLayer)bil.get(this.biomeMapWCM);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (biomeMapGenLayer == null) {
            this.calculatingMap = false;
            GCLog.debug("Failed to get gen layer from World Chunk Manager.");
            return;
        }
        GCLog.debug("Starting map generation " + file.getName() + " top left " + (this.biomeMapCx - limitX) * 16 + "," + (this.biomeMapCz - limitZ) * 16);
        this.field_147435_p = world.func_72912_H().func_76067_t();
        this.initialise(world.func_72905_C());
    }

    public void writeOutputFile(boolean flag) {
        try {
            if (!this.biomeMapFile.exists() || this.biomeMapFile.canWrite() && this.biomeMapFile.canRead()) {
                FileUtils.writeByteArrayToFile((File)this.biomeMapFile, (byte[])this.biomeAndHeightArray);
            }
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        if (flag) {
            this.sendToClient(this.biomeAndHeightArray);
        }
        this.biomeAndHeightArray = null;
    }

    private void sendToClient(byte[] toSend) {
        try {
            GalacticraftCore.packetPipeline.sendToAll(new PacketSimple(PacketSimple.EnumSimplePacket.C_SEND_OVERWORLD_IMAGE, new Object[]{this.biomeMapCx << 4, this.biomeMapCz << 4, toSend}));
        }
        catch (Exception ex) {
            System.err.println("Error sending map image to player.");
            ex.printStackTrace();
        }
    }

    public boolean BiomeMapOneTick() {
        int imagefactor;
        int multifactor;
        int limit = Math.min(this.biomeMapFactor, 16);
        if (this.biomeAndHeightArray == null) {
            this.biomeAndHeightArray = new byte[this.biomeMapSizeX * this.biomeMapSizeZ * 2];
            this.heights = new int[256];
            this.heighttemp = new double[825];
            this.biomeCount = new int[limit * limit];
        }
        if ((multifactor = this.biomeMapFactor >> 4) < 1) {
            multifactor = 1;
        }
        if ((imagefactor = 16 / this.biomeMapFactor) < 1) {
            imagefactor = 1;
        }
        this.biomeMapOneChunk(this.biomeMapCx + this.biomeMapx0, this.biomeMapCz + this.biomeMapz0, this.ix, this.iz, this.biomeMapFactor, limit);
        this.biomeMapz0 += multifactor;
        this.iz += imagefactor;
        if (this.iz > this.biomeMapSizeZ - imagefactor) {
            this.iz = 0;
            if (this.ix % 25 == 8) {
                GCLog.debug("Finished map column " + this.ix + " at " + (this.biomeMapCx + this.biomeMapx0) + "," + (this.biomeMapCz + this.biomeMapz0));
            }
            this.ix += imagefactor;
            this.biomeMapz0 = this.biomeMapz00;
            this.biomeMapx0 += multifactor;
            if (this.biomeMapx0 > -this.biomeMapz00 * 4) {
                this.biomeMapx0 += this.biomeMapz00 * 8;
            }
            return this.ix > this.biomeMapSizeX - imagefactor;
        }
        return false;
    }

    private void biomeMapOneChunk(int x0, int z0, int ix, int iz, int factor, int limit) {
        this.biomesGrid = this.biomeMapWCM.func_76931_a(this.biomesGrid, x0 << 4, z0 << 4, 16, 16, false);
        if (this.biomesGrid == null) {
            return;
        }
        this.getHeightMap(x0, z0);
        int halfFactor = limit * limit / 2;
        ArrayList<Integer> cols = new ArrayList<Integer>();
        Arrays.fill(this.biomeCount, 0);
        for (int x = 0; x < 16; x += factor) {
            int izstore = iz;
            for (int z = 0; z < 16; z += factor) {
                cols.clear();
                int maxcount = 0;
                int maxindex = -1;
                int biome = -1;
                int lastcol = -1;
                int idx = 0;
                int avgHeight = 0;
                int divisor = 0;
                block2: for (int xx = 0; xx < limit; ++xx) {
                    int hidx = (xx + x << 4) + z;
                    for (int zz = 0; zz < limit; ++zz) {
                        int height = this.heights[hidx + zz];
                        avgHeight += height;
                        ++divisor;
                        BiomeGenBase theBiome = this.biomesGrid[xx + x + (zz + z << 4)];
                        biome = theBiome != null ? theBiome.field_76756_M : 9;
                        if (biome != lastcol) {
                            idx = cols.indexOf(biome);
                            if (idx == -1) {
                                idx = cols.size();
                                cols.add(biome);
                            }
                            lastcol = biome;
                        }
                        int n = idx;
                        this.biomeCount[n] = this.biomeCount[n] + 1;
                        if (this.biomeCount[idx] <= maxcount) continue;
                        maxcount = this.biomeCount[idx];
                        maxindex = idx;
                        if (maxcount > halfFactor) break block2;
                    }
                }
                for (int j = cols.size() - 1; j >= 0; --j) {
                    this.biomeCount[j] = 0;
                }
                int arrayIndex = (ix * this.biomeMapSizeZ + iz) * 2;
                this.biomeAndHeightArray[arrayIndex] = (byte)((Integer)cols.get(maxindex)).intValue();
                this.biomeAndHeightArray[arrayIndex + 1] = (byte)((avgHeight + (divisor + 1) / 2) / divisor);
                ++iz;
            }
            iz = izstore;
            ++ix;
        }
    }

    public void getHeightMap(int cx, int cz) {
        this.rand.setSeed((long)cx * 341873128712L + (long)cz * 132897987541L);
        this.biomesGridHeights = this.biomeMapWCM.func_76937_a(this.biomesGridHeights, cx * 4 - 2, cz * 4 - 2, 10, 10);
        this.func_147423_a(cx * 4, 0, cz * 4);
        double d0 = 0.125;
        double d9 = 0.25;
        for (int xx = 0; xx < 4; ++xx) {
            int xa = xx * 5;
            int xb = xa + 5;
            for (int zz = 0; zz < 4; ++zz) {
                int aa = (xa + zz) * 33;
                int ab = aa + 33;
                int ba = (xb + zz) * 33;
                int bb = ba + 33;
                for (int yy = 2; yy < 18; ++yy) {
                    double d1 = this.heighttemp[aa + yy];
                    double d2 = this.heighttemp[ab + yy];
                    double d3 = this.heighttemp[ba + yy];
                    double d4 = this.heighttemp[bb + yy];
                    double d5 = (this.heighttemp[aa + yy + 1] - d1) * 0.125;
                    double d6 = (this.heighttemp[ab + yy + 1] - d2) * 0.125;
                    double d7 = (this.heighttemp[ba + yy + 1] - d3) * 0.125;
                    double d8 = (this.heighttemp[bb + yy + 1] - d4) * 0.125;
                    for (int y = 0; y < 8; ++y) {
                        double d10 = d1;
                        double d11 = d2;
                        double d12 = (d3 - d1) * 0.25;
                        double d13 = (d4 - d2) * 0.25;
                        int truey = yy * 8 + y;
                        for (int x = 0; x < 4; ++x) {
                            int idx = x + xx * 4 << 4 | zz * 4;
                            double d16 = (d11 - d10) * 0.25;
                            double d15 = d10 - d16;
                            for (int z = 0; z < 4; ++z) {
                                if (!((d15 += d16) > 0.0)) continue;
                                this.heights[idx + z] = truey;
                            }
                            d10 += d12;
                            d11 += d13;
                        }
                        d1 += d5;
                        d2 += d6;
                        d3 += d7;
                        d4 += d8;
                    }
                }
            }
        }
    }

    public void initialise(long seed) {
        this.rand = new Random(seed);
        this.noiseGen1 = new NoiseGeneratorOctaves(this.rand, 16);
        this.noiseGen2 = new NoiseGeneratorOctaves(this.rand, 16);
        this.noiseGen3 = new NoiseGeneratorOctaves(this.rand, 8);
        this.noiseGen4 = new NoiseGeneratorOctaves(this.rand, 16);
    }

    private void func_147423_a(int cx, int cy, int cz) {
        noiseField4 = this.noiseGen4.func_76305_a(noiseField4, cx, cz, 5, 5, 200.0, 200.0, 0.5);
        noiseField3 = this.noiseGen3.func_76304_a(noiseField3, cx, cy, cz, 5, 33, 5, 8.555150000000001, 4.277575000000001, 8.555150000000001);
        noiseField1 = this.noiseGen1.func_76304_a(noiseField1, cx, cy, cz, 5, 33, 5, 684.412, 684.412, 684.412);
        noiseField2 = this.noiseGen2.func_76304_a(noiseField2, cx, cy, cz, 5, 33, 5, 684.412, 684.412, 684.412);
        int l = 2;
        int i1 = 0;
        boolean amplified = this.field_147435_p == WorldType.field_151360_e;
        for (int xx = 0; xx < 5; ++xx) {
            for (int zz = 0; zz < 5; ++zz) {
                float f = 0.0f;
                float f1 = 0.0f;
                float f2 = 0.0f;
                BiomeGenBase biomegenbase = this.biomesGridHeights[xx + 22 + zz * 10];
                for (int x = -2; x <= 2; ++x) {
                    int baseIndex = xx + x + 22 + zz * 10;
                    for (int z = -2; z <= 2; ++z) {
                        BiomeGenBase biomegenbase1 = this.biomesGridHeights[baseIndex + z * 10];
                        float f3 = biomegenbase1.field_76748_D;
                        float f4 = biomegenbase1.field_76749_E;
                        if (amplified && f3 > 0.0f) {
                            f3 = 1.0f + f3 + f3;
                            f4 = 1.0f + f4 * 4.0f;
                        }
                        float f5 = MapUtil.parabolicField[x + 12 + z * 5] / (f3 + 2.0f);
                        if (biomegenbase1.field_76748_D > biomegenbase.field_76748_D) {
                            f5 /= 2.0f;
                        }
                        f += f4 * f5;
                        f1 += f3 * f5;
                        f2 += f5;
                    }
                }
                f /= f2;
                f1 /= f2;
                f = f * 0.9f + 0.1f;
                f1 = f1 / 2.0f - 0.125f;
                double d12 = noiseField4[i1] / 8000.0;
                if (d12 < 0.0) {
                    d12 = -d12 * 0.3;
                }
                if ((d12 = d12 * 3.0 - 2.0) < 0.0) {
                    if ((d12 /= 2.0) < -1.0) {
                        d12 = -1.0;
                    }
                    d12 /= 1.4;
                    d12 /= 2.0;
                } else {
                    if (d12 > 1.0) {
                        d12 = 1.0;
                    }
                    d12 /= 8.0;
                }
                ++i1;
                double d13 = f1;
                double d14 = (double)f / 6.0;
                d13 += d12 * 0.2;
                d13 = d13 * 8.5 / 8.0;
                double d5 = 8.5 + d13 * 4.0;
                for (int j2 = 2; j2 < 19; ++j2) {
                    double d6 = ((double)j2 - d5) / d14;
                    if (d6 < 0.0) {
                        d6 *= 4.0;
                    }
                    double d7 = noiseField1[l] / 512.0;
                    double d8 = noiseField2[l] / 512.0;
                    double d9 = (noiseField3[l] / 10.0 + 1.0) / 2.0;
                    this.heighttemp[l] = MathHelper.func_151238_b((double)d7, (double)d8, (double)d9) - d6;
                    ++l;
                }
                l += 16;
            }
        }
    }
}

