/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.api.recipe;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.SetMultimap;
import java.util.Set;
import javax.annotation.Nonnull;
import micdoodle8.mods.galacticraft.api.entity.IFuelable;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;

public class RocketFuels {
    private static final SetMultimap<Class<? extends IFuelable>, String> FUEL_MAP = HashMultimap.create();

    public static boolean addFuel(@Nonnull Class<? extends IFuelable> fuelableClass, @Nonnull Object fluid) {
        return FUEL_MAP.put(fuelableClass, (Object)RocketFuels.getFluidName(fluid));
    }

    public static boolean removeFuel(@Nonnull Class<? extends IFuelable> fuelableClass, @Nonnull Object fluid) {
        return FUEL_MAP.remove(fuelableClass, (Object)RocketFuels.getFluidName(fluid));
    }

    public static Set<String> removeFuelable(@Nonnull Class<? extends IFuelable> fuelableClass) {
        return FUEL_MAP.removeAll(fuelableClass);
    }

    public static boolean isCorrectFuel(@Nonnull IFuelable fuelable, @Nonnull Object fluid) {
        return FUEL_MAP.containsEntry(fuelable.getClass(), (Object)RocketFuels.getFluidName(fluid));
    }

    public static boolean isValidFuel(@Nonnull Object fluid) {
        return FUEL_MAP.containsValue((Object)RocketFuels.getFluidName(fluid));
    }

    private static String getFluidName(Object fluid) {
        if (fluid instanceof String) {
            String fluidName = (String)fluid;
            return fluidName;
        }
        if (fluid instanceof Fluid) {
            Fluid fluidObj = (Fluid)fluid;
            return fluidObj.getName();
        }
        if (fluid instanceof FluidStack) {
            FluidStack fluidStack = (FluidStack)fluid;
            return fluidStack.getFluid().getName();
        }
        throw new IllegalArgumentException(fluid + " is not an instace of String, Fluid or FluidStack!");
    }

    private RocketFuels() {
    }
}

