/*
 * Decompiled with CFR 0.152.
 */
package gttweaker.mods.gregtech.machines;

import gregtech.api.enums.GTValues;
import gregtech.api.interfaces.IRecipeMap;
import gregtech.api.recipe.RecipeMaps;
import gttweaker.mods.AddMultipleRecipeAction;
import gttweaker.util.ArrayHelper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Objects;
import minetweaker.IUndoableAction;
import minetweaker.MineTweakerAPI;
import minetweaker.annotations.ModOnly;
import minetweaker.api.item.IIngredient;
import minetweaker.api.item.IItemStack;
import minetweaker.api.liquid.ILiquidStack;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.gregtech.ChemicalBath")
@ModOnly(value={"gregtech"})
public class ChemicalBath {
    @ZenMethod
    public static void addRecipe(IItemStack[] output, IIngredient input, ILiquidStack fluidInput, int[] chances, int durationTicks, int euPerTick) {
        if (output.length == 0) {
            MineTweakerAPI.logError((String)"chemical bath requires at least 1 output");
        } else {
            MineTweakerAPI.apply((IUndoableAction)new AddMultipleRecipeAction("Adding Chemical Bath recipe for " + input, new Object[]{input, fluidInput, output[0], ArrayHelper.itemOrNull(output, 1), ArrayHelper.itemOrNull(output, 2), chances, durationTicks, euPerTick}){

                @Override
                protected void applySingleRecipe(AddMultipleRecipeAction.ArgIterator i) {
                    ItemStack input = i.nextItem();
                    FluidStack fluidInput = i.nextFluid();
                    ArrayList<ItemStack> outputs = new ArrayList<ItemStack>(Arrays.asList(i.nextItem(), i.nextItem(), i.nextItem()));
                    outputs.removeIf(Objects::isNull);
                    int[] chances = i.nextIntArr();
                    int duration = i.nextInt();
                    int eut = i.nextInt();
                    GTValues.RA.stdBuilder().itemInputs(new ItemStack[]{input}).itemOutputs(outputs.toArray(new ItemStack[0])).outputChances(chances).fluidInputs(new FluidStack[]{fluidInput}).duration(duration).eut(eut).addTo((IRecipeMap)RecipeMaps.chemicalBathRecipes);
                }
            });
        }
    }
}

