/*
 * Decompiled with CFR 0.152.
 */
package com.dreammaster.recipes;

import com.dreammaster.recipes.CustomItem;
import gregtech.api.enums.OrePrefixes;
import gregtech.api.interfaces.IItemContainer;
import gregtech.api.objects.ItemData;
import gregtech.api.util.GTOreDictUnificator;
import gregtech.api.util.GTUtility;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.oredict.ShapedOreRecipe;

public class ShapedUniversalRecipe
extends ShapedOreRecipe {
    static final ItemStack MISSING = new ItemStack((Block)Blocks.field_150480_ab);
    private final ItemStack output;
    private final Object[][] recipe = new Object[3][3];
    private final Object[] recipeXY = new Object[9];
    private int maxX;
    private int maxY = 0;

    public ShapedUniversalRecipe(ItemStack result, Object ... recipe) {
        super(result, new Object[]{"xxx", "xxx", "xxx", Character.valueOf('x'), MISSING});
        int i;
        int x;
        this.output = result.func_77946_l();
        if (recipe.length > 3 && recipe[0] instanceof String && recipe[1] instanceof String && recipe[2] instanceof String && ((String)recipe[0]).length() == 3 && ((String)recipe[1]).length() == 3 && ((String)recipe[2]).length() == 3) {
            HashMap<Character, Object> itemMap = new HashMap<Character, Object>();
            for (int i2 = 3; i2 < recipe.length; i2 += 2) {
                if (recipe[i2 + 1] == null) continue;
                itemMap.put((Character)recipe[i2], recipe[i2 + 1]);
            }
            for (int y = 0; y < 3; ++y) {
                for (int x2 = 0; x2 < 3; ++x2) {
                    this.recipe[y][x2] = itemMap.get(Character.valueOf(((String)recipe[y]).charAt(x2)));
                }
            }
        } else if (recipe.length == 4) {
            for (int y = 0; y < 2; ++y) {
                for (x = 0; x < 2; ++x) {
                    i = y * 2 + x;
                    this.recipe[y][x] = recipe[i];
                    if (recipe[i] == null) continue;
                    if (this.maxX < x) {
                        this.maxX = x;
                    }
                    if (this.maxY >= y) continue;
                    this.maxY = y;
                }
            }
        } else {
            for (int y = 0; y < 3; ++y) {
                for (x = 0; x < 3; ++x) {
                    i = y * 3 + x;
                    if (i >= recipe.length) continue;
                    this.recipe[y][x] = recipe[i];
                    if (this.maxX < x) {
                        this.maxX = x;
                    }
                    if (this.maxY >= y) continue;
                    this.maxY = y;
                }
            }
        }
        for (int y = 0; y < 3; ++y) {
            for (x = 0; x < 3; ++x) {
                if (this.recipe[y][x] == null) continue;
                if (this.recipe[y][x] instanceof String) {
                    ArrayList ores = OreDictionary.getOres((String)((String)this.recipe[y][x]));
                    this.recipeXY[y * 3 + x] = ores;
                    HashSet<GTUtility.ItemId> oresHashes = new HashSet<GTUtility.ItemId>();
                    for (ItemStack o : ores) {
                        ItemStack i3 = o.func_77946_l();
                        i3.field_77990_d = null;
                        oresHashes.add(GTUtility.ItemId.createNoCopy((ItemStack)i3));
                    }
                    this.recipe[y][x] = oresHashes;
                    continue;
                }
                if (this.recipe[y][x] instanceof ItemStack) {
                    this.recipe[y][x] = ((ItemStack)this.recipe[y][x]).func_77946_l();
                    this.recipeXY[y * 3 + x] = this.recipe[y][x];
                    continue;
                }
                if (this.recipe[y][x] instanceof IItemContainer) {
                    this.recipe[y][x] = ((IItemContainer)this.recipe[y][x]).get(1L, new Object[0]);
                    this.recipeXY[y * 3 + x] = this.recipe[y][x];
                    continue;
                }
                if (this.recipe[y][x] instanceof Item) {
                    this.recipe[y][x] = new ItemStack((Item)this.recipe[y][x]);
                    this.recipeXY[y * 3 + x] = this.recipe[y][x];
                    continue;
                }
                if (this.recipe[y][x] instanceof Block) {
                    this.recipe[y][x] = new ItemStack((Block)this.recipe[y][x]);
                    this.recipeXY[y * 3 + x] = this.recipe[y][x];
                    continue;
                }
                if (this.recipe[y][x] instanceof ItemData) {
                    ItemData data = (ItemData)this.recipe[y][x];
                    ItemStack itemStack = GTOreDictUnificator.get((OrePrefixes)data.mPrefix, (Object)data.mMaterial.mMaterial, (long)1L);
                    if (itemStack == null) {
                        throw new NullPointerException("bad item passed in the recipe");
                    }
                    this.recipe[y][x] = itemStack;
                    this.recipeXY[y * 3 + x] = this.recipe[y][x];
                    continue;
                }
                if (this.recipe[y][x] instanceof CustomItem) {
                    this.recipeXY[y * 3 + x] = ((CustomItem)this.recipe[y][x]).getStack();
                    continue;
                }
                throw new IllegalArgumentException("Wrong argument in recipe");
            }
        }
    }

    public boolean func_77569_a(InventoryCrafting inv, World world) {
        for (int y = 0; y < 3 - this.maxY; ++y) {
            for (int x = 0; x < 3 - this.maxX; ++x) {
                if (!this.matches(inv, x, y)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean matches(InventoryCrafting inv, int offsetX, int offsetY) {
        for (int y = 0; y < 3; ++y) {
            for (int x = 0; x < 3; ++x) {
                ItemStack stack;
                Object r = x - offsetX < 0 || y - offsetY < 0 ? null : this.recipe[y - offsetY][x - offsetX];
                if (r == null ^ (stack = inv.func_70463_b(x, y)) == null) {
                    return false;
                }
                if (stack == null) continue;
                if (r instanceof ItemStack) {
                    if (GTUtility.areStacksEqual((ItemStack)((ItemStack)r), (ItemStack)stack, (boolean)true)) continue;
                    return false;
                }
                if (r instanceof HashSet) {
                    ItemStack copy = stack.func_77946_l();
                    copy.field_77990_d = null;
                    if (((HashSet)r).contains(GTUtility.ItemId.createNoCopy((ItemStack)copy))) continue;
                    Items.field_151008_G.setDamage(copy, Short.MAX_VALUE);
                    if (((HashSet)r).contains(GTUtility.ItemId.createNoCopy((ItemStack)copy))) continue;
                    return false;
                }
                if (r instanceof CustomItem) {
                    if (((CustomItem)r).matches(stack)) continue;
                    return false;
                }
                return false;
            }
        }
        return true;
    }

    public ItemStack func_77572_b(InventoryCrafting inv) {
        return this.func_77571_b().func_77946_l();
    }

    public int func_77570_a() {
        return 9;
    }

    public ItemStack func_77571_b() {
        return this.output;
    }

    public Object[] getInput() {
        return this.recipeXY;
    }

    public ShapedOreRecipe setMirrored(boolean mirror) {
        throw new UnsupportedOperationException();
    }
}

