/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.gui.ledgers;

import forestry.core.gui.ledgers.Ledger;
import forestry.core.gui.ledgers.LedgerManager;
import forestry.core.render.TextureManager;
import forestry.core.tiles.IPowerHandler;
import forestry.core.utils.StringUtil;
import forestry.energy.EnergyManager;

public class PowerLedger
extends Ledger {
    private final IPowerHandler tile;

    public PowerLedger(LedgerManager manager, IPowerHandler tile) {
        super(manager, "power");
        this.tile = tile;
        this.maxHeight = 94;
    }

    @Override
    public void draw(int x, int y) {
        this.drawBackground(x, y);
        this.drawIcon(TextureManager.getInstance().getDefault("misc/energy"), x + 3, y + 4);
        if (!this.isFullyOpened()) {
            return;
        }
        int xHeader = x + 22;
        int xBody = x + 12;
        EnergyManager energyManager = this.tile.getEnergyManager();
        this.drawHeader(StringUtil.localize("gui.energy"), xHeader, y + 8);
        this.drawSubheader(StringUtil.localize("gui.stored") + ':', xBody, y + 20);
        this.drawText(energyManager.getTotalEnergyStored() + " RF", xBody, y + 32);
        this.drawSubheader(StringUtil.localize("gui.maxenergy") + ':', xBody, y + 44);
        this.drawText(energyManager.getMaxEnergyStored() + " RF", xBody, y + 56);
        this.drawSubheader(StringUtil.localize("gui.maxenergyreceive") + ':', xBody, y + 68);
        this.drawText(energyManager.getMaxEnergyReceived() + " RF", xBody, y + 80);
    }

    @Override
    public String getTooltip() {
        return this.tile.getEnergyManager().getTotalEnergyStored() + " RF";
    }
}

