/*
 * Decompiled with CFR 0.152.
 */
package forestry.arboriculture.commands;

import forestry.api.arboriculture.IAlleleTreeSpecies;
import forestry.api.genetics.AlleleManager;
import forestry.api.genetics.IAllele;
import forestry.arboriculture.commands.ITreeSpawner;
import forestry.core.commands.CommandHelpers;
import forestry.core.commands.SubCommand;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.PlayerNotFoundException;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import org.apache.commons.lang3.StringUtils;

public final class CommandTreeSpawn
extends SubCommand {
    private final ITreeSpawner treeSpawner;

    public CommandTreeSpawn(String name, ITreeSpawner treeSpawner) {
        super(name);
        this.setPermLevel(SubCommand.PermLevel.ADMIN);
        this.treeSpawner = treeSpawner;
    }

    @Override
    public final void processSubCommand(ICommandSender sender, String[] arguments) {
        String treeName;
        EntityPlayerMP player;
        if (arguments.length < 1 || arguments.length > 2) {
            this.printHelp(sender);
            return;
        }
        try {
            player = CommandHelpers.getPlayer(sender, arguments[arguments.length - 1]);
            Object[] argumentsWithoutPlayer = new String[arguments.length - 1];
            System.arraycopy(arguments, 0, argumentsWithoutPlayer, 0, arguments.length - 1);
            treeName = StringUtils.join((Object[])argumentsWithoutPlayer, (String)" ");
        }
        catch (PlayerNotFoundException e) {
            player = CommandHelpers.getPlayer(sender, sender.func_70005_c_());
            treeName = StringUtils.join((Object[])arguments, (String)" ");
        }
        boolean success = this.treeSpawner.spawn(sender, treeName, (EntityPlayer)player);
        if (!success) {
            this.printHelp(sender);
        }
    }

    @Override
    public List<String> func_71516_a(ICommandSender sender, String[] parameters) {
        if (parameters.length == 1) {
            List<String> tabCompletion = CommandHelpers.getListOfStringsMatchingLastWord(parameters, CommandTreeSpawn.getSpecies());
            tabCompletion.add("help");
            return tabCompletion;
        }
        if (parameters.length == 2) {
            return CommandHelpers.getListOfStringsMatchingLastWord(parameters, CommandHelpers.getPlayers());
        }
        return null;
    }

    private static String[] getSpecies() {
        ArrayList<String> species = new ArrayList<String>();
        for (IAllele allele : AlleleManager.alleleRegistry.getRegisteredAlleles().values()) {
            if (!(allele instanceof IAlleleTreeSpecies)) continue;
            species.add(allele.getName().replaceAll("\\s", ""));
        }
        return species.toArray(new String[species.size()]);
    }
}

