/*
 * Decompiled with CFR 0.152.
 */
package forestry.apiculture.genetics.alleles;

import forestry.api.apiculture.BeeManager;
import forestry.api.apiculture.EnumBeeChromosome;
import forestry.api.apiculture.IAlleleBeeEffect;
import forestry.api.apiculture.IBeeGenome;
import forestry.api.apiculture.IBeeHousing;
import forestry.api.apiculture.IBeeModifier;
import forestry.api.genetics.AlleleManager;
import forestry.api.genetics.IEffectData;
import forestry.apiculture.genetics.alleles.AlleleEffectAggressive;
import forestry.apiculture.genetics.alleles.AlleleEffectCreeper;
import forestry.apiculture.genetics.alleles.AlleleEffectExploration;
import forestry.apiculture.genetics.alleles.AlleleEffectFertile;
import forestry.apiculture.genetics.alleles.AlleleEffectFungification;
import forestry.apiculture.genetics.alleles.AlleleEffectGlacial;
import forestry.apiculture.genetics.alleles.AlleleEffectHeroic;
import forestry.apiculture.genetics.alleles.AlleleEffectIgnition;
import forestry.apiculture.genetics.alleles.AlleleEffectMisanthrope;
import forestry.apiculture.genetics.alleles.AlleleEffectNone;
import forestry.apiculture.genetics.alleles.AlleleEffectPotion;
import forestry.apiculture.genetics.alleles.AlleleEffectRadioactive;
import forestry.apiculture.genetics.alleles.AlleleEffectRepulsion;
import forestry.apiculture.genetics.alleles.AlleleEffectResurrection;
import forestry.apiculture.genetics.alleles.AlleleEffectSnowing;
import forestry.core.genetics.alleles.AlleleCategorized;
import forestry.core.proxy.Proxies;
import forestry.core.utils.EntityUtil;
import forestry.core.utils.vect.MutableVect;
import forestry.core.utils.vect.Vect;
import java.util.Arrays;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.potion.Potion;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.util.Vec3;

public abstract class AlleleEffect
extends AlleleCategorized
implements IAlleleBeeEffect {
    public static IAlleleBeeEffect effectNone;
    public static IAlleleBeeEffect effectAggressive;
    public static IAlleleBeeEffect effectHeroic;
    public static IAlleleBeeEffect effectBeatific;
    public static IAlleleBeeEffect effectMiasmic;
    public static IAlleleBeeEffect effectMisanthrope;
    public static IAlleleBeeEffect effectGlacial;
    public static IAlleleBeeEffect effectRadioactive;
    public static IAlleleBeeEffect effectCreeper;
    public static IAlleleBeeEffect effectIgnition;
    public static IAlleleBeeEffect effectExploration;
    public static IAlleleBeeEffect effectFestiveEaster;
    public static IAlleleBeeEffect effectSnowing;
    public static IAlleleBeeEffect effectDrunkard;
    public static IAlleleBeeEffect effectReanimation;
    public static IAlleleBeeEffect effectResurrection;
    public static IAlleleBeeEffect effectRepulsion;
    public static IAlleleBeeEffect effectFertile;
    public static IAlleleBeeEffect effectMycophilic;

    public static void createAlleles() {
        effectNone = new AlleleEffectNone("none", true);
        effectAggressive = new AlleleEffectAggressive();
        effectHeroic = new AlleleEffectHeroic();
        effectBeatific = new AlleleEffectPotion("beatific", false, Potion.field_76428_l, 100);
        effectMiasmic = new AlleleEffectPotion("miasmic", false, Potion.field_76436_u, 600, 100, 0.1f);
        effectMisanthrope = new AlleleEffectMisanthrope();
        effectGlacial = new AlleleEffectGlacial();
        effectRadioactive = new AlleleEffectRadioactive();
        effectCreeper = new AlleleEffectCreeper();
        effectIgnition = new AlleleEffectIgnition();
        effectExploration = new AlleleEffectExploration();
        effectFestiveEaster = new AlleleEffectNone("festiveEaster", true);
        effectSnowing = new AlleleEffectSnowing();
        effectDrunkard = new AlleleEffectPotion("drunkard", false, Potion.field_76431_k, 100);
        effectReanimation = new AlleleEffectResurrection("reanimation", AlleleEffectResurrection.getReanimationList());
        List<IAlleleBeeEffect> beeEffects = Arrays.asList(effectNone, effectAggressive, effectHeroic, effectBeatific, effectMiasmic, effectMisanthrope, effectGlacial, effectRadioactive, effectCreeper, effectIgnition, effectExploration, effectFestiveEaster, effectSnowing, effectDrunkard, effectReanimation, effectResurrection = new AlleleEffectResurrection("resurrection", AlleleEffectResurrection.getResurrectionList()), effectRepulsion = new AlleleEffectRepulsion(), effectFertile = new AlleleEffectFertile(), effectMycophilic = new AlleleEffectFungification());
        for (IAlleleBeeEffect beeEffect : beeEffects) {
            AlleleManager.alleleRegistry.registerAllele(beeEffect, EnumBeeChromosome.EFFECT);
        }
    }

    protected AlleleEffect(String valueName, boolean isDominant) {
        super("forestry", "effect", valueName, isDominant);
    }

    @Override
    public IEffectData validateStorage(IEffectData storedData) {
        return null;
    }

    @Override
    public boolean isCombinable() {
        return false;
    }

    @Override
    public IEffectData doEffect(IBeeGenome genome, IEffectData storedData, IBeeHousing housing) {
        return storedData;
    }

    @Override
    public IEffectData doFX(IBeeGenome genome, IEffectData storedData, IBeeHousing housing) {
        Vec3 beeFXCoordinates = this.getFXCoordinates(housing);
        Proxies.render.addBeeHiveFX("particles/swarm_bee", housing.getWorld(), beeFXCoordinates.field_72450_a, beeFXCoordinates.field_72448_b, beeFXCoordinates.field_72449_c, genome.getPrimary().getIconColour(0));
        return storedData;
    }

    protected Vec3 getFXCoordinates(IBeeHousing housing) {
        try {
            return housing.getBeeFXCoordinates();
        }
        catch (Throwable error) {
            ChunkCoordinates coordinates = housing.getCoordinates();
            return Vec3.func_72443_a((double)((double)coordinates.field_71574_a + 0.5), (double)((double)coordinates.field_71572_b + 0.5), (double)((double)coordinates.field_71573_c + 0.5));
        }
    }

    protected Vect getModifiedArea(IBeeGenome genome, IBeeHousing housing) {
        IBeeModifier beeModifier = BeeManager.beeRoot.createBeeHousingModifier(housing);
        float territoryModifier = beeModifier.getTerritoryModifier(genome, 1.0f);
        MutableVect area = new MutableVect(genome.getTerritory());
        area.multiply(territoryModifier);
        if (area.x < 1) {
            area.x = 1;
        }
        if (area.y < 1) {
            area.y = 1;
        }
        if (area.z < 1) {
            area.z = 1;
        }
        return new Vect(area);
    }

    public static AxisAlignedBB getBounding(IBeeGenome genome, IBeeHousing housing) {
        IBeeModifier beeModifier = BeeManager.beeRoot.createBeeHousingModifier(housing);
        float territoryModifier = beeModifier.getTerritoryModifier(genome, 1.0f);
        MutableVect area = new MutableVect(genome.getTerritory());
        area.multiply(territoryModifier);
        Vect offset = new Vect(area).multiply(-0.5f);
        Vect min = new Vect(housing.getCoordinates()).add(offset);
        Vect max = min.add(area);
        return AxisAlignedBB.func_72330_a((double)min.x, (double)min.y, (double)min.z, (double)max.x, (double)max.y, (double)max.z);
    }

    public static <T extends Entity> List<T> getEntitiesInRange(IBeeGenome genome, IBeeHousing housing, Class<T> entityClass) {
        AxisAlignedBB boundingBox = AlleleEffect.getBounding(genome, housing);
        return EntityUtil.getEntitiesWithinAABB(housing.getWorld(), entityClass, boundingBox);
    }
}

