/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machine.painter;

import com.enderio.core.common.TileEntityEnder;
import com.enderio.core.common.util.Util;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import crazypants.enderio.BlockEio;
import crazypants.enderio.EnderIO;
import crazypants.enderio.ModObject;
import crazypants.enderio.item.IRotatableFacade;
import crazypants.enderio.machine.IMachineRecipe;
import crazypants.enderio.machine.MachineRecipeInput;
import crazypants.enderio.machine.MachineRecipeRegistry;
import crazypants.enderio.machine.painter.BasicPainterTemplate;
import crazypants.enderio.machine.painter.BlockItemPaintedGlowstone;
import crazypants.enderio.machine.painter.IPaintableTileEntity;
import crazypants.enderio.machine.painter.IPaintedBlock;
import crazypants.enderio.machine.painter.PainterUtil;
import crazypants.enderio.machine.painter.TileEntityPaintedBlock;
import crazypants.util.IFacade;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.material.Material;
import net.minecraft.client.particle.EffectRenderer;
import net.minecraft.client.particle.EntityDiggingFX;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;

public class BlockPaintedGlowstone
extends BlockEio
implements ITileEntityProvider,
IPaintedBlock,
IFacade,
IRotatableFacade {
    public static int renderId = -1;
    private IIcon lastRemovedComponetIcon = null;
    private final Random rand = new Random();

    public static BlockPaintedGlowstone create() {
        BlockPaintedGlowstone result = new BlockPaintedGlowstone();
        result.init();
        return result;
    }

    protected BlockPaintedGlowstone() {
        super(ModObject.blockPaintedGlowstone.unlocalisedName, TileEntityPaintedBlock.class, Material.field_151592_s);
        this.func_149647_a(null);
        this.func_149672_a(field_149778_k);
        this.func_149711_c(0.7f);
        this.func_149715_a(1.0f);
    }

    protected void init() {
        GameRegistry.registerBlock((Block)this, BlockItemPaintedGlowstone.class, (String)ModObject.blockPaintedGlowstone.unlocalisedName);
        GameRegistry.registerTileEntity(TileEntityPaintedBlock.class, (String)(ModObject.blockPaintedGlowstone.unlocalisedName + "TileEntity"));
        MachineRecipeRegistry.instance.registerRecipe(ModObject.blockPainter.unlocalisedName, new PainterTemplate());
    }

    public static ItemStack createItemStackForSourceBlock(Block block, int damage) {
        ItemStack result = new ItemStack((Block)EnderIO.blockPaintedGlowstone, 1, damage);
        PainterUtil.setSourceBlock(result, block, damage);
        return result;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149666_a(Item item, CreativeTabs tab, List list) {
        list.add(PainterUtil.applyDefaultPaintedState(new ItemStack(item)));
    }

    @SideOnly(value=Side.CLIENT)
    public int func_149720_d(IBlockAccess world, int x, int y, int z) {
        TileEntityPaintedBlock tef;
        TileEntity te = world.func_147438_o(x, y, z);
        if (te instanceof TileEntityPaintedBlock && (tef = (TileEntityPaintedBlock)te).getSourceBlock() != null) {
            return tef.getSourceBlock().func_149720_d(world, x, y, z);
        }
        return super.func_149720_d(world, x, y, z);
    }

    @SideOnly(value=Side.CLIENT)
    public boolean addHitEffects(World world, MovingObjectPosition target, EffectRenderer effectRenderer) {
        IIcon tex = null;
        TileEntityPaintedBlock cb = (TileEntityPaintedBlock)world.func_147438_o(target.field_72311_b, target.field_72312_c, target.field_72309_d);
        Block b = cb.getSourceBlock();
        if (b != null) {
            tex = b.func_149691_a(ForgeDirection.NORTH.ordinal(), cb.getSourceBlockMetadata());
        }
        if (tex == null) {
            tex = this.field_149761_L;
        }
        this.lastRemovedComponetIcon = tex;
        this.addBlockHitEffects(world, effectRenderer, target.field_72311_b, target.field_72312_c, target.field_72309_d, target.field_72310_e, tex);
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean addDestroyEffects(World world, int x, int y, int z, int meta, EffectRenderer effectRenderer) {
        IIcon tex = this.lastRemovedComponetIcon;
        int b0 = 4;
        for (int j1 = 0; j1 < b0; ++j1) {
            for (int k1 = 0; k1 < b0; ++k1) {
                for (int l1 = 0; l1 < b0; ++l1) {
                    double d0 = (double)x + ((double)j1 + 0.5) / (double)b0;
                    double d1 = (double)y + ((double)k1 + 0.5) / (double)b0;
                    double d2 = (double)z + ((double)l1 + 0.5) / (double)b0;
                    int i2 = this.rand.nextInt(6);
                    EntityDiggingFX fx = new EntityDiggingFX(world, d0, d1, d2, d0 - (double)x - 0.5, d1 - (double)y - 0.5, d2 - (double)z - 0.5, (Block)this, i2, 0).func_70596_a(x, y, z);
                    fx.func_110125_a(tex);
                    effectRenderer.func_78873_a((EntityFX)fx);
                }
            }
        }
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    private void addBlockHitEffects(World world, EffectRenderer effectRenderer, int x, int y, int z, int side, IIcon tex) {
        float f = 0.1f;
        double d0 = (double)x + this.rand.nextDouble() * (this.func_149753_y() - this.func_149704_x() - (double)(f * 2.0f)) + (double)f + this.func_149704_x();
        double d1 = (double)y + this.rand.nextDouble() * (this.func_149669_A() - this.func_149665_z() - (double)(f * 2.0f)) + (double)f + this.func_149665_z();
        double d2 = (double)z + this.rand.nextDouble() * (this.func_149693_C() - this.func_149706_B() - (double)(f * 2.0f)) + (double)f + this.func_149706_B();
        if (side == 0) {
            d1 = (double)y + this.func_149665_z() - (double)f;
        } else if (side == 1) {
            d1 = (double)y + this.func_149669_A() + (double)f;
        } else if (side == 2) {
            d2 = (double)z + this.func_149706_B() - (double)f;
        } else if (side == 3) {
            d2 = (double)z + this.func_149693_C() + (double)f;
        } else if (side == 4) {
            d0 = (double)x + this.func_149704_x() - (double)f;
        } else if (side == 5) {
            d0 = (double)x + this.func_149753_y() + (double)f;
        }
        EntityDiggingFX digFX = new EntityDiggingFX(world, d0, d1, d2, 0.0, 0.0, 0.0, (Block)this, side, 0);
        digFX.func_70596_a(x, y, z).func_70543_e(0.2f).func_70541_f(0.6f);
        digFX.func_110125_a(tex);
        effectRenderer.func_78873_a((EntityFX)digFX);
    }

    public boolean isSideSolid(IBlockAccess world, int x, int y, int z, ForgeDirection side) {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149673_e(IBlockAccess world, int x, int y, int z, int blockSide) {
        TileEntityPaintedBlock tef;
        TileEntity te = world.func_147438_o(x, y, z);
        if (te instanceof TileEntityPaintedBlock && (tef = (TileEntityPaintedBlock)te).getSourceBlock() != null) {
            return tef.getSourceBlock().func_149691_a(blockSide, tef.getSourceBlockMetadata());
        }
        return Blocks.field_150467_bQ.func_149673_e(world, x, y, z, blockSide);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister IIconRegister2) {
        this.field_149761_L = IIconRegister2.func_94245_a("enderio:conduitConnector");
    }

    public TileEntity func_149915_a(World world, int metadata) {
        return new TileEntityPaintedBlock();
    }

    @Override
    public boolean tryRotateFacade(World world, int x, int y, int z, ForgeDirection axis) {
        int newMeta;
        TileEntityPaintedBlock tef;
        int oldMeta;
        TileEntity te = world.func_147438_o(x, y, z);
        if (te instanceof TileEntityPaintedBlock && (oldMeta = (tef = (TileEntityPaintedBlock)te).getSourceBlockMetadata()) != (newMeta = PainterUtil.rotateFacadeMetadata(tef.getSourceBlock(), oldMeta, axis))) {
            tef.setSourceBlockMetadata(newMeta);
            world.func_147471_g(x, y, z);
            tef.func_70296_d();
            return true;
        }
        return false;
    }

    public int func_149692_a(int meta) {
        return meta;
    }

    protected void processDrop(World world, int x, int y, int z, TileEntityEnder te, ItemStack drop) {
        TileEntityPaintedBlock tef = (TileEntityPaintedBlock)te;
        if (tef != null) {
            ItemStack itemStack = BlockPaintedGlowstone.createItemStackForSourceBlock(tef.getSourceBlock(), tef.getSourceBlockMetadata());
            drop.field_77990_d = (NBTTagCompound)itemStack.field_77990_d.func_74737_b();
        }
    }

    public boolean doNormalDrops(World world, int x, int y, int z) {
        return false;
    }

    public int func_149645_b() {
        return renderId;
    }

    @Override
    public int getFacadeMetadata(IBlockAccess world, int x, int y, int z, int side) {
        TileEntity te = world.func_147438_o(x, y, z);
        if (te instanceof TileEntityPaintedBlock) {
            TileEntityPaintedBlock tef = (TileEntityPaintedBlock)te;
            return tef.func_145832_p();
        }
        return 0;
    }

    @Override
    public Block getFacade(IBlockAccess world, int x, int y, int z, int side) {
        Block sourceBlock;
        TileEntity te = world.func_147438_o(x, y, z);
        if (te instanceof IPaintableTileEntity && (sourceBlock = ((IPaintableTileEntity)te).getSourceBlock()) != null) {
            return sourceBlock;
        }
        return this;
    }

    public Block getVisualBlock(IBlockAccess world, int x, int y, int z, ForgeDirection side) {
        return this.getFacade(world, x, y, z, side.ordinal());
    }

    public int getVisualMeta(IBlockAccess world, int x, int y, int z, ForgeDirection side) {
        return this.getFacadeMetadata(world, x, y, z, side.ordinal());
    }

    public boolean supportsVisualConnections() {
        return true;
    }

    public final class PainterTemplate
    extends BasicPainterTemplate {
        public PainterTemplate() {
            super(new Block[]{Blocks.field_150426_aN, BlockPaintedGlowstone.this});
            MinecraftForge.EVENT_BUS.register((Object)this);
        }

        @Override
        public boolean isValidPaintSource(ItemStack paintSource) {
            return super.isValidPaintSource(paintSource) && Util.getBlockFromItemId((ItemStack)paintSource).func_149662_c();
        }

        @Override
        public IMachineRecipe.ResultStack[] getCompletedResult(float chance, MachineRecipeInput ... inputs) {
            ItemStack paintSource = MachineRecipeInput.getInputForSlot(1, inputs);
            if (paintSource == null) {
                return new IMachineRecipe.ResultStack[0];
            }
            if (paintSource.func_77973_b() == Item.func_150898_a((Block)Blocks.field_150426_aN)) {
                ItemStack stack = new ItemStack(Blocks.field_150426_aN);
                stack.field_77990_d = new NBTTagCompound();
                String tagName = "wasPainted";
                stack.field_77990_d.func_74757_a(tagName, true);
                return new IMachineRecipe.ResultStack[]{new IMachineRecipe.ResultStack(stack)};
            }
            return new IMachineRecipe.ResultStack[]{new IMachineRecipe.ResultStack(BlockPaintedGlowstone.createItemStackForSourceBlock(Block.func_149634_a((Item)paintSource.func_77973_b()), paintSource.func_77960_j()))};
        }

        @SubscribeEvent
        public void onTooltip(ItemTooltipEvent event) {
            if (event.itemStack != null && Block.func_149634_a((Item)event.itemStack.func_77973_b()) == Blocks.field_150426_aN && event.itemStack.field_77990_d != null && event.itemStack.field_77990_d.func_74767_n("wasPainted")) {
                event.toolTip.add(EnderIO.lang.localize("painter.tooltip.wasPainted"));
            }
        }
    }
}

