/*
 * Decompiled with CFR 0.152.
 */
package DummyCore.Core;

import DummyCore.CreativeTabs.CreativePageBlocks;
import DummyCore.CreativeTabs.CreativePageItems;
import DummyCore.Utils.EnumLightColor;
import DummyCore.Utils.IDummyConfig;
import DummyCore.Utils.Notifier;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraftforge.common.config.Configuration;

public class Core {
    public static List<Block> lightBlocks = new ArrayList<Block>();
    public static List<EnumLightColor> lightColors = new ArrayList<EnumLightColor>();
    private static HashMap<Class<?>, Integer> modList = new HashMap();
    private static HashMap<Integer, Configuration> configurationList = new HashMap();
    private static List<String> modNameList = new ArrayList<String>();
    private static CreativeTabs[] blocksTabs = new CreativeTabs[512];
    private static CreativeTabs[] itemsTabs = new CreativeTabs[512];
    private static Configuration[] config = new Configuration[512];
    private static IDummyConfig[] configurationHandlers = new IDummyConfig[512];
    private static boolean[] isConfigLoaded = new boolean[512];

    private static void registerMod(Class<?> c, String name) throws RuntimeException {
        int modId;
        if (!modList.containsKey(c)) {
            modId = Core.getNextModId();
            if (modId < 0 || modId >= 512) {
                throw new RuntimeException("Mod " + name + " is trying to be registered with wrong id " + modId);
            }
        } else {
            throw new RuntimeException("Mod " + name + " is already registered!");
        }
        modList.put(c, modId);
        modNameList.add(modId, name);
        Core.blocksTabs[modId] = new CreativePageBlocks(name);
        Core.itemsTabs[modId] = new CreativePageItems(name);
        Notifier.notifySimple("Mod with name " + name + " and classpath " + c.getName() + ".class using ID " + modId + " has been succesfully registered!");
    }

    private static void registerConfigurationFileForMod(Class<?> c, String path) throws IOException {
        File file = new File(path, Core.getModName(Core.getIdForMod(c)) + ".cfg");
        if (!file.exists()) {
            file.createNewFile();
        }
        Core.config[Core.getIdForMod(c)] = new Configuration(file);
        config[Core.getIdForMod(c)].save();
        configurationList.put(Core.getIdForMod(c), config[Core.getIdForMod(c)]);
        Notifier.notifySimple("Configuration File for mod " + Core.getModName(Core.getIdForMod(c)) + " was successfully created with path " + path + Core.getModName(Core.getIdForMod(c)) + ".cfg");
    }

    public static void registerModAbsolute(Class<?> c, String modname, String configPath, IDummyConfig config) throws IOException {
        Core.registerMod(c, modname);
        Core.registerConfigurationFileForMod(c, configPath);
        Core.registerConfigurationHandler(config, c);
        Core.loadConfigForMod(Core.getIdForMod(c));
    }

    private static int getNextModId() {
        int i;
        for (i = 0; i < 512 && modList.containsValue(i); ++i) {
        }
        return i;
    }

    public static int getIdForMod(Class<?> m) {
        if (modList.containsKey(m)) {
            return modList.get(m);
        }
        return 0;
    }

    public static String getModName(int i) {
        return modNameList.get(i);
    }

    public static Configuration getConfigFileForMod(Class<?> c) {
        return config[Core.getIdForMod(c)];
    }

    private static void registerConfigurationHandler(IDummyConfig config, Class<?> c) throws RuntimeException {
        int modId = Core.getIdForMod(c);
        if (configurationHandlers[modId] != null) {
            throw new RuntimeException("Configuration handler for mod " + Core.getModName(modId) + " is already registered!");
        }
        Core.configurationHandlers[modId] = config;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void loadConfigForMod(int t) throws RuntimeException {
        if (isConfigLoaded[t]) throw new RuntimeException("Configuration handler was already initialised!");
        if (configurationHandlers[t] != null && config[t] != null) {
            config[t].load();
            configurationHandlers[t].load(config[t]);
            config[t].save();
        } else if (configurationHandlers[t] == null && config[t] != null || configurationHandlers[t] == null || config[t] == null) {
            // empty if block
        }
        Core.isConfigLoaded[t] = true;
    }

    public static CreativeTabs getItemTabForMod(Class<?> c) {
        return itemsTabs[Core.getIdForMod(c)];
    }

    public static CreativeTabs getBlockTabForMod(Class<?> c) {
        return blocksTabs[Core.getIdForMod(c)];
    }
}

