/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.client.render.particle;

import com.brandon3055.brandonscore.common.utills.Utills;
import com.brandon3055.draconicevolution.client.handler.ClientEventHandler;
import com.brandon3055.draconicevolution.client.handler.ResourceHandler;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.MathHelper;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import org.lwjgl.opengl.GL11;

public class ParticleEnergyBeam
extends EntityFX {
    private int flow;
    private double tX = 0.0;
    private double tY = 0.0;
    private double tZ = 0.0;
    private boolean advanced;
    private boolean renderParticle = true;
    private float length = 0.0f;
    private float rotYaw = 0.0f;
    private float rotPitch = 0.0f;
    private float prevYaw = 0.0f;
    private float prevPitch = 0.0f;
    private EntityPlayer player;
    private static ResourceLocation beamTextureBasic = new ResourceLocation("DraconicEvolution".toLowerCase(), "textures/models/EnergyBeamBlue.png");
    private static ResourceLocation beamTextureAdvanced = new ResourceLocation("DraconicEvolution".toLowerCase(), "textures/models/EnergyBeamRed.png");

    public ParticleEnergyBeam(World world, double x, double y, double z, double tX, double tY, double tZ, int maxAge, int flow, boolean advanced, int offsetMode) {
        super(world, x, y, z, 0.0, 0.0, 0.0);
        this.field_70552_h = 1.0f;
        this.field_70553_i = 1.0f;
        this.field_70551_j = 1.0f;
        this.field_70145_X = true;
        this.field_70159_w = 0.0;
        this.field_70181_x = 0.0;
        this.field_70179_y = 0.0;
        this.field_70547_e = maxAge;
        this.flow = flow;
        this.prevYaw = this.field_70177_z;
        this.prevPitch = this.rotPitch;
        this.func_70105_a(0.2f, 0.2f);
        this.advanced = advanced;
        this.tX = tX;
        this.tY = tY;
        this.tZ = tZ;
        if (offsetMode > 0) {
            double dist = Utills.getDistanceAtoB((double)x, (double)z, (double)tX, (double)tZ);
            if (dist == 0.0) {
                dist = 0.1;
            }
            double xDist = x - tX;
            double zDist = z - tZ;
            double xOff = xDist / dist;
            double zOff = zDist / dist;
            if (xOff == 0.0 && zOff == 0.0) {
                xOff = 1.0;
            }
            double offM = 0.4;
            if (offsetMode == 2 || offsetMode == 3) {
                this.func_70107_b(this.field_70165_t - xOff * offM, this.field_70163_u, this.field_70161_v - zOff * offM);
            }
            if (offsetMode == 1 || offsetMode == 3) {
                this.tX = tX + xOff * offM;
                this.tY = tY;
                this.tZ = tZ + zOff * offM;
            }
        }
    }

    public void update(int flow, boolean render) {
        this.renderParticle = render;
        this.flow = flow;
        while (this.field_70547_e - this.field_70546_d < 4) {
            ++this.field_70547_e;
        }
    }

    public void func_70071_h_() {
        this.field_70169_q = this.field_70165_t;
        this.field_70167_r = this.field_70163_u;
        this.field_70166_s = this.field_70161_v;
        this.prevYaw = this.rotYaw;
        this.prevPitch = this.rotPitch;
        float xd = (float)(this.field_70165_t - this.tX);
        float yd = (float)(this.field_70163_u - this.tY);
        float zd = (float)(this.field_70161_v - this.tZ);
        this.length = MathHelper.func_76129_c((float)(xd * xd + yd * yd + zd * zd));
        double var7 = MathHelper.func_76133_a((double)(xd * xd + zd * zd));
        this.rotYaw = (float)(Math.atan2(xd, zd) * 180.0 / Math.PI);
        this.rotPitch = (float)(Math.atan2(yd, var7) * 180.0 / Math.PI);
        this.prevYaw = this.rotYaw;
        this.prevPitch = this.rotPitch;
        if (this.field_70546_d++ >= this.field_70547_e) {
            this.func_70106_y();
        }
    }

    private EntityPlayer getPlayer() {
        if (this.player == null) {
            this.player = Minecraft.func_71410_x().field_71439_g;
        }
        return this.player;
    }

    public void func_70539_a(Tessellator tessellator, float partialTick, float rotX, float rotXZ, float rotZ, float rotYZ, float rotXY) {
        double var37;
        double var35;
        double var33;
        double var31;
        double var29;
        int t;
        if (!this.renderParticle) {
            return;
        }
        tessellator.func_78381_a();
        GL11.glPushMatrix();
        float var9 = 1.0f;
        float slide = this.getPlayer().field_70173_aa;
        float size = (float)this.flow / 100.0f * 2.0f;
        if (this.advanced) {
            Minecraft.func_71410_x().field_71446_o.func_110577_a(beamTextureAdvanced);
        } else {
            Minecraft.func_71410_x().field_71446_o.func_110577_a(beamTextureBasic);
        }
        GL11.glTexParameterf((int)3553, (int)10242, (float)10497.0f);
        GL11.glTexParameterf((int)3553, (int)10243, (float)10497.0f);
        GL11.glDisable((int)2884);
        float var11 = slide + partialTick;
        float var12 = -var11 * 0.2f - (float)MathHelper.func_76141_d((float)(-var11 * 0.1f));
        GL11.glBlendFunc((int)770, (int)1);
        GL11.glDepthMask((boolean)false);
        float xx = (float)(this.field_70169_q + (this.field_70165_t - this.field_70169_q) * (double)partialTick - field_70556_an);
        float yy = (float)(this.field_70167_r + (this.field_70163_u - this.field_70167_r) * (double)partialTick - field_70554_ao);
        float zz = (float)(this.field_70166_s + (this.field_70161_v - this.field_70166_s) * (double)partialTick - field_70555_ap);
        GL11.glTranslated((double)xx, (double)yy, (double)zz);
        float ry = (float)((double)this.prevYaw + (double)(this.rotYaw - this.prevYaw) * (double)partialTick);
        float rp = (float)((double)this.prevPitch + (double)(this.rotPitch - this.prevPitch) * (double)partialTick);
        GL11.glRotatef((float)90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        GL11.glRotatef((float)(180.0f + ry), (float)0.0f, (float)0.0f, (float)-1.0f);
        GL11.glRotatef((float)rp, (float)1.0f, (float)0.0f, (float)0.0f);
        double var44 = -0.15 * (double)size;
        double var17 = 0.15 * (double)size;
        GL11.glTranslated((double)0.03, (double)0.0, (double)0.0);
        for (t = 0; t < 2; ++t) {
            var29 = this.length * var9;
            var31 = 0.0;
            var33 = 1.0;
            var35 = -1.0f + var12 + (float)t / 3.0f;
            var37 = (double)(this.length * var9) + var35;
            GL11.glRotatef((float)((float)t * 90.0f), (float)0.0f, (float)1.0f, (float)0.0f);
            tessellator.func_78382_b();
            tessellator.func_78380_c(200);
            tessellator.func_78369_a(this.field_70552_h, this.field_70553_i, this.field_70551_j, 1.0f);
            tessellator.func_78374_a(var44, var29, 0.0, var33, var37);
            tessellator.func_78374_a(var44, 0.0, 0.0, var33, var35);
            tessellator.func_78374_a(var17, 0.0, 0.0, var31, var35);
            tessellator.func_78374_a(var17, var29, 0.0, var31, var37);
            tessellator.func_78381_a();
            GL11.glRotatef((float)((float)t * 90.0f), (float)0.0f, (float)-1.0f, (float)0.0f);
        }
        if (ClientEventHandler.playerHoldingWrench) {
            var44 = -0.15;
            var17 = 0.15;
            for (t = 0; t < 2; ++t) {
                var29 = this.length * var9;
                var31 = 0.0;
                var33 = 1.0;
                var35 = -1.0f + var12 + (float)t / 3.0f;
                var37 = (double)(this.length * var9) + var35;
                GL11.glRotatef((float)((float)t * 90.0f), (float)0.0f, (float)1.0f, (float)0.0f);
                tessellator.func_78382_b();
                tessellator.func_78380_c(200);
                tessellator.func_78369_a(0.0f, 1.0f, 0.0f, 1.0f);
                tessellator.func_78374_a(var44, var29, 0.0, var33, var37);
                tessellator.func_78374_a(var44, 0.0, 0.0, var33, var35);
                tessellator.func_78374_a(var17, 0.0, 0.0, var31, var35);
                tessellator.func_78374_a(var17, var29, 0.0, var31, var37);
                tessellator.func_78381_a();
                GL11.glRotatef((float)((float)t * 90.0f), (float)0.0f, (float)-1.0f, (float)0.0f);
            }
        }
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glEnable((int)2884);
        GL11.glPopMatrix();
        ResourceHandler.bindDefaultParticles();
        tessellator.func_78382_b();
    }

    public int getFlow() {
        return this.flow;
    }

    public void setFlow(int flow) {
        this.flow = flow;
    }
}

