/*
 * Decompiled with CFR 0.152.
 */
package minetweaker.api.item;

import java.util.Collections;
import java.util.List;
import minetweaker.api.item.IIngredient;
import minetweaker.api.item.IItemCondition;
import minetweaker.api.item.IItemStack;
import minetweaker.api.item.IItemTransformer;
import minetweaker.api.item.IngredientOr;
import minetweaker.api.item.IngredientStack;
import minetweaker.api.liquid.ILiquidStack;
import minetweaker.api.player.IPlayer;
import minetweaker.util.ArrayUtil;

public class IngredientItem
implements IIngredient {
    private final IItemStack item;
    private final String mark;
    private final IItemCondition[] conditions;
    private final IItemTransformer[] transformers;
    private final List<IItemStack> items;

    public IngredientItem(IItemStack item, String mark, IItemCondition[] conditions, IItemTransformer[] transformers) {
        this.item = item;
        this.mark = mark;
        this.conditions = conditions;
        this.transformers = transformers;
        this.items = Collections.singletonList(item);
    }

    @Override
    public String getMark() {
        return this.mark;
    }

    @Override
    public int getAmount() {
        return this.item.getAmount();
    }

    @Override
    public List<IItemStack> getItems() {
        return this.items;
    }

    @Override
    public List<ILiquidStack> getLiquids() {
        return Collections.emptyList();
    }

    @Override
    public IIngredient amount(int amount) {
        return new IngredientStack(this, amount);
    }

    @Override
    public IIngredient transform(IItemTransformer transformer) {
        return new IngredientItem(this.item, this.mark, this.conditions, ArrayUtil.append(this.transformers, transformer));
    }

    @Override
    public IIngredient only(IItemCondition condition) {
        return new IngredientItem(this.item, this.mark, ArrayUtil.append(this.conditions, condition), this.transformers);
    }

    @Override
    public IIngredient marked(String mark) {
        return new IngredientItem(this.item, mark, this.conditions, this.transformers);
    }

    @Override
    public IIngredient or(IIngredient ingredient) {
        return new IngredientOr(this, ingredient);
    }

    @Override
    public boolean matches(IItemStack item) {
        if (!this.item.matches(item)) {
            return false;
        }
        for (IItemCondition condition : this.conditions) {
            if (condition.matches(item)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean matchesExact(IItemStack item) {
        if (!this.item.matchesExact(item)) {
            return false;
        }
        for (IItemCondition condition : this.conditions) {
            if (condition.matches(item)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean matches(ILiquidStack liquid) {
        return false;
    }

    @Override
    public boolean contains(IIngredient ingredient) {
        List<IItemStack> iitems = ingredient.getItems();
        for (IItemStack iitem : iitems) {
            if (this.matches(iitem)) continue;
            return false;
        }
        return true;
    }

    @Override
    public IItemStack applyTransform(IItemStack item, IPlayer byPlayer) {
        for (IItemTransformer transform : this.transformers) {
            item = transform.transform(item, byPlayer);
        }
        return item;
    }

    @Override
    public boolean hasTransformers() {
        return this.transformers.length > 0;
    }

    @Override
    public Object getInternal() {
        return this.item.getInternal();
    }

    public String toString() {
        return "(Ingredient) " + this.item.toString();
    }
}

