/*
 * Decompiled with CFR 0.152.
 */
package makamys.coretweaks.repackage.com.esotericsoftware.kryo.kryo5.serializers;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Field;
import makamys.coretweaks.repackage.com.esotericsoftware.kryo.kryo5.Kryo;
import makamys.coretweaks.repackage.com.esotericsoftware.kryo.kryo5.KryoException;
import makamys.coretweaks.repackage.com.esotericsoftware.kryo.kryo5.Serializer;
import makamys.coretweaks.repackage.com.esotericsoftware.kryo.kryo5.SerializerFactory;
import makamys.coretweaks.repackage.com.esotericsoftware.kryo.kryo5.io.Input;
import makamys.coretweaks.repackage.com.esotericsoftware.kryo.kryo5.io.Output;
import makamys.coretweaks.repackage.com.esotericsoftware.kryo.kryo5.minlog.Log;
import makamys.coretweaks.repackage.com.esotericsoftware.kryo.kryo5.reflectasm.FieldAccess;
import makamys.coretweaks.repackage.com.esotericsoftware.kryo.kryo5.serializers.CachedFields;
import makamys.coretweaks.repackage.com.esotericsoftware.kryo.kryo5.serializers.ReflectField;
import makamys.coretweaks.repackage.com.esotericsoftware.kryo.kryo5.util.Generics;
import makamys.coretweaks.repackage.com.esotericsoftware.kryo.kryo5.util.Util;

public class FieldSerializer<T>
extends Serializer<T> {
    final Kryo kryo;
    final Class type;
    final FieldSerializerConfig config;
    final CachedFields cachedFields;
    private final Generics.GenericsHierarchy genericsHierarchy;

    public FieldSerializer(Kryo kryo, Class type) {
        this(kryo, type, new FieldSerializerConfig());
    }

    public FieldSerializer(Kryo kryo, Class type, FieldSerializerConfig config) {
        if (type == null) {
            throw new IllegalArgumentException("type cannot be null.");
        }
        if (type.isPrimitive()) {
            throw new IllegalArgumentException("type cannot be a primitive class: " + type);
        }
        if (config == null) {
            throw new IllegalArgumentException("config cannot be null.");
        }
        this.kryo = kryo;
        this.type = type;
        this.config = config;
        this.genericsHierarchy = new Generics.GenericsHierarchy(type);
        this.cachedFields = new CachedFields(this);
        this.cachedFields.rebuild();
    }

    protected void initializeCachedFields() {
    }

    public FieldSerializerConfig getFieldSerializerConfig() {
        return this.config;
    }

    public void updateFields() {
        if (Log.TRACE) {
            Log.trace("kryo", "Update fields: " + Util.className(this.type));
        }
        this.cachedFields.rebuild();
    }

    @Override
    public void write(Kryo kryo, Output output, T object) {
        int pop = this.pushTypeVariables();
        CachedField[] fields = this.cachedFields.fields;
        int n = fields.length;
        for (int i = 0; i < n; ++i) {
            if (Log.TRACE) {
                this.log("Write", fields[i], output.position());
            }
            try {
                fields[i].write(output, object);
                continue;
            }
            catch (KryoException e) {
                throw e;
            }
            catch (Exception | OutOfMemoryError e) {
                throw new KryoException("Error writing " + fields[i] + " at position " + output.position(), e);
            }
        }
        this.popTypeVariables(pop);
    }

    @Override
    public T read(Kryo kryo, Input input, Class<? extends T> type) {
        int pop = this.pushTypeVariables();
        T object = this.create(kryo, input, type);
        kryo.reference(object);
        CachedField[] fields = this.cachedFields.fields;
        int n = fields.length;
        for (int i = 0; i < n; ++i) {
            if (Log.TRACE) {
                this.log("Read", fields[i], input.position());
            }
            try {
                fields[i].read(input, object);
                continue;
            }
            catch (KryoException e) {
                throw e;
            }
            catch (Exception | OutOfMemoryError e) {
                throw new KryoException("Error reading " + fields[i] + " at position " + input.position(), e);
            }
        }
        this.popTypeVariables(pop);
        return object;
    }

    protected int pushTypeVariables() {
        Generics.GenericType[] genericTypes = this.kryo.getGenerics().nextGenericTypes();
        if (genericTypes == null) {
            return 0;
        }
        int pop = this.kryo.getGenerics().pushTypeVariables(this.genericsHierarchy, genericTypes);
        if (Log.TRACE && pop > 0) {
            Log.trace("kryo", "Generics: " + this.kryo.getGenerics());
        }
        return pop;
    }

    protected void popTypeVariables(int pop) {
        Generics generics = this.kryo.getGenerics();
        if (pop > 0) {
            generics.popTypeVariables(pop);
        }
        generics.popGenericType();
    }

    protected T create(Kryo kryo, Input input, Class<? extends T> type) {
        return kryo.newInstance(type);
    }

    protected void log(String prefix, CachedField cachedField, int position) {
        String fieldClassName;
        if (cachedField instanceof ReflectField) {
            ReflectField reflectField = (ReflectField)cachedField;
            Class<?> fieldClass = reflectField.resolveFieldClass();
            if (fieldClass == null) {
                fieldClass = cachedField.field.getType();
            }
            fieldClassName = Util.simpleName(fieldClass, reflectField.genericType);
        } else {
            fieldClassName = cachedField.valueClass != null ? cachedField.valueClass.getSimpleName() : cachedField.field.getType().getSimpleName();
        }
        Log.trace("kryo", prefix + " field " + fieldClassName + ": " + cachedField.name + " (" + Util.className(cachedField.field.getDeclaringClass()) + ')' + Util.pos(position));
    }

    public CachedField getField(String fieldName) {
        for (CachedField cachedField : this.cachedFields.fields) {
            if (!cachedField.name.equals(fieldName)) continue;
            return cachedField;
        }
        throw new IllegalArgumentException("Field \"" + fieldName + "\" not found on class: " + this.type.getName());
    }

    public void removeField(String fieldName) {
        this.cachedFields.removeField(fieldName);
    }

    public void removeField(CachedField field) {
        this.cachedFields.removeField(field);
    }

    public CachedField[] getFields() {
        return this.cachedFields.fields;
    }

    public CachedField[] getCopyFields() {
        return this.cachedFields.copyFields;
    }

    public Class getType() {
        return this.type;
    }

    public Kryo getKryo() {
        return this.kryo;
    }

    protected T createCopy(Kryo kryo, T original) {
        return (T)kryo.newInstance(original.getClass());
    }

    @Override
    public T copy(Kryo kryo, T original) {
        T copy = this.createCopy(kryo, original);
        kryo.reference(copy);
        int n = this.cachedFields.copyFields.length;
        for (int i = 0; i < n; ++i) {
            this.cachedFields.copyFields[i].copy(original, copy);
        }
        return copy;
    }

    public static class FieldSerializerConfig
    implements Cloneable {
        boolean fieldsCanBeNull = true;
        boolean setFieldsAsAccessible = true;
        boolean ignoreSyntheticFields = true;
        boolean fixedFieldTypes;
        boolean copyTransient = true;
        boolean serializeTransient;
        boolean varEncoding = true;
        boolean extendedFieldNames;

        public FieldSerializerConfig clone() {
            try {
                return (FieldSerializerConfig)super.clone();
            }
            catch (CloneNotSupportedException ex) {
                throw new KryoException(ex);
            }
        }

        public void setFieldsCanBeNull(boolean fieldsCanBeNull) {
            this.fieldsCanBeNull = fieldsCanBeNull;
            if (Log.TRACE) {
                Log.trace("kryo", "FieldSerializerConfig fieldsCanBeNull: " + fieldsCanBeNull);
            }
        }

        public boolean getFieldsCanBeNull() {
            return this.fieldsCanBeNull;
        }

        public void setFieldsAsAccessible(boolean setFieldsAsAccessible) {
            this.setFieldsAsAccessible = setFieldsAsAccessible;
            if (Log.TRACE) {
                Log.trace("kryo", "FieldSerializerConfig setFieldsAsAccessible: " + setFieldsAsAccessible);
            }
        }

        public boolean getSetFieldsAsAccessible() {
            return this.setFieldsAsAccessible;
        }

        public void setIgnoreSyntheticFields(boolean ignoreSyntheticFields) {
            this.ignoreSyntheticFields = ignoreSyntheticFields;
            if (Log.TRACE) {
                Log.trace("kryo", "FieldSerializerConfig ignoreSyntheticFields: " + ignoreSyntheticFields);
            }
        }

        public boolean getIgnoreSyntheticFields() {
            return this.ignoreSyntheticFields;
        }

        public void setFixedFieldTypes(boolean fixedFieldTypes) {
            this.fixedFieldTypes = fixedFieldTypes;
            if (Log.TRACE) {
                Log.trace("kryo", "FieldSerializerConfig fixedFieldTypes: " + fixedFieldTypes);
            }
        }

        public boolean getFixedFieldTypes() {
            return this.fixedFieldTypes;
        }

        public void setCopyTransient(boolean copyTransient) {
            this.copyTransient = copyTransient;
            if (Log.TRACE) {
                Log.trace("kryo", "FieldSerializerConfig copyTransient: " + copyTransient);
            }
        }

        public boolean getCopyTransient() {
            return this.copyTransient;
        }

        public void setSerializeTransient(boolean serializeTransient) {
            this.serializeTransient = serializeTransient;
            if (Log.TRACE) {
                Log.trace("kryo", "FieldSerializerConfig serializeTransient: " + serializeTransient);
            }
        }

        public boolean getSerializeTransient() {
            return this.serializeTransient;
        }

        public void setVariableLengthEncoding(boolean varEncoding) {
            this.varEncoding = varEncoding;
            if (Log.TRACE) {
                Log.trace("kryo", "FieldSerializerConfig variable length encoding: " + varEncoding);
            }
        }

        public boolean getVariableLengthEncoding() {
            return this.varEncoding;
        }

        public void setExtendedFieldNames(boolean extendedFieldNames) {
            this.extendedFieldNames = extendedFieldNames;
            if (Log.TRACE) {
                Log.trace("kryo", "FieldSerializerConfig extendedFieldNames: " + extendedFieldNames);
            }
        }

        public boolean getExtendedFieldNames() {
            return this.extendedFieldNames;
        }
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD})
    public static @interface NotNull {
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD})
    public static @interface Bind {
        public Class valueClass() default Object.class;

        public Class<? extends Serializer> serializer() default Serializer.class;

        public Class<? extends SerializerFactory> serializerFactory() default SerializerFactory.class;

        public boolean canBeNull() default true;

        public boolean variableLengthEncoding() default true;

        public boolean optimizePositive() default false;
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD})
    public static @interface Optional {
        public String value();
    }

    public static abstract class CachedField {
        final Field field;
        String name;
        Class valueClass;
        Serializer serializer;
        boolean canBeNull;
        boolean varEncoding = true;
        boolean optimizePositive;
        boolean reuseSerializer = true;
        FieldAccess access;
        int accessIndex = -1;
        long offset;
        int tag;

        public CachedField(Field field) {
            this.field = field;
        }

        public void setValueClass(Class valueClass) {
            this.valueClass = valueClass;
        }

        public Class getValueClass() {
            return this.valueClass;
        }

        public void setValueClass(Class valueClass, Serializer serializer) {
            this.valueClass = valueClass;
            this.serializer = serializer;
        }

        public void setSerializer(Serializer serializer) {
            this.serializer = serializer;
        }

        public Serializer getSerializer() {
            return this.serializer;
        }

        public void setCanBeNull(boolean canBeNull) {
            this.canBeNull = canBeNull;
        }

        public boolean getCanBeNull() {
            return this.canBeNull;
        }

        public void setVariableLengthEncoding(boolean varEncoding) {
            this.varEncoding = varEncoding;
        }

        public boolean getVariableLengthEncoding() {
            return this.varEncoding;
        }

        public void setOptimizePositive(boolean optimizePositive) {
            this.optimizePositive = optimizePositive;
        }

        public boolean getOptimizePositive() {
            return this.optimizePositive;
        }

        void setReuseSerializer(boolean reuseSerializer) {
            this.reuseSerializer = reuseSerializer;
        }

        boolean getReuseSerializer() {
            return this.reuseSerializer;
        }

        public String getName() {
            return this.name;
        }

        public Field getField() {
            return this.field;
        }

        public String toString() {
            return this.name;
        }

        public abstract void write(Output var1, Object var2);

        public abstract void read(Input var1, Object var2);

        public abstract void copy(Object var1, Object var2);
    }
}

