/*
 * Decompiled with CFR 0.152.
 */
package makamys.coretweaks.repackage.com.esotericsoftware.kryo.kryo5;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Modifier;
import java.lang.reflect.Proxy;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.ConcurrentModificationException;
import java.util.Currency;
import java.util.Date;
import java.util.EnumSet;
import java.util.Locale;
import java.util.Map;
import java.util.PriorityQueue;
import java.util.TimeZone;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentSkipListMap;
import makamys.coretweaks.repackage.com.esotericsoftware.kryo.kryo5.ClassResolver;
import makamys.coretweaks.repackage.com.esotericsoftware.kryo.kryo5.DefaultSerializer;
import makamys.coretweaks.repackage.com.esotericsoftware.kryo.kryo5.KryoCopyable;
import makamys.coretweaks.repackage.com.esotericsoftware.kryo.kryo5.KryoException;
import makamys.coretweaks.repackage.com.esotericsoftware.kryo.kryo5.KryoSerializable;
import makamys.coretweaks.repackage.com.esotericsoftware.kryo.kryo5.ReferenceResolver;
import makamys.coretweaks.repackage.com.esotericsoftware.kryo.kryo5.Registration;
import makamys.coretweaks.repackage.com.esotericsoftware.kryo.kryo5.Serializer;
import makamys.coretweaks.repackage.com.esotericsoftware.kryo.kryo5.SerializerFactory;
import makamys.coretweaks.repackage.com.esotericsoftware.kryo.kryo5.io.Input;
import makamys.coretweaks.repackage.com.esotericsoftware.kryo.kryo5.io.Output;
import makamys.coretweaks.repackage.com.esotericsoftware.kryo.kryo5.minlog.Log;
import makamys.coretweaks.repackage.com.esotericsoftware.kryo.kryo5.objenesis.instantiator.ObjectInstantiator;
import makamys.coretweaks.repackage.com.esotericsoftware.kryo.kryo5.objenesis.strategy.InstantiatorStrategy;
import makamys.coretweaks.repackage.com.esotericsoftware.kryo.kryo5.serializers.ClosureSerializer;
import makamys.coretweaks.repackage.com.esotericsoftware.kryo.kryo5.serializers.CollectionSerializer;
import makamys.coretweaks.repackage.com.esotericsoftware.kryo.kryo5.serializers.DefaultArraySerializers;
import makamys.coretweaks.repackage.com.esotericsoftware.kryo.kryo5.serializers.DefaultSerializers;
import makamys.coretweaks.repackage.com.esotericsoftware.kryo.kryo5.serializers.ImmutableCollectionsSerializers;
import makamys.coretweaks.repackage.com.esotericsoftware.kryo.kryo5.serializers.MapSerializer;
import makamys.coretweaks.repackage.com.esotericsoftware.kryo.kryo5.serializers.OptionalSerializers;
import makamys.coretweaks.repackage.com.esotericsoftware.kryo.kryo5.serializers.RecordSerializer;
import makamys.coretweaks.repackage.com.esotericsoftware.kryo.kryo5.serializers.TimeSerializers;
import makamys.coretweaks.repackage.com.esotericsoftware.kryo.kryo5.util.DefaultClassResolver;
import makamys.coretweaks.repackage.com.esotericsoftware.kryo.kryo5.util.DefaultGenerics;
import makamys.coretweaks.repackage.com.esotericsoftware.kryo.kryo5.util.DefaultInstantiatorStrategy;
import makamys.coretweaks.repackage.com.esotericsoftware.kryo.kryo5.util.Generics;
import makamys.coretweaks.repackage.com.esotericsoftware.kryo.kryo5.util.IdentityMap;
import makamys.coretweaks.repackage.com.esotericsoftware.kryo.kryo5.util.IntArray;
import makamys.coretweaks.repackage.com.esotericsoftware.kryo.kryo5.util.MapReferenceResolver;
import makamys.coretweaks.repackage.com.esotericsoftware.kryo.kryo5.util.NoGenerics;
import makamys.coretweaks.repackage.com.esotericsoftware.kryo.kryo5.util.ObjectMap;
import makamys.coretweaks.repackage.com.esotericsoftware.kryo.kryo5.util.Util;

public class Kryo {
    public static final byte NULL = 0;
    public static final byte NOT_NULL = 1;
    private static final int REF = -1;
    private static final int NO_REF = -2;
    private static final int DEFAULT_SERIALIZER_SIZE = 68;
    private SerializerFactory defaultSerializer = new SerializerFactory.FieldSerializerFactory();
    private final ArrayList<DefaultSerializerEntry> defaultSerializers = new ArrayList(68);
    private final int lowPriorityDefaultSerializerCount;
    private final ClassResolver classResolver;
    private int nextRegisterID;
    private ClassLoader classLoader = this.getClass().getClassLoader();
    private InstantiatorStrategy strategy = new DefaultInstantiatorStrategy();
    private boolean registrationRequired = true;
    private boolean warnUnregisteredClasses;
    private int depth;
    private int maxDepth = Integer.MAX_VALUE;
    private boolean autoReset = true;
    private volatile Thread thread;
    private ObjectMap context;
    private ObjectMap graphContext;
    private ReferenceResolver referenceResolver;
    private final IntArray readReferenceIds = new IntArray(0);
    private boolean references;
    private boolean copyReferences = true;
    private Object readObject;
    private int copyDepth;
    private boolean copyShallow;
    private IdentityMap originalToCopy;
    private Object needsCopyReference;
    private Generics generics = new DefaultGenerics(this);

    public Kryo() {
        this(new DefaultClassResolver(), null);
    }

    public Kryo(ReferenceResolver referenceResolver) {
        this(new DefaultClassResolver(), referenceResolver);
    }

    public Kryo(ClassResolver classResolver, ReferenceResolver referenceResolver) {
        if (classResolver == null) {
            throw new IllegalArgumentException("classResolver cannot be null.");
        }
        this.classResolver = classResolver;
        classResolver.setKryo(this);
        this.referenceResolver = referenceResolver;
        if (referenceResolver != null) {
            referenceResolver.setKryo(this);
            this.references = true;
        }
        this.addDefaultSerializer(byte[].class, DefaultArraySerializers.ByteArraySerializer.class);
        this.addDefaultSerializer(char[].class, DefaultArraySerializers.CharArraySerializer.class);
        this.addDefaultSerializer(short[].class, DefaultArraySerializers.ShortArraySerializer.class);
        this.addDefaultSerializer(int[].class, DefaultArraySerializers.IntArraySerializer.class);
        this.addDefaultSerializer(long[].class, DefaultArraySerializers.LongArraySerializer.class);
        this.addDefaultSerializer(float[].class, DefaultArraySerializers.FloatArraySerializer.class);
        this.addDefaultSerializer(double[].class, DefaultArraySerializers.DoubleArraySerializer.class);
        this.addDefaultSerializer(boolean[].class, DefaultArraySerializers.BooleanArraySerializer.class);
        this.addDefaultSerializer(String[].class, DefaultArraySerializers.StringArraySerializer.class);
        this.addDefaultSerializer(Object[].class, DefaultArraySerializers.ObjectArraySerializer.class);
        this.addDefaultSerializer(BigInteger.class, DefaultSerializers.BigIntegerSerializer.class);
        this.addDefaultSerializer(BigDecimal.class, DefaultSerializers.BigDecimalSerializer.class);
        this.addDefaultSerializer(Class.class, DefaultSerializers.ClassSerializer.class);
        this.addDefaultSerializer(Date.class, DefaultSerializers.DateSerializer.class);
        this.addDefaultSerializer(Enum.class, DefaultSerializers.EnumSerializer.class);
        this.addDefaultSerializer(EnumSet.class, DefaultSerializers.EnumSetSerializer.class);
        this.addDefaultSerializer(Currency.class, DefaultSerializers.CurrencySerializer.class);
        this.addDefaultSerializer(StringBuffer.class, DefaultSerializers.StringBufferSerializer.class);
        this.addDefaultSerializer(StringBuilder.class, DefaultSerializers.StringBuilderSerializer.class);
        this.addDefaultSerializer(Collections.EMPTY_LIST.getClass(), DefaultSerializers.CollectionsEmptyListSerializer.class);
        this.addDefaultSerializer(Collections.EMPTY_MAP.getClass(), DefaultSerializers.CollectionsEmptyMapSerializer.class);
        this.addDefaultSerializer(Collections.EMPTY_SET.getClass(), DefaultSerializers.CollectionsEmptySetSerializer.class);
        this.addDefaultSerializer(Collections.singletonList(null).getClass(), DefaultSerializers.CollectionsSingletonListSerializer.class);
        this.addDefaultSerializer(Collections.singletonMap(null, null).getClass(), DefaultSerializers.CollectionsSingletonMapSerializer.class);
        this.addDefaultSerializer(Collections.singleton(null).getClass(), DefaultSerializers.CollectionsSingletonSetSerializer.class);
        this.addDefaultSerializer(TreeSet.class, DefaultSerializers.TreeSetSerializer.class);
        this.addDefaultSerializer(Collection.class, CollectionSerializer.class);
        this.addDefaultSerializer(ConcurrentSkipListMap.class, DefaultSerializers.ConcurrentSkipListMapSerializer.class);
        this.addDefaultSerializer(TreeMap.class, DefaultSerializers.TreeMapSerializer.class);
        this.addDefaultSerializer(Map.class, MapSerializer.class);
        this.addDefaultSerializer(TimeZone.class, DefaultSerializers.TimeZoneSerializer.class);
        this.addDefaultSerializer(Calendar.class, DefaultSerializers.CalendarSerializer.class);
        this.addDefaultSerializer(Locale.class, DefaultSerializers.LocaleSerializer.class);
        this.addDefaultSerializer(Charset.class, DefaultSerializers.CharsetSerializer.class);
        this.addDefaultSerializer(URL.class, DefaultSerializers.URLSerializer.class);
        this.addDefaultSerializer(Arrays.asList(new Object[0]).getClass(), DefaultSerializers.ArraysAsListSerializer.class);
        this.addDefaultSerializer(Void.TYPE, new DefaultSerializers.VoidSerializer());
        this.addDefaultSerializer(PriorityQueue.class, new DefaultSerializers.PriorityQueueSerializer());
        this.addDefaultSerializer(BitSet.class, new DefaultSerializers.BitSetSerializer());
        this.addDefaultSerializer(KryoSerializable.class, DefaultSerializers.KryoSerializableSerializer.class);
        OptionalSerializers.addDefaultSerializers(this);
        TimeSerializers.addDefaultSerializers(this);
        ImmutableCollectionsSerializers.addDefaultSerializers(this);
        if (Util.isClassAvailable("java.lang.Record")) {
            this.addDefaultSerializer("java.lang.Record", RecordSerializer.class);
        }
        this.lowPriorityDefaultSerializerCount = this.defaultSerializers.size();
        this.register(Integer.TYPE, new DefaultSerializers.IntSerializer());
        this.register(String.class, new DefaultSerializers.StringSerializer());
        this.register(Float.TYPE, new DefaultSerializers.FloatSerializer());
        this.register(Boolean.TYPE, new DefaultSerializers.BooleanSerializer());
        this.register(Byte.TYPE, new DefaultSerializers.ByteSerializer());
        this.register(Character.TYPE, new DefaultSerializers.CharSerializer());
        this.register(Short.TYPE, new DefaultSerializers.ShortSerializer());
        this.register(Long.TYPE, new DefaultSerializers.LongSerializer());
        this.register(Double.TYPE, new DefaultSerializers.DoubleSerializer());
    }

    public void setDefaultSerializer(SerializerFactory serializer) {
        if (serializer == null) {
            throw new IllegalArgumentException("serializer cannot be null.");
        }
        this.defaultSerializer = serializer;
    }

    public void setDefaultSerializer(Class<? extends Serializer> serializer) {
        if (serializer == null) {
            throw new IllegalArgumentException("serializer cannot be null.");
        }
        this.defaultSerializer = new SerializerFactory.ReflectionSerializerFactory<Serializer>(serializer);
    }

    public void addDefaultSerializer(Class type, Serializer serializer) {
        if (type == null) {
            throw new IllegalArgumentException("type cannot be null.");
        }
        if (serializer == null) {
            throw new IllegalArgumentException("serializer cannot be null.");
        }
        this.insertDefaultSerializer(type, new SerializerFactory.SingletonSerializerFactory<Serializer>(serializer));
    }

    public void addDefaultSerializer(Class type, SerializerFactory serializerFactory) {
        if (type == null) {
            throw new IllegalArgumentException("type cannot be null.");
        }
        if (serializerFactory == null) {
            throw new IllegalArgumentException("serializerFactory cannot be null.");
        }
        this.insertDefaultSerializer(type, serializerFactory);
    }

    private void addDefaultSerializer(String className, Class<? extends Serializer> serializer) {
        try {
            this.addDefaultSerializer(Class.forName(className), serializer);
        }
        catch (ClassNotFoundException e) {
            throw new KryoException("default serializer cannot be added: " + className);
        }
    }

    public void addDefaultSerializer(Class type, Class<? extends Serializer> serializerClass) {
        if (type == null) {
            throw new IllegalArgumentException("type cannot be null.");
        }
        if (serializerClass == null) {
            throw new IllegalArgumentException("serializerClass cannot be null.");
        }
        this.insertDefaultSerializer(type, new SerializerFactory.ReflectionSerializerFactory<Serializer>(serializerClass));
    }

    private int insertDefaultSerializer(Class type, SerializerFactory factory) {
        int lowest = 0;
        int n = this.defaultSerializers.size() - this.lowPriorityDefaultSerializerCount;
        for (int i = 0; i < n; ++i) {
            if (!type.isAssignableFrom(this.defaultSerializers.get((int)i).type)) continue;
            lowest = i + 1;
        }
        this.defaultSerializers.add(lowest, new DefaultSerializerEntry(type, factory));
        return lowest;
    }

    public Serializer getDefaultSerializer(Class type) {
        if (type == null) {
            throw new IllegalArgumentException("type cannot be null.");
        }
        Serializer serializerForAnnotation = this.getDefaultSerializerForAnnotatedType(type);
        if (serializerForAnnotation != null) {
            return serializerForAnnotation;
        }
        int n = this.defaultSerializers.size();
        for (int i = 0; i < n; ++i) {
            DefaultSerializerEntry entry = this.defaultSerializers.get(i);
            if (!entry.type.isAssignableFrom(type) || !entry.serializerFactory.isSupported(type)) continue;
            return entry.serializerFactory.newSerializer(this, type);
        }
        return this.newDefaultSerializer(type);
    }

    protected Serializer getDefaultSerializerForAnnotatedType(Class type) {
        if (type.isAnnotationPresent(DefaultSerializer.class)) {
            DefaultSerializer annotation = type.getAnnotation(DefaultSerializer.class);
            return Util.newFactory(annotation.serializerFactory(), annotation.value()).newSerializer(this, type);
        }
        return null;
    }

    protected Serializer newDefaultSerializer(Class type) {
        return this.defaultSerializer.newSerializer(this, type);
    }

    public Registration register(Class type) {
        Registration registration = this.classResolver.getRegistration(type);
        if (registration != null) {
            return registration;
        }
        return this.register(type, this.getDefaultSerializer(type));
    }

    public Registration register(Class type, int id) {
        Registration registration = this.classResolver.getRegistration(type);
        if (registration != null) {
            return registration;
        }
        return this.register(type, this.getDefaultSerializer(type), id);
    }

    public Registration register(Class type, Serializer serializer) {
        Registration registration = this.classResolver.getRegistration(type);
        if (registration != null) {
            registration.setSerializer(serializer);
            return registration;
        }
        return this.classResolver.register(new Registration(type, serializer, this.getNextRegistrationId()));
    }

    public Registration register(Class type, Serializer serializer, int id) {
        if (id < 0) {
            throw new IllegalArgumentException("id must be >= 0: " + id);
        }
        return this.register(new Registration(type, serializer, id));
    }

    public Registration register(Registration registration) {
        int id = registration.getId();
        if (id < 0) {
            throw new IllegalArgumentException("id must be > 0: " + id);
        }
        Registration existing = this.classResolver.unregister(id);
        if (Log.DEBUG && existing != null && existing.getType() != registration.getType()) {
            Log.debug("kryo", "Registration overwritten: " + existing + " -> " + registration);
        }
        return this.classResolver.register(registration);
    }

    public int getNextRegistrationId() {
        while (this.nextRegisterID != -2) {
            if (this.classResolver.getRegistration(this.nextRegisterID) == null) {
                return this.nextRegisterID;
            }
            ++this.nextRegisterID;
        }
        throw new KryoException("No registration IDs are available.");
    }

    public Registration getRegistration(Class type) {
        if (type == null) {
            throw new IllegalArgumentException("type cannot be null.");
        }
        Registration registration = this.classResolver.getRegistration(type);
        if (registration == null) {
            if (this.isProxy(type)) {
                registration = this.getRegistration(InvocationHandler.class);
            } else if (!type.isEnum() && Enum.class.isAssignableFrom(type) && type != Enum.class) {
                while ((type = type.getSuperclass()) != null) {
                    if (!type.isEnum()) continue;
                    registration = this.classResolver.getRegistration(type);
                    break;
                }
            } else if (EnumSet.class.isAssignableFrom(type)) {
                registration = this.classResolver.getRegistration(EnumSet.class);
            } else if (this.isClosure(type)) {
                registration = this.classResolver.getRegistration(ClosureSerializer.Closure.class);
            }
            if (registration == null) {
                if (this.registrationRequired) {
                    throw new IllegalArgumentException(this.unregisteredClassMessage(type));
                }
                if (Log.WARN && this.warnUnregisteredClasses) {
                    Log.warn(this.unregisteredClassMessage(type));
                }
                registration = this.classResolver.registerImplicit(type);
            }
        }
        return registration;
    }

    protected String unregisteredClassMessage(Class type) {
        return "Class is not registered: " + Util.className(type) + "\nNote: To register this class use: kryo.register(" + Util.canonicalName(type) + ".class);";
    }

    public Registration getRegistration(int classID) {
        return this.classResolver.getRegistration(classID);
    }

    public Serializer getSerializer(Class type) {
        return this.getRegistration(type).getSerializer();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Registration writeClass(Output output, Class type) {
        if (output == null) {
            throw new IllegalArgumentException("output cannot be null.");
        }
        try {
            Registration registration = this.classResolver.writeClass(output, type);
            return registration;
        }
        finally {
            if (this.depth == 0 && this.autoReset) {
                this.reset();
            }
        }
    }

    public void writeObject(Output output, Object object) {
        if (output == null) {
            throw new IllegalArgumentException("output cannot be null.");
        }
        if (object == null) {
            throw new IllegalArgumentException("object cannot be null.");
        }
        this.beginObject();
        try {
            if (this.references && this.writeReferenceOrNull(output, object, false)) {
                return;
            }
            if (Log.TRACE || Log.DEBUG && this.depth == 1) {
                Util.log("Write", object, output.position());
            }
            this.getRegistration(object.getClass()).getSerializer().write(this, output, object);
        }
        finally {
            if (--this.depth == 0 && this.autoReset) {
                this.reset();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeObject(Output output, Object object, Serializer serializer) {
        if (output == null) {
            throw new IllegalArgumentException("output cannot be null.");
        }
        if (object == null) {
            throw new IllegalArgumentException("object cannot be null.");
        }
        if (serializer == null) {
            throw new IllegalArgumentException("serializer cannot be null.");
        }
        this.beginObject();
        try {
            if (this.references && this.writeReferenceOrNull(output, object, false)) {
                return;
            }
            if (Log.TRACE || Log.DEBUG && this.depth == 1) {
                Util.log("Write", object, output.position());
            }
            serializer.write(this, output, object);
        }
        finally {
            if (--this.depth == 0 && this.autoReset) {
                this.reset();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeObjectOrNull(Output output, Object object, Class type) {
        if (output == null) {
            throw new IllegalArgumentException("output cannot be null.");
        }
        this.beginObject();
        try {
            Serializer serializer = this.getRegistration(type).getSerializer();
            if (this.references) {
                if (this.writeReferenceOrNull(output, object, true)) {
                    return;
                }
            } else if (!serializer.getAcceptsNull()) {
                if (object == null) {
                    if (Log.TRACE || Log.DEBUG && this.depth == 1) {
                        Util.log("Write", object, output.position());
                    }
                    output.writeByte((byte)0);
                    return;
                }
                if (Log.TRACE) {
                    Log.trace("kryo", "Write: <not null>" + Util.pos(output.position()));
                }
                output.writeByte((byte)1);
            }
            if (Log.TRACE || Log.DEBUG && this.depth == 1) {
                Util.log("Write", object, output.position());
            }
            serializer.write(this, output, object);
        }
        finally {
            if (--this.depth == 0 && this.autoReset) {
                this.reset();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeObjectOrNull(Output output, Object object, Serializer serializer) {
        if (output == null) {
            throw new IllegalArgumentException("output cannot be null.");
        }
        if (serializer == null) {
            throw new IllegalArgumentException("serializer cannot be null.");
        }
        this.beginObject();
        try {
            if (this.references) {
                if (this.writeReferenceOrNull(output, object, true)) {
                    return;
                }
            } else if (!serializer.getAcceptsNull()) {
                if (object == null) {
                    if (Log.TRACE || Log.DEBUG && this.depth == 1) {
                        Util.log("Write", null, output.position());
                    }
                    output.writeByte((byte)0);
                    return;
                }
                if (Log.TRACE) {
                    Log.trace("kryo", "Write: <not null>" + Util.pos(output.position()));
                }
                output.writeByte((byte)1);
            }
            if (Log.TRACE || Log.DEBUG && this.depth == 1) {
                Util.log("Write", object, output.position());
            }
            serializer.write(this, output, object);
        }
        finally {
            if (--this.depth == 0 && this.autoReset) {
                this.reset();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeClassAndObject(Output output, Object object) {
        if (output == null) {
            throw new IllegalArgumentException("output cannot be null.");
        }
        this.beginObject();
        try {
            if (object == null) {
                this.writeClass(output, null);
                return;
            }
            Registration registration = this.writeClass(output, object.getClass());
            if (this.references && this.writeReferenceOrNull(output, object, false)) {
                return;
            }
            if (Log.TRACE || Log.DEBUG && this.depth == 1) {
                Util.log("Write", object, output.position());
            }
            registration.getSerializer().write(this, output, object);
        }
        finally {
            if (--this.depth == 0 && this.autoReset) {
                this.reset();
            }
        }
    }

    boolean writeReferenceOrNull(Output output, Object object, boolean mayBeNull) {
        if (object == null) {
            if (Log.TRACE || Log.DEBUG && this.depth == 1) {
                Util.log("Write", null, output.position());
            }
            output.writeByte((byte)0);
            return true;
        }
        if (!this.referenceResolver.useReferences(object.getClass())) {
            if (mayBeNull) {
                if (Log.TRACE) {
                    Log.trace("kryo", "Write: <not null>" + Util.pos(output.position()));
                }
                output.writeByte((byte)1);
            }
            return false;
        }
        int id = this.referenceResolver.getWrittenId(object);
        if (id != -1) {
            if (Log.DEBUG) {
                Log.debug("kryo", "Write reference " + id + ": " + Util.string(object) + Util.pos(output.position()));
            }
            output.writeVarInt(id + 2, true);
            return true;
        }
        id = this.referenceResolver.addWrittenObject(object);
        if (Log.TRACE) {
            Log.trace("kryo", "Write: <not null>" + Util.pos(output.position()));
        }
        output.writeByte((byte)1);
        if (Log.TRACE) {
            Log.trace("kryo", "Write initial reference " + id + ": " + Util.string(object) + Util.pos(output.position()));
        }
        return false;
    }

    public Registration readClass(Input input) {
        if (input == null) {
            throw new IllegalArgumentException("input cannot be null.");
        }
        try {
            Registration registration = this.classResolver.readClass(input);
            return registration;
        }
        finally {
            if (this.depth == 0 && this.autoReset) {
                this.reset();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T readObject(Input input, Class<T> type) {
        if (input == null) {
            throw new IllegalArgumentException("input cannot be null.");
        }
        if (type == null) {
            throw new IllegalArgumentException("type cannot be null.");
        }
        this.beginObject();
        try {
            T object;
            if (this.references) {
                int stackSize = this.readReferenceOrNull(input, type, false);
                if (stackSize == -1) {
                    Object object2 = this.readObject;
                    return (T)object2;
                }
                object = this.getRegistration(type).getSerializer().read(this, input, type);
                if (stackSize == this.readReferenceIds.size) {
                    this.reference(object);
                }
            } else {
                object = this.getRegistration(type).getSerializer().read(this, input, type);
            }
            if (Log.TRACE || Log.DEBUG && this.depth == 1) {
                Util.log("Read", object, input.position());
            }
            T t = object;
            return t;
        }
        finally {
            if (--this.depth == 0 && this.autoReset) {
                this.reset();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T readObject(Input input, Class<T> type, Serializer serializer) {
        if (input == null) {
            throw new IllegalArgumentException("input cannot be null.");
        }
        if (type == null) {
            throw new IllegalArgumentException("type cannot be null.");
        }
        if (serializer == null) {
            throw new IllegalArgumentException("serializer cannot be null.");
        }
        this.beginObject();
        try {
            T object;
            if (this.references) {
                int stackSize = this.readReferenceOrNull(input, type, false);
                if (stackSize == -1) {
                    Object object2 = this.readObject;
                    return (T)object2;
                }
                object = serializer.read(this, input, type);
                if (stackSize == this.readReferenceIds.size) {
                    this.reference(object);
                }
            } else {
                object = serializer.read(this, input, type);
            }
            if (Log.TRACE || Log.DEBUG && this.depth == 1) {
                Util.log("Read", object, input.position());
            }
            T t = object;
            return t;
        }
        finally {
            if (--this.depth == 0 && this.autoReset) {
                this.reset();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T readObjectOrNull(Input input, Class<T> type) {
        if (input == null) {
            throw new IllegalArgumentException("input cannot be null.");
        }
        if (type == null) {
            throw new IllegalArgumentException("type cannot be null.");
        }
        this.beginObject();
        try {
            T object;
            if (this.references) {
                int stackSize = this.readReferenceOrNull(input, type, true);
                if (stackSize == -1) {
                    Object object2 = this.readObject;
                    return (T)object2;
                }
                object = this.getRegistration(type).getSerializer().read(this, input, type);
                if (stackSize == this.readReferenceIds.size) {
                    this.reference(object);
                }
            } else {
                Serializer serializer = this.getRegistration(type).getSerializer();
                if (!serializer.getAcceptsNull() && input.readByte() == 0) {
                    if (Log.TRACE || Log.DEBUG && this.depth == 1) {
                        Util.log("Read", null, input.position());
                    }
                    T t = null;
                    return t;
                }
                object = serializer.read(this, input, type);
            }
            if (Log.TRACE || Log.DEBUG && this.depth == 1) {
                Util.log("Read", object, input.position());
            }
            T t = object;
            return t;
        }
        finally {
            if (--this.depth == 0 && this.autoReset) {
                this.reset();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T readObjectOrNull(Input input, Class<T> type, Serializer serializer) {
        if (input == null) {
            throw new IllegalArgumentException("input cannot be null.");
        }
        if (type == null) {
            throw new IllegalArgumentException("type cannot be null.");
        }
        if (serializer == null) {
            throw new IllegalArgumentException("serializer cannot be null.");
        }
        this.beginObject();
        try {
            T object;
            if (this.references) {
                int stackSize = this.readReferenceOrNull(input, type, true);
                if (stackSize == -1) {
                    Object object2 = this.readObject;
                    return (T)object2;
                }
                object = serializer.read(this, input, type);
                if (stackSize == this.readReferenceIds.size) {
                    this.reference(object);
                }
            } else {
                if (!serializer.getAcceptsNull() && input.readByte() == 0) {
                    if (Log.TRACE || Log.DEBUG && this.depth == 1) {
                        Util.log("Read", null, input.position());
                    }
                    T t = null;
                    return t;
                }
                object = serializer.read(this, input, type);
            }
            if (Log.TRACE || Log.DEBUG && this.depth == 1) {
                Util.log("Read", object, input.position());
            }
            T t = object;
            return t;
        }
        finally {
            if (--this.depth == 0 && this.autoReset) {
                this.reset();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object readClassAndObject(Input input) {
        if (input == null) {
            throw new IllegalArgumentException("input cannot be null.");
        }
        this.beginObject();
        try {
            Object object;
            Registration registration = this.readClass(input);
            if (registration == null) {
                Object var3_3 = null;
                return var3_3;
            }
            Class type = registration.getType();
            if (this.references) {
                int stackSize = this.readReferenceOrNull(input, type, false);
                if (stackSize == -1) {
                    Object object2 = this.readObject;
                    return object2;
                }
                object = registration.getSerializer().read(this, input, type);
                if (stackSize == this.readReferenceIds.size) {
                    this.reference(object);
                }
            } else {
                object = registration.getSerializer().read(this, input, type);
            }
            if (Log.TRACE || Log.DEBUG && this.depth == 1) {
                Util.log("Read", object, input.position());
            }
            Object t = object;
            return t;
        }
        finally {
            if (--this.depth == 0 && this.autoReset) {
                this.reset();
            }
        }
    }

    int readReferenceOrNull(Input input, Class type, boolean mayBeNull) {
        int id;
        if (type.isPrimitive()) {
            type = Util.getWrapperClass(type);
        }
        boolean referencesSupported = this.referenceResolver.useReferences(type);
        if (mayBeNull) {
            id = input.readVarInt(true);
            if (id == 0) {
                if (Log.TRACE || Log.DEBUG && this.depth == 1) {
                    Util.log("Read", null, input.position());
                }
                this.readObject = null;
                return -1;
            }
            if (!referencesSupported) {
                this.readReferenceIds.add(-2);
                return this.readReferenceIds.size;
            }
        } else {
            if (!referencesSupported) {
                this.readReferenceIds.add(-2);
                return this.readReferenceIds.size;
            }
            id = input.readVarInt(true);
        }
        if (id == 1) {
            if (Log.TRACE) {
                Log.trace("kryo", "Read: <not null>" + Util.pos(input.position()));
            }
            id = this.referenceResolver.nextReadId(type);
            if (Log.TRACE) {
                Log.trace("kryo", "Read initial reference " + id + ": " + Util.className(type) + Util.pos(input.position()));
            }
            this.readReferenceIds.add(id);
            return this.readReferenceIds.size;
        }
        id -= 2;
        try {
            this.readObject = this.referenceResolver.getReadObject(type, id);
        }
        catch (Exception e) {
            throw new KryoException("Unable to resolve reference for " + Util.className(type) + " with id: " + id, e);
        }
        if (Log.DEBUG) {
            Log.debug("kryo", "Read reference " + id + ": " + Util.string(this.readObject) + Util.pos(input.position()));
        }
        return -1;
    }

    public void reference(Object object) {
        int id;
        if (this.copyDepth > 0) {
            if (this.needsCopyReference != null) {
                if (object == null) {
                    throw new IllegalArgumentException("object cannot be null.");
                }
                this.originalToCopy.put(this.needsCopyReference, object);
                this.needsCopyReference = null;
            }
        } else if (this.references && object != null && (id = this.readReferenceIds.pop()) != -2) {
            this.referenceResolver.setReadObject(id, object);
        }
    }

    public void reset() {
        this.depth = 0;
        if (this.graphContext != null) {
            this.graphContext.clear(2048);
        }
        this.classResolver.reset();
        if (this.references) {
            this.referenceResolver.reset();
            this.readObject = null;
        }
        this.copyDepth = 0;
        if (this.originalToCopy != null) {
            this.originalToCopy.clear(2048);
        }
        if (Log.TRACE) {
            Log.trace("kryo", "Object graph complete.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T copy(T object) {
        if (object == null) {
            return null;
        }
        if (this.copyShallow) {
            return object;
        }
        ++this.copyDepth;
        try {
            Object existingCopy;
            if (this.originalToCopy == null) {
                this.originalToCopy = new IdentityMap();
            }
            if ((existingCopy = this.originalToCopy.get(object)) != null) {
                Object v = existingCopy;
                return (T)v;
            }
            if (this.copyReferences) {
                this.needsCopyReference = object;
            }
            Object copy = object instanceof KryoCopyable ? ((KryoCopyable)object).copy(this) : this.getSerializer(object.getClass()).copy(this, object);
            if (this.needsCopyReference != null) {
                this.reference(copy);
            }
            if (Log.TRACE || Log.DEBUG && this.copyDepth == 1) {
                Util.log("Copy", copy, -1);
            }
            Object t = copy;
            return t;
        }
        finally {
            if (--this.copyDepth == 0) {
                this.reset();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T copy(T object, Serializer serializer) {
        if (object == null) {
            return null;
        }
        if (this.copyShallow) {
            return object;
        }
        ++this.copyDepth;
        try {
            Object existingCopy;
            if (this.originalToCopy == null) {
                this.originalToCopy = new IdentityMap();
            }
            if ((existingCopy = this.originalToCopy.get(object)) != null) {
                Object v = existingCopy;
                return (T)v;
            }
            if (this.copyReferences) {
                this.needsCopyReference = object;
            }
            Object copy = object instanceof KryoCopyable ? ((KryoCopyable)object).copy(this) : serializer.copy(this, object);
            if (this.needsCopyReference != null) {
                this.reference(copy);
            }
            if (Log.TRACE || Log.DEBUG && this.copyDepth == 1) {
                Util.log("Copy", copy, -1);
            }
            Object t = copy;
            return t;
        }
        finally {
            if (--this.copyDepth == 0) {
                this.reset();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T copyShallow(T object) {
        if (object == null) {
            return null;
        }
        ++this.copyDepth;
        this.copyShallow = true;
        try {
            Object existingCopy;
            if (this.originalToCopy == null) {
                this.originalToCopy = new IdentityMap();
            }
            if ((existingCopy = this.originalToCopy.get(object)) != null) {
                Object v = existingCopy;
                return (T)v;
            }
            if (this.copyReferences) {
                this.needsCopyReference = object;
            }
            Object copy = object instanceof KryoCopyable ? ((KryoCopyable)object).copy(this) : this.getSerializer(object.getClass()).copy(this, object);
            if (this.needsCopyReference != null) {
                this.reference(copy);
            }
            if (Log.TRACE || Log.DEBUG && this.copyDepth == 1) {
                Util.log("Shallow copy", copy, -1);
            }
            Object t = copy;
            return t;
        }
        finally {
            this.copyShallow = false;
            if (--this.copyDepth == 0) {
                this.reset();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T copyShallow(T object, Serializer serializer) {
        if (object == null) {
            return null;
        }
        ++this.copyDepth;
        this.copyShallow = true;
        try {
            Object existingCopy;
            if (this.originalToCopy == null) {
                this.originalToCopy = new IdentityMap();
            }
            if ((existingCopy = this.originalToCopy.get(object)) != null) {
                Object v = existingCopy;
                return (T)v;
            }
            if (this.copyReferences) {
                this.needsCopyReference = object;
            }
            Object copy = object instanceof KryoCopyable ? ((KryoCopyable)object).copy(this) : serializer.copy(this, object);
            if (this.needsCopyReference != null) {
                this.reference(copy);
            }
            if (Log.TRACE || Log.DEBUG && this.copyDepth == 1) {
                Util.log("Shallow copy", copy, -1);
            }
            Object t = copy;
            return t;
        }
        finally {
            this.copyShallow = false;
            if (--this.copyDepth == 0) {
                this.reset();
            }
        }
    }

    private void beginObject() {
        if (Log.DEBUG) {
            if (this.depth == 0) {
                this.thread = Thread.currentThread();
            } else if (this.thread != Thread.currentThread()) {
                throw new ConcurrentModificationException("Kryo must not be accessed concurrently by multiple threads.");
            }
        }
        if (this.depth == this.maxDepth) {
            throw new KryoException("Max depth exceeded: " + this.depth);
        }
        ++this.depth;
    }

    public ClassResolver getClassResolver() {
        return this.classResolver;
    }

    public ReferenceResolver getReferenceResolver() {
        return this.referenceResolver;
    }

    public void setClassLoader(ClassLoader classLoader) {
        if (classLoader == null) {
            throw new IllegalArgumentException("classLoader cannot be null.");
        }
        this.classLoader = classLoader;
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public void setRegistrationRequired(boolean registrationRequired) {
        this.registrationRequired = registrationRequired;
        if (Log.TRACE) {
            Log.trace("kryo", "Registration required: " + registrationRequired);
        }
    }

    public boolean isRegistrationRequired() {
        return this.registrationRequired;
    }

    public void setWarnUnregisteredClasses(boolean warnUnregisteredClasses) {
        this.warnUnregisteredClasses = warnUnregisteredClasses;
        if (Log.TRACE) {
            Log.trace("kryo", "Warn unregistered classes: " + warnUnregisteredClasses);
        }
    }

    public boolean getWarnUnregisteredClasses() {
        return this.warnUnregisteredClasses;
    }

    public boolean setReferences(boolean references) {
        boolean old = this.references;
        if (references == old) {
            return references;
        }
        if (old) {
            this.referenceResolver.reset();
            this.readObject = null;
        }
        this.references = references;
        if (references && this.referenceResolver == null) {
            this.referenceResolver = new MapReferenceResolver();
        }
        if (Log.TRACE) {
            Log.trace("kryo", "References: " + references);
        }
        return !references;
    }

    public void setCopyReferences(boolean copyReferences) {
        this.copyReferences = copyReferences;
    }

    public void setReferenceResolver(ReferenceResolver referenceResolver) {
        if (referenceResolver == null) {
            throw new IllegalArgumentException("referenceResolver cannot be null.");
        }
        this.references = true;
        this.referenceResolver = referenceResolver;
        if (Log.TRACE) {
            Log.trace("kryo", "Reference resolver: " + referenceResolver.getClass().getName());
        }
    }

    public boolean getReferences() {
        return this.references;
    }

    public void setInstantiatorStrategy(InstantiatorStrategy strategy) {
        this.strategy = strategy;
    }

    public InstantiatorStrategy getInstantiatorStrategy() {
        return this.strategy;
    }

    protected ObjectInstantiator newInstantiator(Class type) {
        return this.strategy.newInstantiatorOf(type);
    }

    public <T> T newInstance(Class<T> type) {
        Registration registration = this.getRegistration(type);
        ObjectInstantiator instantiator = registration.getInstantiator();
        if (instantiator == null) {
            instantiator = this.newInstantiator(type);
            registration.setInstantiator(instantiator);
        }
        return instantiator.newInstance();
    }

    public ObjectMap getContext() {
        if (this.context == null) {
            this.context = new ObjectMap();
        }
        return this.context;
    }

    public ObjectMap getGraphContext() {
        if (this.graphContext == null) {
            this.graphContext = new ObjectMap();
        }
        return this.graphContext;
    }

    public int getDepth() {
        return this.depth;
    }

    public IdentityMap getOriginalToCopyMap() {
        return this.originalToCopy;
    }

    public void setAutoReset(boolean autoReset) {
        this.autoReset = autoReset;
    }

    public void setMaxDepth(int maxDepth) {
        if (maxDepth <= 0) {
            throw new IllegalArgumentException("maxDepth must be > 0.");
        }
        this.maxDepth = maxDepth;
    }

    public boolean isFinal(Class type) {
        if (type == null) {
            throw new IllegalArgumentException("type cannot be null.");
        }
        if (type.isArray()) {
            return Modifier.isFinal(Util.getElementClass(type).getModifiers());
        }
        return Modifier.isFinal(type.getModifiers());
    }

    public boolean isClosure(Class type) {
        if (type == null) {
            throw new IllegalArgumentException("type cannot be null.");
        }
        return type.isSynthetic() && type.getSimpleName().indexOf(47) >= 0;
    }

    public boolean isProxy(Class type) {
        if (type == null) {
            throw new IllegalArgumentException("type cannot be null.");
        }
        return Proxy.isProxyClass(type);
    }

    public Generics getGenerics() {
        return this.generics;
    }

    public void setOptimizedGenerics(boolean optimizedGenerics) {
        this.generics = optimizedGenerics ? new DefaultGenerics(this) : NoGenerics.INSTANCE;
    }

    static final class DefaultSerializerEntry {
        final Class type;
        final SerializerFactory serializerFactory;

        DefaultSerializerEntry(Class type, SerializerFactory serializerFactory) {
            this.type = type;
            this.serializerFactory = serializerFactory;
        }
    }
}

