/*
 * Decompiled with CFR 0.152.
 */
package cofh.lib.gui;

import cofh.lib.audio.SoundBase;
import cofh.lib.gui.TabTracker;
import cofh.lib.gui.element.ElementBase;
import cofh.lib.gui.element.TabBase;
import cofh.lib.gui.slot.SlotFalseCopy;
import cofh.lib.render.RenderHelper;
import cofh.lib.util.helpers.StringHelper;
import cpw.mods.fml.client.FMLClientHandler;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.SoundHandler;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.StatCollector;
import net.minecraftforge.fluids.FluidStack;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL11;

public abstract class GuiBase
extends GuiContainer {
    public static final SoundHandler guiSoundManager = FMLClientHandler.instance().getClient().func_147118_V();
    protected boolean drawTitle = true;
    protected boolean drawInventory = true;
    protected int mouseX = 0;
    protected int mouseY = 0;
    protected int lastIndex = -1;
    protected String name;
    protected ResourceLocation texture;
    public ArrayList<TabBase> tabs = new ArrayList();
    protected ArrayList<ElementBase> elements = new ArrayList();
    protected List<String> tooltip = new LinkedList<String>();
    protected boolean tooltips = true;

    public static void playSound(String string, float f, float f2) {
        guiSoundManager.func_147682_a((ISound)new SoundBase(string, f, f2));
    }

    public GuiBase(Container container) {
        super(container);
    }

    public GuiBase(Container container, ResourceLocation resourceLocation) {
        super(container);
        this.texture = resourceLocation;
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        this.tabs.clear();
        this.elements.clear();
    }

    public void func_73863_a(int n, int n2, float f) {
        this.updateElementInformation();
        super.func_73863_a(n, n2, f);
        if (this.tooltips && ((GuiScreen)this).field_146297_k.field_71439_g.field_71071_by.func_70445_o() == null) {
            this.addTooltips(this.tooltip);
            this.drawTooltip(this.tooltip);
        }
        this.mouseX = n - this.field_147003_i;
        this.mouseY = n2 - this.field_147009_r;
        this.updateElements();
    }

    protected void func_146979_b(int n, int n2) {
        if (this.drawTitle & this.name != null) {
            ((GuiScreen)this).field_146289_q.func_78276_b(StringHelper.localize(this.name), this.getCenteredOffset(StringHelper.localize(this.name)), 6, 0x404040);
        }
        if (this.drawInventory) {
            ((GuiScreen)this).field_146289_q.func_78276_b(StatCollector.func_74838_a((String)"container.inventory"), 8, this.field_147000_g - 96 + 3, 0x404040);
        }
        this.drawElements(0.0f, true);
        this.drawTabs(0.0f, true);
    }

    protected void func_146976_a(float f, int n, int n2) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.bindTexture(this.texture);
        this.func_73729_b(this.field_147003_i, this.field_147009_r, 0, 0, this.field_146999_f, this.field_147000_g);
        this.mouseX = n - this.field_147003_i;
        this.mouseY = n2 - this.field_147009_r;
        GL11.glPushMatrix();
        GL11.glTranslatef((float)this.field_147003_i, (float)this.field_147009_r, (float)0.0f);
        this.drawElements(f, false);
        this.drawTabs(f, false);
        GL11.glPopMatrix();
    }

    protected void func_73869_a(char c, int n) {
        int n2 = this.elements.size();
        while (n2-- > 0) {
            ElementBase elementBase = this.elements.get(n2);
            if (!elementBase.isVisible() || !elementBase.isEnabled() || !elementBase.onKeyTyped(c, n)) continue;
            return;
        }
        super.func_73869_a(c, n);
    }

    public void func_146274_d() {
        int n = Mouse.getEventX() * ((GuiScreen)this).field_146294_l / ((GuiScreen)this).field_146297_k.field_71443_c;
        int n2 = ((GuiScreen)this).field_146295_m - Mouse.getEventY() * ((GuiScreen)this).field_146295_m / ((GuiScreen)this).field_146297_k.field_71440_d - 1;
        this.mouseX = n - this.field_147003_i;
        this.mouseY = n2 - this.field_147009_r;
        int n3 = Mouse.getEventDWheel();
        if (n3 != 0) {
            int n4 = this.elements.size();
            while (n4-- > 0) {
                ElementBase elementBase = this.elements.get(n4);
                if (!elementBase.isVisible() || !elementBase.isEnabled() || !elementBase.intersectsWith(this.mouseX, this.mouseY) || !elementBase.onMouseWheel(this.mouseX, this.mouseY, n3)) continue;
                return;
            }
            TabBase tabBase = this.getTabAtPosition(this.mouseX, this.mouseY);
            if (tabBase != null && tabBase.onMouseWheel(this.mouseX, this.mouseY, n3)) {
                return;
            }
            if (this.onMouseWheel(this.mouseX, this.mouseY, n3)) {
                return;
            }
        }
        super.func_146274_d();
    }

    protected boolean onMouseWheel(int n, int n2, int n3) {
        return false;
    }

    protected void func_73864_a(int n, int n2, int n3) {
        int n4;
        n -= this.field_147003_i;
        n2 -= this.field_147009_r;
        int n5 = this.elements.size();
        while (n5-- > 0) {
            ElementBase elementBase = this.elements.get(n5);
            if (!elementBase.isVisible() || !elementBase.isEnabled() || !elementBase.intersectsWith(n, n2) || !elementBase.onMousePressed(n, n2, n3)) continue;
            return;
        }
        TabBase tabBase = this.getTabAtPosition(n, n2);
        if (tabBase != null && !tabBase.onMousePressed(n4 = n, n2, n3)) {
            int n6 = this.tabs.size();
            while (n6-- > 0) {
                TabBase tabBase2 = this.tabs.get(n6);
                if (tabBase2 == tabBase || !tabBase2.open || tabBase2.side != tabBase.side) continue;
                tabBase2.toggleOpen();
            }
            tabBase.toggleOpen();
            return;
        }
        n += this.field_147003_i;
        n2 += this.field_147009_r;
        if (tabBase != null) {
            switch (tabBase.side) {
                case 0: {
                    break;
                }
                case 1: {
                    this.field_146999_f += tabBase.currentWidth;
                }
            }
        }
        super.func_73864_a(n, n2, n3);
        if (tabBase != null) {
            switch (tabBase.side) {
                case 0: {
                    break;
                }
                case 1: {
                    this.field_146999_f -= tabBase.currentWidth;
                }
            }
        }
    }

    protected void func_146286_b(int n, int n2, int n3) {
        n -= this.field_147003_i;
        n2 -= this.field_147009_r;
        if (n3 >= 0 && n3 <= 2) {
            int n4 = this.elements.size();
            while (n4-- > 0) {
                ElementBase elementBase = this.elements.get(n4);
                if (!elementBase.isVisible() || !elementBase.isEnabled()) continue;
                elementBase.onMouseReleased(n, n2);
            }
        }
        super.func_146286_b(n += this.field_147003_i, n2 += this.field_147009_r, n3);
    }

    protected void func_146273_a(int n, int n2, int n3, long l) {
        Slot slot = this.func_146975_c(n, n2);
        ItemStack itemStack = ((GuiScreen)this).field_146297_k.field_71439_g.field_71071_by.func_70445_o();
        if (this.field_147007_t && slot != null && itemStack != null && slot instanceof SlotFalseCopy) {
            if (this.lastIndex != slot.field_75222_d) {
                this.lastIndex = slot.field_75222_d;
                this.func_146984_a(slot, slot.field_75222_d, 0, 0);
            }
        } else {
            this.lastIndex = -1;
            super.func_146273_a(n, n2, n3, l);
        }
    }

    public Slot func_146975_c(int n, int n2) {
        for (int i = 0; i < this.field_147002_h.field_75151_b.size(); ++i) {
            Slot slot = (Slot)this.field_147002_h.field_75151_b.get(i);
            if (!this.func_146981_a(slot, n, n2)) continue;
            return slot;
        }
        return null;
    }

    public boolean func_146981_a(Slot slot, int n, int n2) {
        return this.func_146978_c(slot.field_75223_e, slot.field_75221_f, 16, 16, n, n2);
    }

    protected void drawElements(float f, boolean bl) {
        if (bl) {
            for (int i = 0; i < this.elements.size(); ++i) {
                ElementBase elementBase = this.elements.get(i);
                if (!elementBase.isVisible()) continue;
                elementBase.drawForeground(this.mouseX, this.mouseY);
            }
        } else {
            for (int i = 0; i < this.elements.size(); ++i) {
                ElementBase elementBase = this.elements.get(i);
                if (!elementBase.isVisible()) continue;
                elementBase.drawBackground(this.mouseX, this.mouseY, f);
            }
        }
    }

    protected void drawTabs(float f, boolean bl) {
        int n = 4;
        int n2 = 4;
        if (bl) {
            for (int i = 0; i < this.tabs.size(); ++i) {
                TabBase tabBase = this.tabs.get(i);
                tabBase.update();
                if (!tabBase.isVisible()) continue;
                if (tabBase.side == 0) {
                    tabBase.drawForeground(this.mouseX, this.mouseY);
                    n2 += tabBase.currentHeight;
                    continue;
                }
                tabBase.drawForeground(this.mouseX, this.mouseY);
                n += tabBase.currentHeight;
            }
        } else {
            for (int i = 0; i < this.tabs.size(); ++i) {
                TabBase tabBase = this.tabs.get(i);
                tabBase.update();
                if (!tabBase.isVisible()) continue;
                if (tabBase.side == 0) {
                    tabBase.setPosition(0, n2);
                    tabBase.drawBackground(this.mouseX, this.mouseY, f);
                    n2 += tabBase.currentHeight;
                    continue;
                }
                tabBase.setPosition(this.field_146999_f, n);
                tabBase.drawBackground(this.mouseX, this.mouseY, f);
                n += tabBase.currentHeight;
            }
        }
    }

    public List<String> handleTooltip(int n, int n2, List<String> list) {
        if (((GuiScreen)this).field_146297_k.field_71439_g.field_71071_by.func_70445_o() == null) {
            this.addTooltips(list);
        }
        return list;
    }

    public void addTooltips(List<String> list) {
        ElementBase elementBase;
        TabBase tabBase = this.getTabAtPosition(this.mouseX, this.mouseY);
        if (tabBase != null) {
            tabBase.addTooltip(list);
        }
        if ((elementBase = this.getElementAtPosition(this.mouseX, this.mouseY)) != null && elementBase.isVisible()) {
            elementBase.addTooltip(list);
        }
    }

    public ElementBase addElement(ElementBase elementBase) {
        this.elements.add(elementBase);
        return elementBase;
    }

    public TabBase addTab(TabBase tabBase) {
        int n = 4;
        for (int i = 0; i < this.tabs.size(); ++i) {
            if (this.tabs.get((int)i).side != tabBase.side || !this.tabs.get(i).isVisible()) continue;
            n += this.tabs.get((int)i).currentHeight;
        }
        tabBase.setPosition(tabBase.side == 0 ? 0 : this.field_146999_f, n);
        this.tabs.add(tabBase);
        if (TabTracker.getOpenedLeftTab() != null && tabBase.getClass().equals(TabTracker.getOpenedLeftTab())) {
            tabBase.setFullyOpen();
        } else if (TabTracker.getOpenedRightTab() != null && tabBase.getClass().equals(TabTracker.getOpenedRightTab())) {
            tabBase.setFullyOpen();
        }
        return tabBase;
    }

    protected ElementBase getElementAtPosition(int n, int n2) {
        int n3 = this.elements.size();
        while (n3-- > 0) {
            ElementBase elementBase = this.elements.get(n3);
            if (!elementBase.intersectsWith(n, n2)) continue;
            return elementBase;
        }
        return null;
    }

    protected TabBase getTabAtPosition(int n, int n2) {
        TabBase tabBase;
        int n3;
        int n4 = 0;
        int n5 = 4;
        for (n3 = 0; n3 < this.tabs.size(); ++n3) {
            tabBase = this.tabs.get(n3);
            if (!tabBase.isVisible() || tabBase.side == 1) continue;
            tabBase.setCurrentShift(n4, n5);
            if (tabBase.intersectsWith(n, n2, n4, n5)) {
                return tabBase;
            }
            n5 += tabBase.currentHeight;
        }
        n4 = this.field_146999_f;
        n5 = 4;
        for (n3 = 0; n3 < this.tabs.size(); ++n3) {
            tabBase = this.tabs.get(n3);
            if (!tabBase.isVisible() || tabBase.side == 0) continue;
            tabBase.setCurrentShift(n4, n5);
            if (tabBase.intersectsWith(n, n2, n4, n5)) {
                return tabBase;
            }
            n5 += tabBase.currentHeight;
        }
        return null;
    }

    protected final void updateElements() {
        int n = this.elements.size();
        while (n-- > 0) {
            ElementBase elementBase = this.elements.get(n);
            if (!elementBase.isVisible() || !elementBase.isEnabled()) continue;
            elementBase.update(this.mouseX, this.mouseY);
        }
    }

    protected void updateElementInformation() {
    }

    public void handleElementButtonClick(String string, int n) {
    }

    public void bindTexture(ResourceLocation resourceLocation) {
        ((GuiScreen)this).field_146297_k.field_71446_o.func_110577_a(resourceLocation);
    }

    public IIcon getIcon(String string) {
        return null;
    }

    public void drawButton(IIcon iIcon, int n, int n2, int n3, int n4) {
        this.drawIcon(iIcon, n, n2, n3);
    }

    public void drawButton(String string, int n, int n2, int n3, int n4) {
        this.drawButton(this.getIcon(string), n, n2, n3, n4);
    }

    public void drawItemStack(ItemStack itemStack, int n, int n2, boolean bl, String string) {
        GL11.glEnable((int)2929);
        GL11.glEnable((int)2896);
        GL11.glPushMatrix();
        GL11.glTranslatef((float)0.0f, (float)0.0f, (float)32.0f);
        ((Gui)this).field_73735_i = 200.0f;
        GuiScreen.field_146296_j.field_77023_b = 200.0f;
        FontRenderer fontRenderer = null;
        if (itemStack != null) {
            fontRenderer = itemStack.func_77973_b().getFontRenderer(itemStack);
        }
        if (fontRenderer == null) {
            fontRenderer = ((GuiScreen)this).field_146289_q;
        }
        GuiScreen.field_146296_j.func_82406_b(fontRenderer, ((GuiScreen)this).field_146297_k.func_110434_K(), itemStack, n, n2);
        if (bl) {
            GuiScreen.field_146296_j.func_94148_a(fontRenderer, ((GuiScreen)this).field_146297_k.func_110434_K(), itemStack, n, n2 - (this.field_147012_x == null ? 0 : 8), string);
        }
        ((Gui)this).field_73735_i = 0.0f;
        GuiScreen.field_146296_j.field_77023_b = 0.0f;
        GL11.glPopMatrix();
        GL11.glDisable((int)2896);
    }

    public void drawFluid(int n, int n2, FluidStack fluidStack, int n3, int n4) {
        if (fluidStack == null || fluidStack.getFluid() == null) {
            return;
        }
        RenderHelper.setBlockTextureSheet();
        RenderHelper.setColor3ub(fluidStack.getFluid().getColor(fluidStack));
        this.drawTiledTexture(n, n2, fluidStack.getFluid().getIcon(fluidStack), n3, n4);
    }

    public void drawTiledTexture(int n, int n2, IIcon iIcon, int n3, int n4) {
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        int n8 = 0;
        for (n5 = 0; n5 < n3; n5 += 16) {
            for (n6 = 0; n6 < n4; n6 += 16) {
                n8 = Math.min(n3 - n5, 16);
                n7 = Math.min(n4 - n6, 16);
                this.drawScaledTexturedModelRectFromIcon(n + n5, n2 + n6, iIcon, n8, n7);
            }
        }
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    public void drawIcon(IIcon iIcon, int n, int n2, int n3) {
        if (n3 == 0) {
            RenderHelper.setBlockTextureSheet();
        } else {
            RenderHelper.setItemTextureSheet();
        }
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.func_94065_a(n, n2, iIcon, 16, 16);
    }

    public void drawColorIcon(IIcon iIcon, int n, int n2, int n3) {
        if (n3 == 0) {
            RenderHelper.setBlockTextureSheet();
        } else {
            RenderHelper.setItemTextureSheet();
        }
        this.func_94065_a(n, n2, iIcon, 16, 16);
    }

    public void drawIcon(String string, int n, int n2, int n3) {
        this.drawIcon(this.getIcon(string), n, n2, n3);
    }

    public void drawSizedModalRect(int n, int n2, int n3, int n4, int n5) {
        int n6;
        if (n < n3) {
            n6 = n;
            n = n3;
            n3 = n6;
        }
        if (n2 < n4) {
            n6 = n2;
            n2 = n4;
            n4 = n6;
        }
        float f = (float)(n5 >> 24 & 0xFF) / 255.0f;
        float f2 = (float)(n5 >> 16 & 0xFF) / 255.0f;
        float f3 = (float)(n5 >> 8 & 0xFF) / 255.0f;
        float f4 = (float)(n5 & 0xFF) / 255.0f;
        Tessellator tessellator = Tessellator.field_78398_a;
        GL11.glEnable((int)3042);
        GL11.glDisable((int)3553);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glColor4f((float)f2, (float)f3, (float)f4, (float)f);
        tessellator.func_78382_b();
        tessellator.func_78377_a((double)n, (double)n4, (double)((Gui)this).field_73735_i);
        tessellator.func_78377_a((double)n3, (double)n4, (double)((Gui)this).field_73735_i);
        tessellator.func_78377_a((double)n3, (double)n2, (double)((Gui)this).field_73735_i);
        tessellator.func_78377_a((double)n, (double)n2, (double)((Gui)this).field_73735_i);
        tessellator.func_78381_a();
        GL11.glEnable((int)3553);
        GL11.glDisable((int)3042);
    }

    public void drawSizedRect(int n, int n2, int n3, int n4, int n5) {
        int n6;
        if (n < n3) {
            n6 = n;
            n = n3;
            n3 = n6;
        }
        if (n2 < n4) {
            n6 = n2;
            n2 = n4;
            n4 = n6;
        }
        float f = (float)(n5 >> 24 & 0xFF) / 255.0f;
        float f2 = (float)(n5 >> 16 & 0xFF) / 255.0f;
        float f3 = (float)(n5 >> 8 & 0xFF) / 255.0f;
        float f4 = (float)(n5 & 0xFF) / 255.0f;
        Tessellator tessellator = Tessellator.field_78398_a;
        GL11.glDisable((int)3553);
        GL11.glColor4f((float)f2, (float)f3, (float)f4, (float)f);
        tessellator.func_78382_b();
        tessellator.func_78377_a((double)n, (double)n4, (double)((Gui)this).field_73735_i);
        tessellator.func_78377_a((double)n3, (double)n4, (double)((Gui)this).field_73735_i);
        tessellator.func_78377_a((double)n3, (double)n2, (double)((Gui)this).field_73735_i);
        tessellator.func_78377_a((double)n, (double)n2, (double)((Gui)this).field_73735_i);
        tessellator.func_78381_a();
        GL11.glEnable((int)3553);
    }

    public void drawSizedTexturedModalRect(int n, int n2, int n3, int n4, int n5, int n6, float f, float f2) {
        float f3 = 1.0f / f;
        float f4 = 1.0f / f2;
        Tessellator tessellator = Tessellator.field_78398_a;
        tessellator.func_78382_b();
        tessellator.func_78374_a((double)(n + 0), (double)(n2 + n6), (double)((Gui)this).field_73735_i, (double)((float)(n3 + 0) * f3), (double)((float)(n4 + n6) * f4));
        tessellator.func_78374_a((double)(n + n5), (double)(n2 + n6), (double)((Gui)this).field_73735_i, (double)((float)(n3 + n5) * f3), (double)((float)(n4 + n6) * f4));
        tessellator.func_78374_a((double)(n + n5), (double)(n2 + 0), (double)((Gui)this).field_73735_i, (double)((float)(n3 + n5) * f3), (double)((float)(n4 + 0) * f4));
        tessellator.func_78374_a((double)(n + 0), (double)(n2 + 0), (double)((Gui)this).field_73735_i, (double)((float)(n3 + 0) * f3), (double)((float)(n4 + 0) * f4));
        tessellator.func_78381_a();
    }

    public void drawScaledTexturedModelRectFromIcon(int n, int n2, IIcon iIcon, int n3, int n4) {
        if (iIcon == null) {
            return;
        }
        double d = iIcon.func_94209_e();
        double d2 = iIcon.func_94212_f();
        double d3 = iIcon.func_94206_g();
        double d4 = iIcon.func_94210_h();
        Tessellator tessellator = Tessellator.field_78398_a;
        tessellator.func_78382_b();
        tessellator.func_78374_a((double)(n + 0), (double)(n2 + n4), (double)((Gui)this).field_73735_i, d, d3 + (d4 - d3) * (double)n4 / 16.0);
        tessellator.func_78374_a((double)(n + n3), (double)(n2 + n4), (double)((Gui)this).field_73735_i, d + (d2 - d) * (double)n3 / 16.0, d3 + (d4 - d3) * (double)n4 / 16.0);
        tessellator.func_78374_a((double)(n + n3), (double)(n2 + 0), (double)((Gui)this).field_73735_i, d + (d2 - d) * (double)n3 / 16.0, d3);
        tessellator.func_78374_a((double)(n + 0), (double)(n2 + 0), (double)((Gui)this).field_73735_i, d, d3);
        tessellator.func_78381_a();
    }

    public void drawTooltip(List<String> list) {
        this.drawTooltipHoveringText(list, this.mouseX + this.field_147003_i, this.mouseY + this.field_147009_r, ((GuiScreen)this).field_146289_q);
        this.tooltip.clear();
    }

    protected void drawTooltipHoveringText(List list, int n, int n2, FontRenderer fontRenderer) {
        int n3;
        if (list == null || list.isEmpty()) {
            return;
        }
        GL11.glDisable((int)32826);
        GL11.glDisable((int)2896);
        GL11.glDisable((int)2929);
        int n4 = 0;
        for (String string : list) {
            n3 = fontRenderer.func_78256_a(string);
            if (n3 <= n4) continue;
            n4 = n3;
        }
        int n5 = n + 12;
        n3 = n2 - 12;
        int n6 = 8;
        if (list.size() > 1) {
            n6 += 2 + (list.size() - 1) * 10;
        }
        if (n5 + n4 > ((GuiScreen)this).field_146294_l) {
            n5 -= 28 + n4;
        }
        if (n3 + n6 + 6 > ((GuiScreen)this).field_146295_m) {
            n3 = ((GuiScreen)this).field_146295_m - n6 - 6;
        }
        ((Gui)this).field_73735_i = 300.0f;
        GuiScreen.field_146296_j.field_77023_b = 300.0f;
        int n7 = -267386864;
        this.func_73733_a(n5 - 3, n3 - 4, n5 + n4 + 3, n3 - 3, n7, n7);
        this.func_73733_a(n5 - 3, n3 + n6 + 3, n5 + n4 + 3, n3 + n6 + 4, n7, n7);
        this.func_73733_a(n5 - 3, n3 - 3, n5 + n4 + 3, n3 + n6 + 3, n7, n7);
        this.func_73733_a(n5 - 4, n3 - 3, n5 - 3, n3 + n6 + 3, n7, n7);
        this.func_73733_a(n5 + n4 + 3, n3 - 3, n5 + n4 + 4, n3 + n6 + 3, n7, n7);
        int n8 = 0x505000FF;
        int n9 = (n8 & 0xFEFEFE) >> 1 | n8 & 0xFF000000;
        this.func_73733_a(n5 - 3, n3 - 3 + 1, n5 - 3 + 1, n3 + n6 + 3 - 1, n8, n9);
        this.func_73733_a(n5 + n4 + 2, n3 - 3 + 1, n5 + n4 + 3, n3 + n6 + 3 - 1, n8, n9);
        this.func_73733_a(n5 - 3, n3 - 3, n5 + n4 + 3, n3 - 3 + 1, n8, n8);
        this.func_73733_a(n5 - 3, n3 + n6 + 2, n5 + n4 + 3, n3 + n6 + 3, n9, n9);
        for (int i = 0; i < list.size(); ++i) {
            String string = (String)list.get(i);
            fontRenderer.func_78261_a(string, n5, n3, -1);
            if (i == 0) {
                n3 += 2;
            }
            n3 += 10;
        }
        ((Gui)this).field_73735_i = 0.0f;
        GuiScreen.field_146296_j.field_77023_b = 0.0f;
        GL11.glEnable((int)2896);
        GL11.glEnable((int)2929);
        GL11.glEnable((int)32826);
    }

    public void mouseClicked(int n) {
        super.func_73864_a(this.field_147003_i + this.mouseX, this.field_147009_r + this.mouseY, n);
    }

    public FontRenderer getFontRenderer() {
        return ((GuiScreen)this).field_146289_q;
    }

    protected int getCenteredOffset(String string) {
        return this.getCenteredOffset(string, this.field_146999_f);
    }

    protected int getCenteredOffset(String string, int n) {
        return (n - ((GuiScreen)this).field_146289_q.func_78256_a(string)) / 2;
    }

    public int getGuiLeft() {
        return this.field_147003_i;
    }

    public int getGuiTop() {
        return this.field_147009_r;
    }

    public int getMouseX() {
        return this.mouseX;
    }

    public int getMouseY() {
        return this.mouseY;
    }

    public void overlayRecipe() {
    }
}

