/*
 * Decompiled with CFR 0.152.
 */
package WayofTime.alchemicalWizardry.common.omega;

import WayofTime.alchemicalWizardry.ModItems;
import WayofTime.alchemicalWizardry.api.alchemy.energy.Reagent;
import WayofTime.alchemicalWizardry.common.items.armour.OmegaArmour;
import WayofTime.alchemicalWizardry.common.omega.ReagentRegenConfiguration;
import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;

public class OmegaParadigm {
    public OmegaArmour helmet;
    public OmegaArmour chestPiece;
    public OmegaArmour leggings;
    public OmegaArmour boots;
    public ReagentRegenConfiguration config;

    public OmegaParadigm(Reagent reagent, OmegaArmour helmet, OmegaArmour chestPiece, OmegaArmour leggings, OmegaArmour boots, ReagentRegenConfiguration config) {
        this.helmet = helmet;
        this.chestPiece = chestPiece;
        this.leggings = leggings;
        this.boots = boots;
        this.helmet.setParadigm(this);
        this.chestPiece.setParadigm(this);
        this.leggings.setParadigm(this);
        this.boots.setParadigm(this);
        this.helmet.setReagent(reagent);
        this.chestPiece.setReagent(reagent);
        this.leggings.setReagent(reagent);
        this.boots.setReagent(reagent);
        this.config = new ReagentRegenConfiguration(100, 1, 10.0f);
    }

    public boolean convertPlayerArmour(EntityPlayer player, int x, int y, int z, int stability, int affinity, int enchantability, int enchantmentLevel) {
        ItemStack[] armours = player.field_71071_by.field_70460_b;
        ItemStack helmetStack = armours[3];
        ItemStack chestStack = armours[2];
        ItemStack leggingsStack = armours[1];
        ItemStack bootsStack = armours[0];
        if (helmetStack != null && helmetStack.func_77973_b() == ModItems.boundHelmet && chestStack != null && chestStack.func_77973_b() == ModItems.boundPlate && leggingsStack != null && leggingsStack.func_77973_b() == ModItems.boundLeggings && bootsStack != null && bootsStack.func_77973_b() == ModItems.boundBoots) {
            long worldSeed = player.field_70170_p.func_72905_C();
            Random rand = new Random(worldSeed + (long)(stability * (affinity + 7) * 94) + (long)(84321 * x) - (long)(17423 * y) + (long)(76 * z) - (long)(1623451 * enchantability) + (long)(2 * enchantmentLevel));
            ItemStack omegaHelmetStack = this.helmet.getSubstituteStack(helmetStack, stability, affinity, enchantability, enchantmentLevel, rand);
            ItemStack omegaChestStack = this.chestPiece.getSubstituteStack(chestStack, stability, affinity, enchantability, enchantmentLevel, rand);
            ItemStack omegaLeggingsStack = this.leggings.getSubstituteStack(leggingsStack, stability, affinity, enchantability, enchantmentLevel, rand);
            ItemStack omegaBootsStack = this.boots.getSubstituteStack(bootsStack, stability, affinity, enchantability, enchantmentLevel, rand);
            armours[3] = omegaHelmetStack;
            armours[2] = omegaChestStack;
            armours[1] = omegaLeggingsStack;
            armours[0] = omegaBootsStack;
            return true;
        }
        return false;
    }

    public ReagentRegenConfiguration getRegenConfig(EntityPlayer player) {
        return this.config;
    }

    public int getMaxAdditionalHealth() {
        return 20;
    }

    public boolean setOmegaStalling(EntityPlayer player, int duration) {
        ItemStack[] armours = player.field_71071_by.field_70460_b;
        ItemStack chestStack = armours[2];
        if (chestStack != null && chestStack.func_77973_b() == this.chestPiece) {
            ((OmegaArmour)chestStack.func_77973_b()).setOmegaStallingDuration(chestStack, duration);
            return true;
        }
        return false;
    }

    public float getCostPerTickOfUse(EntityPlayer player) {
        return 1.0f;
    }

    public boolean doDrainReagent(EntityPlayer player) {
        ItemStack[] armours = player.field_71071_by.field_70460_b;
        ItemStack chestStack = armours[2];
        if (chestStack != null && chestStack.func_77973_b() == this.chestPiece) {
            return !((OmegaArmour)chestStack.func_77973_b()).hasOmegaStalling(chestStack);
        }
        return true;
    }

    public boolean isPlayerWearingFullSet(EntityPlayer player) {
        ItemStack[] armours = player.field_71071_by.field_70460_b;
        ItemStack helmetStack = armours[3];
        ItemStack chestStack = armours[2];
        ItemStack leggingsStack = armours[1];
        ItemStack bootsStack = armours[0];
        return helmetStack != null && helmetStack.func_77973_b() == this.helmet && chestStack != null && chestStack.func_77973_b() == this.chestPiece && leggingsStack != null && leggingsStack.func_77973_b() == this.leggings && bootsStack != null && bootsStack.func_77973_b() == this.boots;
    }

    public void onUpdate(World world, EntityPlayer player, ItemStack stack) {
    }

    public void onOmegaKeyPressed(EntityPlayer player, ItemStack stack) {
    }

    public boolean getBlockEffectWhileInside(Entity entity, int x, int y, int z) {
        return false;
    }

    public boolean onHPBarDepleted(EntityPlayer player, ItemStack stack) {
        return false;
    }

    public boolean onBoundSwordLeftClickEntity(ItemStack stack, EntityPlayer player, Entity entity) {
        return true;
    }

    public void onEmptyHandEntityInteract(EntityPlayer player, Entity entity) {
    }

    public void onBoundSwordInteractWithEntity(EntityPlayer player, Entity entity) {
    }
}

