/*
 * Decompiled with CFR 0.152.
 */
package WayofTime.alchemicalWizardry.common.items;

import WayofTime.alchemicalWizardry.AlchemicalWizardry;
import WayofTime.alchemicalWizardry.ModItems;
import WayofTime.alchemicalWizardry.api.items.ShapelessBloodOrbRecipe;
import WayofTime.alchemicalWizardry.api.sacrifice.IIncense;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.IIcon;
import net.minecraft.util.MathHelper;
import net.minecraft.util.StatCollector;

public class ItemIncense
extends Item
implements IIncense {
    private static final String[] ITEM_NAMES = new String[]{"Woodash", "Byrrus", "Livens", "Viridis", "Purpura"};
    @SideOnly(value=Side.CLIENT)
    private IIcon[] icons;

    public ItemIncense() {
        this.field_77777_bU = 64;
        this.func_77637_a(AlchemicalWizardry.tabBloodMagic);
        this.field_77787_bX = true;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister iconRegister) {
        this.icons = new IIcon[ITEM_NAMES.length];
        IIcon baseIcon = iconRegister.func_94245_a("AlchemicalWizardry:baseIncenseItem");
        for (int i = 0; i < ITEM_NAMES.length; ++i) {
            this.icons[i] = this.doesIncenseHaveUniqueTexture(i) ? iconRegister.func_94245_a("AlchemicalWizardry:baseIncenseItem" + ITEM_NAMES[i]) : baseIcon;
        }
    }

    public void func_77624_a(ItemStack stack, EntityPlayer player, List list, boolean par4) {
        list.add(StatCollector.func_74838_a((String)"tooltip.alchemy.usedinincense"));
    }

    public String func_77667_c(ItemStack itemStack) {
        int meta = MathHelper.func_76125_a((int)itemStack.func_77960_j(), (int)0, (int)(ITEM_NAMES.length - 1));
        return "item.bloodMagicIncenseItem." + ITEM_NAMES[meta];
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_77617_a(int meta) {
        int j = MathHelper.func_76125_a((int)meta, (int)0, (int)(ITEM_NAMES.length - 1));
        return this.icons[j];
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(Item id, CreativeTabs creativeTab, List list) {
        for (int meta = 0; meta < ITEM_NAMES.length; ++meta) {
            list.add(new ItemStack(id, 1, meta));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public int func_82790_a(ItemStack stack, int pass) {
        if (!this.doesIncenseHaveUniqueTexture(stack.func_77960_j())) {
            EnumIncense inc = EnumIncense.getEnumForIndex(stack.func_77960_j());
            return (int)(255.0f * inc.redColour * 256.0f * 256.0f + 255.0f * inc.greenColour * 256.0f + 255.0f * inc.blueColour);
        }
        return 0xFFFFFF;
    }

    @Override
    public int getMinLevel(ItemStack stack) {
        return EnumIncense.getEnumForIndex((int)stack.func_77960_j()).minValue;
    }

    @Override
    public int getMaxLevel(ItemStack stack) {
        return EnumIncense.getEnumForIndex((int)stack.func_77960_j()).maxValue;
    }

    @Override
    public int getIncenseDuration(ItemStack stack) {
        return EnumIncense.getEnumForIndex((int)stack.func_77960_j()).incenseDuration;
    }

    @Override
    public float getTickRate(ItemStack stack) {
        return EnumIncense.getEnumForIndex((int)stack.func_77960_j()).tickRate;
    }

    @Override
    public float getRedColour(ItemStack stack) {
        return EnumIncense.getEnumForIndex((int)stack.func_77960_j()).redColour;
    }

    @Override
    public float getGreenColour(ItemStack stack) {
        return EnumIncense.getEnumForIndex((int)stack.func_77960_j()).greenColour;
    }

    @Override
    public float getBlueColour(ItemStack stack) {
        return EnumIncense.getEnumForIndex((int)stack.func_77960_j()).blueColour;
    }

    public boolean doesIncenseHaveUniqueTexture(int meta) {
        return false;
    }

    public static void registerIncenseRecipes() {
        int WILDCARD = Short.MAX_VALUE;
        ItemStack woodStack = new ItemStack(Blocks.field_150364_r, 1, WILDCARD);
        ItemStack charcoalStack = new ItemStack(Items.field_151044_h, 1, 1);
        ItemStack leavesStack = new ItemStack((Block)Blocks.field_150362_t, 1, WILDCARD);
        ItemStack goldNuggetStack = new ItemStack(Items.field_151074_bl, 1, WILDCARD);
        ItemStack stringStack = new ItemStack(Items.field_151007_F, 1, WILDCARD);
        ItemStack glowstoneStack = new ItemStack(Items.field_151114_aO, 1, WILDCARD);
        ItemStack soulSandStack = new ItemStack(Blocks.field_150425_aM);
        ItemStack gunpowderStack = new ItemStack(Items.field_151016_H);
        ItemStack fermentedEyeStack = new ItemStack(Items.field_151071_bq);
        ItemStack quartzStack = new ItemStack(Items.field_151128_bU, 1, WILDCARD);
        ItemStack blazePowderStack = new ItemStack(Items.field_151065_br);
        ItemStack netherwartStack = new ItemStack(Items.field_151075_bm);
        ItemStack fracturedBoneStack = new ItemStack(ModItems.baseAlchemyItems, 1, 5);
        ItemStack woodashStack = new ItemStack(ModItems.itemIncense, 1, 0);
        GameRegistry.addRecipe((ItemStack)woodashStack, (Object[])new Object[]{"WWW", "WCW", "WWW", Character.valueOf('W'), woodStack, Character.valueOf('C'), charcoalStack});
        GameRegistry.addRecipe((IRecipe)new ShapelessBloodOrbRecipe(new ItemStack(ModItems.itemIncense, 1, 1), woodashStack, "dyeRed", "dyeRed", new ItemStack(Items.field_151137_ax), leavesStack, leavesStack, new ItemStack(ModItems.apprenticeBloodOrb)));
        GameRegistry.addRecipe((IRecipe)new ShapelessBloodOrbRecipe(new ItemStack(ModItems.itemIncense, 1, 2), woodashStack, "dyeBlue", "dyeBlue", goldNuggetStack, goldNuggetStack, glowstoneStack, stringStack, stringStack, new ItemStack(ModItems.magicianBloodOrb)));
        GameRegistry.addRecipe((IRecipe)new ShapelessBloodOrbRecipe(new ItemStack(ModItems.itemIncense, 1, 3), woodashStack, "dyeGreen", "dyeGreen", soulSandStack, gunpowderStack, fermentedEyeStack, new ItemStack(ModItems.masterBloodOrb)));
        GameRegistry.addRecipe((IRecipe)new ShapelessBloodOrbRecipe(new ItemStack(ModItems.itemIncense, 1, 4), woodashStack, "dyePurple", "dyePurple", quartzStack, netherwartStack, blazePowderStack, fracturedBoneStack, goldNuggetStack, new ItemStack(ModItems.archmageBloodOrb)));
    }

    public static enum EnumIncense {
        WOODASH(0, 200, 1.0f, 1000, 0.937f, 0.898f, 0.82f),
        RED(200, 600, 1.5f, 1000, 1.0f, 0.0f, 0.0f),
        BLUE(600, 1200, 3.0f, 1000, 0.0f, 0.0f, 1.0f),
        GREEN(1200, 2000, 4.0f, 1000, 0.0f, 1.0f, 0.0f),
        PURPLE(2000, 3000, 5.0f, 1000, 1.0f, 0.0f, 1.0f);

        public final int minValue;
        public final int maxValue;
        public final float tickRate;
        public final int incenseDuration;
        public final float redColour;
        public final float greenColour;
        public final float blueColour;

        private EnumIncense(int minValue, int maxValue, float tickRate, int dur, float red, float green, float blue) {
            this.minValue = minValue;
            this.maxValue = maxValue;
            this.tickRate = tickRate;
            this.incenseDuration = dur;
            this.redColour = red;
            this.greenColour = green;
            this.blueColour = blue;
        }

        public static EnumIncense getEnumForIndex(int index) {
            if (index > EnumIncense.values().length || index < 0) {
                return WOODASH;
            }
            return EnumIncense.values()[index];
        }
    }
}

