/*
 * Decompiled with CFR 0.152.
 */
package WayofTime.alchemicalWizardry.client.nei;

import WayofTime.alchemicalWizardry.api.alchemy.AlchemyRecipe;
import WayofTime.alchemicalWizardry.api.alchemy.AlchemyRecipeRegistry;
import WayofTime.alchemicalWizardry.api.items.interfaces.IBloodOrb;
import WayofTime.alchemicalWizardry.client.nei.NEIConfig;
import WayofTime.alchemicalWizardry.common.tileEntity.gui.GuiWritingTable;
import codechicken.nei.NEIServerUtils;
import codechicken.nei.PositionedStack;
import codechicken.nei.recipe.TemplateRecipeHandler;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.StatCollector;

public class NEIAlchemyRecipeHandler
extends TemplateRecipeHandler {
    public String getOverlayIdentifier() {
        return "alchemicalwizardry.alchemy";
    }

    public void loadTransferRects() {
        this.transferRects.add(new TemplateRecipeHandler.RecipeTransferRect(new Rectangle(134, 22, 16, 24), "alchemicalwizardry.alchemy", new Object[0]));
    }

    public Class<? extends GuiContainer> getGuiClass() {
        return GuiWritingTable.class;
    }

    public void loadCraftingRecipes(String outputId, Object ... results) {
        if (outputId.equals("alchemicalwizardry.alchemy") && ((Object)((Object)this)).getClass() == NEIAlchemyRecipeHandler.class) {
            for (AlchemyRecipe recipe : AlchemyRecipeRegistry.recipes) {
                if (recipe.getResult() == null) continue;
                this.arecipes.add(new CachedAlchemyRecipe(recipe));
            }
        } else {
            super.loadCraftingRecipes(outputId, results);
        }
    }

    public void loadCraftingRecipes(ItemStack result) {
        for (AlchemyRecipe recipe : AlchemyRecipeRegistry.recipes) {
            if (recipe == null || !NEIServerUtils.areStacksSameTypeCraftingWithNBT((ItemStack)result, (ItemStack)recipe.getResult())) continue;
            this.arecipes.add(new CachedAlchemyRecipe(recipe));
        }
    }

    public void loadUsageRecipes(ItemStack ingredient) {
        if (ingredient.func_77973_b() instanceof IBloodOrb) {
            for (AlchemyRecipe recipe : AlchemyRecipeRegistry.recipes) {
                if (recipe == null || ((IBloodOrb)ingredient.func_77973_b()).getOrbLevel() < recipe.getOrbLevel()) continue;
                this.arecipes.add(new CachedAlchemyRecipe(recipe, ingredient));
            }
        } else {
            block1: for (AlchemyRecipe recipe : AlchemyRecipeRegistry.recipes) {
                ItemStack[] stacks;
                if (recipe == null) continue;
                for (ItemStack stack : stacks = recipe.getRecipe()) {
                    if (!NEIServerUtils.areStacksSameTypeCraftingWithNBT((ItemStack)stack, (ItemStack)ingredient)) continue;
                    this.arecipes.add(new CachedAlchemyRecipe(recipe));
                    continue block1;
                }
            }
        }
    }

    public void drawExtras(int id) {
        CachedAlchemyRecipe cache = (CachedAlchemyRecipe)((Object)this.arecipes.get(id));
        Minecraft.func_71410_x().field_71466_p.func_78276_b("\u00a77" + cache.lp + "LP", this.getLPX(cache.lp), 34, 0);
    }

    public int getLPX(int lp) {
        if (lp < 10) {
            return 122;
        }
        if (lp < 100) {
            return 122;
        }
        if (lp < 1000) {
            return 130;
        }
        if (lp < 10000) {
            return 127;
        }
        if (lp < 100000) {
            return 124;
        }
        return 122;
    }

    public String getRecipeName() {
        return StatCollector.func_74838_a((String)"tile.blockWritingTable.name");
    }

    public String getGuiTexture() {
        return new ResourceLocation("alchemicalwizardry", "gui/nei/alchemy.png").toString();
    }

    public class CachedAlchemyRecipe
    extends TemplateRecipeHandler.CachedRecipe {
        ArrayList<BloodOrbs> orbs;
        PositionedStack output;
        List<PositionedStack> inputs;
        int lp;

        public CachedAlchemyRecipe(AlchemyRecipe recipe, ItemStack orb) {
            this(recipe);
            this.orbs = new ArrayList();
            this.orbs.add(new BloodOrbs(orb));
        }

        public CachedAlchemyRecipe(AlchemyRecipe recipe) {
            super((TemplateRecipeHandler)NEIAlchemyRecipeHandler.this);
            ArrayList<PositionedStack> inputs = new ArrayList<PositionedStack>();
            ItemStack[] stacks = recipe.getRecipe();
            if (stacks.length > 0) {
                inputs.add(new PositionedStack((Object)stacks[0], 76, 3));
            }
            if (stacks.length > 1) {
                inputs.add(new PositionedStack((Object)stacks[1], 51, 19));
            }
            if (stacks.length > 2) {
                inputs.add(new PositionedStack((Object)stacks[2], 101, 19));
            }
            if (stacks.length > 3) {
                inputs.add(new PositionedStack((Object)stacks[3], 64, 47));
            }
            if (stacks.length > 4) {
                inputs.add(new PositionedStack((Object)stacks[4], 88, 47));
            }
            this.inputs = inputs;
            this.output = new PositionedStack((Object)recipe.getResult(), 76, 25);
            this.lp = recipe.getAmountNeeded() * 100;
            this.orbs = new ArrayList();
            for (Item orb : NEIConfig.getBloodOrbs()) {
                if (((IBloodOrb)orb).getOrbLevel() < recipe.getOrbLevel()) continue;
                this.orbs.add(new BloodOrbs(new ItemStack(orb)));
            }
        }

        public List<PositionedStack> getIngredients() {
            return this.inputs;
        }

        public PositionedStack getResult() {
            return this.output;
        }

        public PositionedStack getOtherStack() {
            if (this.orbs == null || this.orbs.size() <= 0) {
                return null;
            }
            return this.orbs.get((int)(NEIAlchemyRecipeHandler.this.cycleticks / 48 % this.orbs.size())).stack;
        }

        public class BloodOrbs {
            public PositionedStack stack;

            public BloodOrbs(ItemStack orb) {
                this.stack = new PositionedStack((Object)orb, 136, 47, false);
            }
        }
    }
}

