/*
 * Decompiled with CFR 0.152.
 */
package jds.bibliocraft;

import java.util.ArrayList;
import java.util.Collections;
import jds.bibliocraft.helpers.InventoryListItem;
import jds.bibliocraft.helpers.InventorySet;
import jds.bibliocraft.helpers.SortedListItem;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;

public class BiblioSortingHelper {
    public static ArrayList<ItemStack> getStackForBuiltinLabel(TileEntity tile) {
        IInventory inv = (IInventory)tile;
        ArrayList<ItemStack> chestOfStuff = new ArrayList<ItemStack>();
        for (int i = 0; i < inv.func_70302_i_(); ++i) {
            ItemStack thing = inv.func_70301_a(i);
            if (thing == null) continue;
            boolean alreadyInList = false;
            for (int n = 0; n < chestOfStuff.size(); ++n) {
                ItemStack oldThing = chestOfStuff.get(n);
                if (oldThing == null || !oldThing.func_77969_a(thing)) continue;
                if (!ItemStack.func_77970_a((ItemStack)thing, (ItemStack)oldThing)) continue;
                oldThing.field_77994_a += thing.field_77994_a;
                int extras = BiblioSortingHelper.getExtraStackQuanityFromSpecialInventories(tile, oldThing.field_77994_a, i);
                if (extras != -1) {
                    oldThing.field_77994_a = extras;
                    chestOfStuff.set(n, oldThing);
                }
                alreadyInList = true;
                break;
            }
            if (alreadyInList) continue;
            ItemStack newThing = thing.func_77946_l();
            int extras = BiblioSortingHelper.getExtraStackQuanityFromSpecialInventories(tile, newThing.field_77994_a, i);
            if (extras == -1) continue;
            newThing.field_77994_a = extras;
            chestOfStuff.add(newThing);
        }
        return chestOfStuff;
    }

    public static int getExtraStackQuanityFromSpecialInventories(TileEntity tile, int oldValue, int slotNum) {
        if (tile != null) {
            NBTTagCompound tags = new NBTTagCompound();
            tile.func_145841_b(tags);
            if (tags != null) {
                NBTTagCompound thing;
                int tagCount;
                NBTTagCompound thing2;
                NBTTagList tagList;
                NBTTagCompound storage;
                if (tags.func_74764_b("id") && tags.func_74779_i("id").contentEquals("TileEntityBarrel") && tags.func_74764_b("storage") && (storage = tags.func_74775_l("storage")) != null && storage.func_74764_b("amount")) {
                    return storage.func_74762_e("amount");
                }
                if (tags.func_74764_b("id") && tags.func_74779_i("id").contentEquals("factoryDeepStorageUnit") && tags.func_74764_b("storedQuantity")) {
                    return tags.func_74762_e("storedQuantity");
                }
                if (tags.func_74764_b("id") && tags.func_74779_i("id").contentEquals("tilequantumdsu") && tags.func_74764_b("storedQuantity")) {
                    int quan = tags.func_74762_e("storedQuantity");
                    if (slotNum == 0) {
                        return oldValue;
                    }
                    if (BiblioSortingHelper.hasSecondSlotItem(tags)) {
                        --oldValue;
                    }
                    if (slotNum == 2) {
                        return -1;
                    }
                    return oldValue + quan;
                }
                if (tags.func_74764_b("id") && tags.func_74779_i("id").contentEquals("StorageDrawers:tileDrawersStandard") && (tagList = tags.func_150295_c("Slots", 10)) != null && (thing2 = tagList.func_150305_b(slotNum - (tagCount = tagList.func_74745_c()))) != null && thing2.func_74764_b("Count")) {
                    return thing2.func_74762_e("Count");
                }
                if (tags.func_74764_b("id") && tags.func_74779_i("id").contentEquals("thermalexpansion.Cache") && tags.func_74764_b("Item") && (thing = tags.func_74775_l("Item")) != null && thing.func_74764_b("Count")) {
                    return oldValue + thing.func_74762_e("Count");
                }
                if (tags.func_74764_b("id") && tags.func_74779_i("id").contentEquals("StorageDrawers:tileDrawersComp") && (tagList = tags.func_150295_c("Slots", 10)) != null && tags.func_74764_b("Count")) {
                    NBTTagCompound slot1 = tagList.func_150305_b(0);
                    int count = tags.func_74762_e("Count");
                    if (slot1 != null && slotNum == 3) {
                        int mod = tags.func_74762_e("Conv0");
                        int measuredQuantity = count / mod;
                        return measuredQuantity;
                    }
                    return -1;
                }
            }
        }
        return oldValue;
    }

    public static boolean hasSecondSlotItem(NBTTagCompound tags) {
        NBTTagList list;
        if (tags.func_74764_b("Items") && (list = tags.func_150295_c("Items", 10)) != null) {
            for (int i = 0; i < list.func_74745_c(); ++i) {
                NBTTagCompound comp = list.func_150305_b(i);
                if (!comp.func_74764_b("Slot") || comp.func_74765_d("Slot") != 2) continue;
                return true;
            }
        }
        return false;
    }

    public static ItemStack getLargestStackInList(ArrayList list) {
        ItemStack bestStack = null;
        for (int i = 0; i < list.size(); ++i) {
            ItemStack stack = (ItemStack)list.get(i);
            if (stack == null) continue;
            if (bestStack != null) {
                if (stack.field_77994_a <= bestStack.field_77994_a) continue;
                bestStack = stack;
                continue;
            }
            bestStack = stack;
        }
        return bestStack;
    }

    public static ArrayList<InventorySet> getUnsortedInventoryListFromStockroomCatalog(ItemStack catalog, World world) {
        NBTTagList invList;
        ArrayList<InventorySet> unsortedList = new ArrayList<InventorySet>();
        NBTTagCompound tags = catalog.func_77978_p();
        if (tags != null && (invList = tags.func_150295_c("inventoryList", 10)) != null && invList.func_74745_c() > 0) {
            for (int i = 0; i < invList.func_74745_c(); ++i) {
                NBTTagCompound invTag = invList.func_150305_b(i);
                if (invTag == null || !invTag.func_74764_b("x") || !invTag.func_74764_b("y") || !invTag.func_74764_b("z")) continue;
                int x = invTag.func_74762_e("x");
                int y = invTag.func_74762_e("y");
                int z = invTag.func_74762_e("z");
                String name = invTag.func_74779_i("name");
                ArrayList<ItemStack> inventoryStacks = new ArrayList();
                TileEntity tile = world.func_147438_o(x, y, z);
                if (tile != null && tile instanceof IInventory) {
                    inventoryStacks = BiblioSortingHelper.getStackForBuiltinLabel(tile);
                }
                if (inventoryStacks.size() <= 0) continue;
                unsortedList.add(new InventorySet(name, x, y, z, inventoryStacks));
            }
        }
        return unsortedList;
    }

    public static ArrayList<SortedListItem> buildUnsortedItemList(ArrayList<InventorySet> inventoryset) {
        ArrayList<SortedListItem> itemList = new ArrayList<SortedListItem>();
        for (int i = 0; i < inventoryset.size(); ++i) {
            InventorySet invSet = inventoryset.get(i);
            if (invSet == null) continue;
            ArrayList inv = invSet.inventoryList;
            for (int j = 0; j < inv.size(); ++j) {
                ItemStack stack = (ItemStack)inv.get(j);
                if (stack == null) continue;
                InventoryListItem newInvListItem = new InventoryListItem(stack.func_77977_a(), stack.field_77994_a, invSet.inventoryName, invSet.tileX, invSet.tileY, invSet.tileZ);
                boolean listHasItem = false;
                for (int k = 0; k < itemList.size(); ++k) {
                    SortedListItem item = itemList.get(k);
                    if (!item.itemName.contentEquals(stack.func_77977_a())) continue;
                    ArrayList<InventoryListItem> listOfInventories = item.inventoryList;
                    boolean alreadyHasCurrentInventory = false;
                    for (int n = 0; n < listOfInventories.size(); ++n) {
                        InventoryListItem invListItem = listOfInventories.get(n);
                        if (!invListItem.inventoryName.contentEquals(invSet.inventoryName) || invListItem.tileX != invSet.tileX || invListItem.tileY != invSet.tileY || invListItem.tileZ != invSet.tileZ) continue;
                        invListItem.itemQuantity += stack.field_77994_a;
                        alreadyHasCurrentInventory = true;
                        listOfInventories.set(n, invListItem);
                        break;
                    }
                    if (!alreadyHasCurrentInventory) {
                        listOfInventories.add(newInvListItem);
                    }
                    item.inventoryList = listOfInventories = BiblioSortingHelper.sortListOfInventories(listOfInventories);
                    item.itemQuantity += stack.field_77994_a;
                    listHasItem = true;
                    break;
                }
                if (listHasItem) continue;
                ArrayList<InventoryListItem> listOfInventories = new ArrayList<InventoryListItem>();
                listOfInventories.add(newInvListItem);
                itemList.add(new SortedListItem(stack.func_77977_a(), stack.field_77994_a, listOfInventories));
            }
        }
        return itemList;
    }

    public static ArrayList<InventoryListItem> sortListOfInventories(ArrayList<InventoryListItem> list) {
        ArrayList<InventoryListItem> sortedList = new ArrayList<InventoryListItem>();
        ArrayList tempList = (ArrayList)list.clone();
        for (int i = 0; i < list.size(); ++i) {
            int highestQuanIndex = BiblioSortingHelper.getHighestQuantityInventoryFromList(tempList);
            if (highestQuanIndex == -1) continue;
            sortedList.add((InventoryListItem)tempList.get(highestQuanIndex));
            tempList.remove(highestQuanIndex);
        }
        return sortedList;
    }

    public static int getHighestQuantityInventoryFromList(ArrayList<InventoryListItem> list) {
        int quantity = 0;
        int index = -1;
        for (int i = 0; i < list.size(); ++i) {
            InventoryListItem item = list.get(i);
            if (item.itemQuantity <= quantity) continue;
            quantity = item.itemQuantity;
            index = i;
        }
        return index;
    }

    public static ArrayList<SortedListItem> getUnsortedList(ItemStack catalog, World world) {
        return BiblioSortingHelper.buildUnsortedItemList(BiblioSortingHelper.getUnsortedInventoryListFromStockroomCatalog(catalog, world));
    }

    public static ArrayList<SortedListItem> getSortedListByQuantity(ArrayList<SortedListItem> list) {
        ArrayList<SortedListItem> sortedList = new ArrayList<SortedListItem>();
        ArrayList tempList = (ArrayList)list.clone();
        for (int i = 0; i < list.size(); ++i) {
            int highestQuanIndex = BiblioSortingHelper.getHighestQuantityItemFromList(tempList);
            if (highestQuanIndex == -1) continue;
            sortedList.add((SortedListItem)tempList.get(highestQuanIndex));
            tempList.remove(highestQuanIndex);
        }
        return sortedList;
    }

    public static int getHighestQuantityItemFromList(ArrayList<SortedListItem> list) {
        int quantity = 0;
        int index = -1;
        for (int i = 0; i < list.size(); ++i) {
            SortedListItem item = list.get(i);
            if (item.itemQuantity <= quantity) continue;
            quantity = item.itemQuantity;
            index = i;
        }
        return index;
    }

    public static ArrayList<SortedListItem> getSortedListByAlphabet(ArrayList<SortedListItem> list) {
        int i;
        ArrayList<SortedListItem> sortedList = new ArrayList<SortedListItem>();
        ArrayList<String> localizedNameList = new ArrayList<String>();
        for (i = 0; i < list.size(); ++i) {
            SortedListItem item = list.get(i);
            if (item == null) continue;
            localizedNameList.add(StatCollector.func_74838_a((String)(item.itemName + ".name")));
        }
        Collections.sort(localizedNameList);
        block1: for (i = 0; i < localizedNameList.size(); ++i) {
            String localName = (String)localizedNameList.get(i);
            for (int j = 0; j < list.size(); ++j) {
                SortedListItem item = list.get(j);
                if (!localName.contentEquals(StatCollector.func_74838_a((String)(item.itemName + ".name")))) continue;
                sortedList.add(item);
                continue block1;
            }
        }
        return sortedList;
    }

    public static NBTTagList convertArrayListToNBTTagList(ArrayList<SortedListItem> list) {
        NBTTagList tagList = new NBTTagList();
        for (int i = 0; i < list.size(); ++i) {
            SortedListItem item = list.get(i);
            NBTTagCompound subTag = new NBTTagCompound();
            NBTTagList invTagList = new NBTTagList();
            subTag.func_74778_a("itemName", item.itemName);
            subTag.func_74768_a("itemQuantity", item.itemQuantity);
            ArrayList<InventoryListItem> invList = item.inventoryList;
            for (int j = 0; j < invList.size(); ++j) {
                NBTTagCompound invTag = new NBTTagCompound();
                InventoryListItem invItem = invList.get(j);
                invTag.func_74778_a("itemName", invItem.itemName);
                invTag.func_74778_a("inventoryName", invItem.inventoryName);
                invTag.func_74768_a("itemQuantity", invItem.itemQuantity);
                invTag.func_74768_a("tileX", invItem.tileX);
                invTag.func_74768_a("tileY", invItem.tileY);
                invTag.func_74768_a("tileZ", invItem.tileZ);
                invTagList.func_74742_a((NBTBase)invTag);
            }
            subTag.func_74782_a("inventories", (NBTBase)invTagList);
            tagList.func_74742_a((NBTBase)subTag);
        }
        return tagList;
    }

    public static NBTTagCompound getFullyLoadedSortedListsInNBTTags(ItemStack catalog, World world) {
        NBTTagCompound tags = new NBTTagCompound();
        ArrayList<SortedListItem> unsortedList = BiblioSortingHelper.getUnsortedList(catalog, world);
        ArrayList<SortedListItem> alphaList = BiblioSortingHelper.getSortedListByAlphabet(unsortedList);
        ArrayList<SortedListItem> quantaList = BiblioSortingHelper.getSortedListByQuantity(unsortedList);
        tags.func_74782_a("alphaList", (NBTBase)BiblioSortingHelper.convertArrayListToNBTTagList(alphaList));
        tags.func_74782_a("quantaList", (NBTBase)BiblioSortingHelper.convertArrayListToNBTTagList(quantaList));
        return tags;
    }

    public static ArrayList<SortedListItem> convertNBTTagListToArrayList(NBTTagList tags) {
        ArrayList<SortedListItem> list = new ArrayList<SortedListItem>();
        for (int i = 0; i < tags.func_74745_c(); ++i) {
            NBTTagCompound subTag = tags.func_150305_b(i);
            NBTTagList invTags = subTag.func_150295_c("inventories", 10);
            ArrayList<InventoryListItem> invList = new ArrayList<InventoryListItem>();
            for (int j = 0; j < invTags.func_74745_c(); ++j) {
                NBTTagCompound inv = invTags.func_150305_b(j);
                invList.add(new InventoryListItem(inv.func_74779_i("itemName"), inv.func_74762_e("itemQuantity"), inv.func_74779_i("inventoryName"), inv.func_74762_e("tileX"), inv.func_74762_e("tileY"), inv.func_74762_e("tileZ")));
            }
            SortedListItem item = new SortedListItem(subTag.func_74779_i("itemName"), subTag.func_74762_e("itemQuantity"), invList);
            list.add(item);
        }
        return list;
    }

    public static void listTester(ArrayList<SortedListItem> list) {
        for (int i = 0; i < list.size(); ++i) {
            SortedListItem item = list.get(i);
            if (item == null) continue;
            System.out.println("item name: " + StatCollector.func_74838_a((String)(item.itemName + ".name")) + "      Quantity: " + item.itemQuantity + "      Inside x inventories: " + item.inventoryList.size());
        }
    }
}

