/*
 * Decompiled with CFR 0.152.
 */
package betterquesting.questing;

import betterquesting.api.api.ApiReference;
import betterquesting.api.api.QuestingAPI;
import betterquesting.api.enums.EnumQuestVisibility;
import betterquesting.api.properties.IPropertyContainer;
import betterquesting.api.properties.IPropertyType;
import betterquesting.api.properties.NativeProps;
import betterquesting.api.questing.IQuestLine;
import betterquesting.api.questing.IQuestLineDatabase;
import betterquesting.api.questing.IQuestLineEntry;
import betterquesting.api.utils.BigItemStack;
import betterquesting.api.utils.NBTConverter;
import betterquesting.api.utils.UuidConverter;
import betterquesting.api2.storage.UuidDatabase;
import betterquesting.questing.QuestLineEntry;
import betterquesting.storage.PropertyContainer;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.init.Items;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;

public class QuestLine
extends UuidDatabase<IQuestLineEntry>
implements IQuestLine {
    private IPropertyContainer info = new PropertyContainer();
    private IQuestLineDatabase parentDB = QuestingAPI.getAPI(ApiReference.LINE_DB);

    public QuestLine() {
        this.setupProps();
    }

    private void setupProps() {
        this.setupValue(NativeProps.NAME, "New Quest Line");
        this.setupValue(NativeProps.DESC, "No Description");
        this.setupValue(NativeProps.ICON, new BigItemStack(Items.field_151122_aG));
        this.setupValue(NativeProps.VISIBILITY, EnumQuestVisibility.NORMAL);
        this.setupValue(NativeProps.BG_IMAGE);
        this.setupValue(NativeProps.BG_SIZE);
    }

    private <T> void setupValue(IPropertyType<T> prop) {
        this.setupValue(prop, prop.getDefault());
    }

    private <T> void setupValue(IPropertyType<T> prop, T def) {
        this.info.setProperty(prop, this.info.getProperty(prop, def));
    }

    @Override
    public IQuestLineEntry createNew(UUID uuid) {
        QuestLineEntry qle = new QuestLineEntry(0, 0, 24, 24);
        this.put(uuid, qle);
        return qle;
    }

    @Override
    public String getUnlocalisedName() {
        String def = "New Quest Line";
        if (!this.info.hasProperty(NativeProps.NAME)) {
            this.info.setProperty(NativeProps.NAME, def);
            return def;
        }
        return this.info.getProperty(NativeProps.NAME, def);
    }

    @Override
    public String getUnlocalisedDescription() {
        String def = "No Description";
        if (!this.info.hasProperty(NativeProps.DESC)) {
            this.info.setProperty(NativeProps.DESC, def);
            return def;
        }
        return this.info.getProperty(NativeProps.DESC, def);
    }

    @Override
    public Map.Entry<UUID, IQuestLineEntry> getEntryAt(int x, int y) {
        for (Map.Entry<UUID, IQuestLineEntry> entry : this.entrySet()) {
            int i1 = ((IQuestLineEntry)entry.getValue()).getPosX();
            int j1 = ((IQuestLineEntry)entry.getValue()).getPosY();
            int i2 = i1 + ((IQuestLineEntry)entry.getValue()).getSizeX();
            int j2 = j1 + ((IQuestLineEntry)entry.getValue()).getSizeY();
            if (x < i1 || x >= i2 || y < j1 || y >= j2) continue;
            return entry;
        }
        return null;
    }

    @Override
    public NBTTagCompound writeToNBT(NBTTagCompound nbt) {
        return this.writeToNBT(nbt, false);
    }

    @Override
    public void readFromNBT(NBTTagCompound nbt) {
        this.readFromNBT(nbt, false);
    }

    @Override
    public NBTTagCompound writeToNBT(NBTTagCompound json, @Nullable List<Integer> subset) {
        if (subset != null) {
            throw new UnsupportedOperationException("subset not supported");
        }
        return this.writeToNBT(json, false);
    }

    @Override
    public NBTTagCompound writeToNBT(NBTTagCompound json, boolean skipQuests) {
        json.func_74782_a("properties", (NBTBase)this.info.writeToNBT(new NBTTagCompound()));
        if (!skipQuests) {
            NBTTagList jArr = new NBTTagList();
            this.orderedEntries().forEach(entry -> {
                NBTTagCompound qle = ((IQuestLineEntry)entry.getValue()).writeToNBT(new NBTTagCompound());
                NBTConverter.UuidValueType.QUEST.writeId((UUID)entry.getKey(), qle);
                jArr.func_74742_a((NBTBase)qle);
            });
            json.func_74782_a("quests", (NBTBase)jArr);
        }
        return json;
    }

    @Override
    public void readFromNBT(NBTTagCompound json, boolean merge) {
        this.info.readFromNBT(json.func_74775_l("properties"));
        if (!merge) {
            this.clear();
        }
        NBTTagList qList = json.func_150295_c("quests", 10);
        for (int i = 0; i < qList.func_74745_c(); ++i) {
            UUID questID;
            NBTTagCompound qTag = qList.func_150305_b(i);
            Optional<UUID> questIDOptional = NBTConverter.UuidValueType.QUEST.tryReadId(qTag);
            if (questIDOptional.isPresent()) {
                questID = questIDOptional.get();
            } else {
                if (!qTag.func_150297_b("id", 99)) continue;
                questID = UuidConverter.convertLegacyId(qTag.func_74762_e("id"));
            }
            this.put(questID, new QuestLineEntry(qTag));
        }
        this.setupProps();
    }

    @Override
    public <T> T getProperty(IPropertyType<T> prop) {
        return this.info.getProperty(prop);
    }

    @Override
    public <T> T getProperty(IPropertyType<T> prop, T def) {
        return this.info.getProperty(prop, def);
    }

    @Override
    public boolean hasProperty(IPropertyType<?> prop) {
        return this.info.hasProperty(prop);
    }

    @Override
    public <T> void setProperty(IPropertyType<T> prop, T value) {
        this.info.setProperty(prop, value);
    }

    @Override
    public void removeProperty(IPropertyType<?> prop) {
        this.info.removeProperty(prop);
    }

    @Override
    public void removeAllProps() {
        this.info.removeAllProps();
    }
}

