/*
 * Decompiled with CFR 0.152.
 */
package betterquesting.network.handlers;

import betterquesting.api.network.QuestingPacket;
import betterquesting.client.QuestNotification;
import betterquesting.core.BetterQuesting;
import betterquesting.network.PacketSender;
import betterquesting.network.PacketTypeRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;

public class NetNotices {
    private static final ResourceLocation ID_NAME = new ResourceLocation("betterquesting:notification");

    public static void registerHandler() {
        if (BetterQuesting.proxy.isClient()) {
            PacketTypeRegistry.INSTANCE.registerClientHandler(ID_NAME, NetNotices::onClient);
        }
    }

    public static void sendNotice(@Nullable EntityPlayerMP[] players, ItemStack icon, String mainText, String subText, String sound) {
        NBTTagCompound payload = new NBTTagCompound();
        payload.func_74782_a("icon", (NBTBase)(icon == null ? new NBTTagCompound() : icon.func_77955_b(new NBTTagCompound())));
        if (mainText != null) {
            payload.func_74778_a("mainText", mainText);
        }
        if (subText != null) {
            payload.func_74778_a("subText", subText);
        }
        if (sound != null) {
            payload.func_74778_a("sound", sound);
        }
        if (players != null) {
            PacketSender.INSTANCE.sendToPlayers(new QuestingPacket(ID_NAME, payload), players);
        } else {
            PacketSender.INSTANCE.sendToAll(new QuestingPacket(ID_NAME, payload));
        }
    }

    @SideOnly(value=Side.CLIENT)
    private static void onClient(NBTTagCompound message) {
        ItemStack stack = ItemStack.func_77949_a((NBTTagCompound)message.func_74775_l("icon"));
        String mainTxt = message.func_74779_i("mainText");
        String subTxt = message.func_74779_i("subText");
        String sound = message.func_74779_i("sound");
        QuestNotification.ScheduleNotice(mainTxt, subTxt, stack, sound);
    }
}

