/*
 * Decompiled with CFR 0.152.
 */
package betterquesting.client.toolbox.tools;

import betterquesting.api.client.toolbox.IToolboxTool;
import betterquesting.api.questing.IQuest;
import betterquesting.api.utils.NBTConverter;
import betterquesting.api2.client.gui.controls.PanelButtonQuest;
import betterquesting.api2.client.gui.misc.GuiRectangle;
import betterquesting.api2.client.gui.panels.lists.CanvasQuestLine;
import betterquesting.api2.client.gui.themes.presets.PresetColor;
import betterquesting.api2.client.gui.themes.presets.PresetLine;
import betterquesting.client.gui2.editors.designer.PanelToolController;
import betterquesting.network.handlers.NetQuestEdit;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;

public class ToolboxToolLink
implements IToolboxTool {
    private CanvasQuestLine gui;
    private final List<PanelButtonQuest> linking = new ArrayList<PanelButtonQuest>();
    private final GuiRectangle mouseRect = new GuiRectangle(0, 0, 0, 0);

    @Override
    public void initTool(CanvasQuestLine gui) {
        this.gui = gui;
        this.linking.clear();
    }

    @Override
    public void disableTool() {
        this.linking.clear();
    }

    @Override
    public void refresh(CanvasQuestLine gui) {
        if (this.linking.isEmpty()) {
            return;
        }
        ArrayList<PanelButtonQuest> tmp = new ArrayList<PanelButtonQuest>();
        for (PanelButtonQuest b1 : this.linking) {
            for (PanelButtonQuest b2 : gui.getQuestButtons()) {
                if (!((UUID)((Map.Entry)b1.getStoredValue()).getKey()).equals(((Map.Entry)b2.getStoredValue()).getKey())) continue;
                tmp.add(b2);
            }
        }
        this.linking.clear();
        this.linking.addAll(tmp);
    }

    @Override
    public void drawCanvas(int mx, int my, float partialTick) {
        if (this.linking.size() <= 0) {
            return;
        }
        this.mouseRect.x = mx;
        this.mouseRect.y = my;
        for (PanelButtonQuest btn : this.linking) {
            PresetLine.QUEST_COMPLETE.getLine().drawLine(btn.rect, this.mouseRect, 2, PresetColor.QUEST_LINE_COMPLETE.getColor(), partialTick);
        }
    }

    @Override
    public void drawOverlay(int mx, int my, float partialTick) {
    }

    @Override
    public List<String> getTooltip(int mx, int my) {
        return null;
    }

    @Override
    public boolean onMouseClick(int mx, int my, int click) {
        if (click == 1 && this.linking.size() > 0) {
            this.linking.clear();
            return true;
        }
        if (click != 0 || !this.gui.getTransform().contains(mx, my)) {
            return false;
        }
        if (this.linking.size() <= 0) {
            PanelButtonQuest btn = this.gui.getButtonAt(mx, my);
            if (btn == null) {
                return false;
            }
            if (PanelToolController.selected.size() > 0) {
                if (!PanelToolController.selected.contains(btn)) {
                    return false;
                }
                this.linking.addAll(PanelToolController.selected);
                return true;
            }
            this.linking.add(btn);
            return true;
        }
        PanelButtonQuest b2 = this.gui.getButtonAt(mx, my);
        if (b2 == null) {
            return false;
        }
        this.linking.remove(b2);
        if (this.linking.size() > 0) {
            IQuest q2 = (IQuest)((Map.Entry)b2.getStoredValue()).getValue();
            boolean mod2 = false;
            NBTTagList dataList = new NBTTagList();
            for (PanelButtonQuest b1 : this.linking) {
                IQuest q1 = (IQuest)((Map.Entry)b1.getStoredValue()).getValue();
                boolean mod1 = false;
                if (!this.containsReq(q2, (UUID)((Map.Entry)b1.getStoredValue()).getKey()) && !this.containsReq(q1, (UUID)((Map.Entry)b2.getStoredValue()).getKey())) {
                    mod2 = this.addReq(q2, (UUID)((Map.Entry)b1.getStoredValue()).getKey()) || mod2;
                } else {
                    mod2 = this.removeReq(q2, (UUID)((Map.Entry)b1.getStoredValue()).getKey()) || mod2;
                    mod1 = this.removeReq(q1, (UUID)((Map.Entry)b2.getStoredValue()).getKey());
                }
                if (!mod1) continue;
                NBTTagCompound entry = NBTConverter.UuidValueType.QUEST.writeId((UUID)((Map.Entry)b1.getStoredValue()).getKey());
                entry.func_74782_a("config", (NBTBase)((IQuest)((Map.Entry)b1.getStoredValue()).getValue()).writeToNBT(new NBTTagCompound()));
                dataList.func_74742_a((NBTBase)entry);
            }
            if (mod2) {
                NBTTagCompound entry = NBTConverter.UuidValueType.QUEST.writeId((UUID)((Map.Entry)b2.getStoredValue()).getKey());
                entry.func_74782_a("config", (NBTBase)q2.writeToNBT(new NBTTagCompound()));
                dataList.func_74742_a((NBTBase)entry);
            }
            NBTTagCompound payload = new NBTTagCompound();
            payload.func_74782_a("data", (NBTBase)dataList);
            payload.func_74768_a("action", 0);
            NetQuestEdit.sendEdit(payload);
            this.linking.clear();
            return true;
        }
        return false;
    }

    @Override
    public boolean onMouseRelease(int mx, int my, int click) {
        return false;
    }

    @Override
    public boolean onMouseScroll(int mx, int my, int scroll) {
        return false;
    }

    @Override
    public boolean onKeyPressed(char c, int keyCode) {
        return false;
    }

    @Override
    public boolean clampScrolling() {
        return true;
    }

    @Override
    public void onSelection(List<PanelButtonQuest> buttons) {
    }

    @Override
    public boolean useSelection() {
        return this.linking.isEmpty();
    }

    private boolean containsReq(IQuest quest, UUID id) {
        return quest.getRequirements().contains(id);
    }

    private boolean removeReq(IQuest quest, UUID id) {
        return quest.getRequirements().remove(id);
    }

    private boolean addReq(IQuest quest, UUID id) {
        return quest.getRequirements().add(id);
    }
}

