/*
 * Decompiled with CFR 0.152.
 */
package tuhljin.automagy.tiles;

import com.mojang.authlib.GameProfile;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.FMLLog;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.command.IEntitySelector;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.common.util.FakePlayerFactory;
import net.minecraftforge.common.util.ForgeDirection;
import org.apache.logging.log4j.Level;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.aspects.AspectSourceHelper;
import thaumcraft.api.wands.IWandable;
import thaumcraft.common.container.InventoryFake;
import thaumcraft.common.entities.golems.EntityGolemBase;
import thaumcraft.common.entities.golems.EnumGolemType;
import tuhljin.automagy.items.ModItems;
import tuhljin.automagy.lib.ThaumcraftExtension;
import tuhljin.automagy.lib.TjUtil;
import tuhljin.automagy.lib.inventory.FilteringItemList;
import tuhljin.automagy.lib.inventory.HashableItemWithoutSize;
import tuhljin.automagy.lib.inventory.InventoryCraftingCachedResult;
import tuhljin.automagy.lib.inventory.InventoryCraftingWithPlaceholder;
import tuhljin.automagy.network.MessageGUIGolemWorkbenchRecipe;
import tuhljin.automagy.tiles.ModTileEntityWithInventory;

public class TileEntityGolemWorkbench
extends ModTileEntityWithInventory
implements IWandable {
    public static final int EMPTY_CORE = 1;
    public static final int MAX_RECIPES = 3;
    public static int CRAFTING_TIME = 38;
    public static int NUM_COMPONENT_SLOTS = 9;
    public static int CRAFTINGHEAT_MAX = 12000;
    public static int CRAFTINGHEAT_SLOWER = 1200;
    public static int CRAFTINGHEAT_ON_COMPLETION = 10;
    public EntityGolemBase currentGolem = null;
    public ItemStack currentRecipeOutput = null;
    public int progress = 0;
    public boolean recipeIsAdvanced = false;
    public int craftingHeat = 0;
    public InventoryCraftingWithPlaceholder[] invCrafting = new InventoryCraftingWithPlaceholder[3];
    protected int recipeIndex = 0;
    protected int[] replacementIndex = new int[]{1, 1, 1, 1};
    protected int[] upgrades = new int[]{-1, -1, -1, -1};
    private int ticks = 0;
    protected int recipes = 1;
    protected boolean fuzzy = false;
    private int craftTimeSpeedUpgrades = 0;
    private int craftTimeStrengthUpgrades = 0;
    private int heatImpactsAt = CRAFTINGHEAT_SLOWER;
    private FakePlayer fakePlayer = null;
    public static Map<EnumGolemType, Integer> baseGolemSpeeds = new HashMap<EnumGolemType, Integer>();
    EntitySelectorCraftingGolem entitySelectorCraftingGolem = new EntitySelectorCraftingGolem();

    public TileEntityGolemWorkbench() {
        super("blockGolemWorkbench", NUM_COMPONENT_SLOTS);
        this.invCrafting[0] = new InventoryCraftingWithPlaceholder("Golem Crafting Inventory");
    }

    @Override
    public boolean func_102008_b(int slot, ItemStack stack, int side) {
        if (this.fuzzy && slot == 0) {
            return false;
        }
        if (stack != null) {
            for (int i = 0; i < this.invCrafting.length; ++i) {
                if (this.invCrafting[i] == null || !this.invCrafting[i].containsItem(stack)) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public boolean canUpdate() {
        return true;
    }

    public void func_145845_h() {
        if (!this.field_145850_b.field_72995_K) {
            ItemStack result;
            AxisAlignedBB box;
            ++this.ticks;
            if (this.craftingHeat > 0) {
                --this.craftingHeat;
            } else if (this.craftingHeat < 0 && this.currentGolem == null && this.ticks % 5 == 0) {
                ++this.craftingHeat;
            }
            if (ThaumcraftExtension.blockIsFetter(this.field_145850_b, this.field_145851_c, this.field_145848_d - 1, this.field_145849_e, true)) {
                return;
            }
            double grabRange = 3.0;
            List entities = null;
            if (!(this.progress != 0 || (entities = this.field_145850_b.func_82733_a(EntityGolemBase.class, box = AxisAlignedBB.func_72330_a((double)((double)this.field_145851_c - grabRange), (double)((double)this.field_145848_d - grabRange), (double)((double)this.field_145849_e - grabRange), (double)((double)this.field_145851_c + grabRange + 1.0), (double)((double)this.field_145848_d + grabRange), (double)((double)this.field_145849_e + grabRange + 1.0)), (IEntitySelector)this.entitySelectorCraftingGolem)).size() != 0 && this.anyGolemHandsFree(entities))) {
                return;
            }
            if (!(this.currentRecipeOutput == null && this.ticks % 20 != 0 || ItemStack.func_77989_b((ItemStack)this.currentRecipeOutput, (ItemStack)(result = this.getCraftableResults())))) {
                HashMap<HashableItemWithoutSize, Integer> map;
                this.currentRecipeOutput = result;
                this.currentGolem = null;
                this.progress = 0;
                this.ticks = 4;
                this.recipeIsAdvanced = false;
                if (this.currentRecipeOutput != null && (map = this.invCrafting[this.recipeIndex].getItemMap()).size() > 1) {
                    boolean bl = this.recipeIsAdvanced = !this.invCrafting[this.recipeIndex].recipeFitsSmallGrid();
                }
            }
            if (this.currentRecipeOutput == null) {
                return;
            }
            if (this.currentGolem == null) {
                if (entities == null) {
                    box = AxisAlignedBB.func_72330_a((double)((double)this.field_145851_c - grabRange), (double)((double)this.field_145848_d - grabRange), (double)((double)this.field_145849_e - grabRange), (double)((double)this.field_145851_c + grabRange + 1.0), (double)((double)this.field_145848_d + grabRange), (double)((double)this.field_145849_e + grabRange + 1.0));
                    entities = this.field_145850_b.func_82733_a(EntityGolemBase.class, box, (IEntitySelector)this.entitySelectorCraftingGolem);
                }
                for (EntityGolemBase golem : entities) {
                    if (this.recipeIsAdvanced && !golem.advanced || !ThaumcraftExtension.canGolemTake(golem, this.currentRecipeOutput)) continue;
                    this.currentGolem = golem;
                    this.progress = 0;
                    break;
                }
                if (this.currentGolem == null) {
                    return;
                }
            } else if (!this.entitySelectorCraftingGolem.func_82704_a((Entity)this.currentGolem) || !ThaumcraftExtension.canGolemTake(this.currentGolem, this.currentRecipeOutput) || TjUtil.getDistanceBetweenPoints_double(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.currentGolem.field_70165_t, this.currentGolem.field_70163_u, this.currentGolem.field_70161_v) > grabRange) {
                this.currentGolem = null;
                this.progress = 0;
                return;
            }
            if (this.craftingHeat > this.heatImpactsAt && AspectSourceHelper.drainEssentia((TileEntity)this, (Aspect)Aspect.CRAFT, (ForgeDirection)ForgeDirection.UNKNOWN, (int)8)) {
                this.craftingHeat = -700;
            }
            float goal = this.getCraftingTime(this.currentGolem);
            if (this.craftingHeat > this.heatImpactsAt && (goal *= 1.5f * ((float)this.craftingHeat / (float)this.heatImpactsAt)) > 200.0f) {
                goal = 200.0f;
            }
            if ((float)this.progress < goal) {
                if (this.currentGolem.field_70159_w == 0.0 && Math.abs(this.currentGolem.field_70181_x) < 0.1 && this.currentGolem.field_70179_y == 0.0) {
                    ++this.progress;
                    this.craftingHeat += 5;
                    if (this.ticks % (this.craftingHeat < this.heatImpactsAt ? 6 : 20) == 0) {
                        if (this.field_145850_b.field_73012_v.nextBoolean()) {
                            this.currentGolem.startRightArmTimer();
                        } else {
                            this.currentGolem.startLeftArmTimer();
                        }
                        this.ticks = this.field_145850_b.field_73012_v.nextInt(3) + 2;
                    }
                    if (this.craftingHeat > this.heatImpactsAt + 5) {
                        this.currentGolem.func_70690_d(new PotionEffect(Potion.field_76421_d.field_76415_H, 200, 2));
                    }
                }
            } else {
                ItemStack leftover = ThaumcraftExtension.giveItemToGolem(this.currentGolem, this.currentRecipeOutput);
                if (leftover != null) {
                    TjUtil.dropItemIntoWorld(leftover, this.field_145850_b, this.field_145851_c, (double)this.field_145848_d + 0.6, this.field_145849_e);
                }
                this.consumeCraftingIngredients();
                ItemStack[] recipe = this.fireCraftingEvent(this.invCrafting[this.recipeIndex], this.currentRecipeOutput);
                if (recipe != null) {
                    for (ItemStack stack : recipe) {
                        if (stack == null || stack.field_77994_a <= 1) continue;
                        --stack.field_77994_a;
                        ItemStack leftover2 = this.insertItemIntoLastAvailableSlot(stack);
                        if (leftover2 == null) continue;
                        TjUtil.dropItemIntoWorld(stack, this.field_145850_b, this.field_145851_c, (double)this.field_145848_d + 0.6, this.field_145849_e);
                    }
                }
                this.progress = 0;
                this.ticks = 0;
                this.craftingHeat += CRAFTINGHEAT_ON_COMPLETION;
                this.field_145850_b.func_72956_a((Entity)this.currentGolem, "random.pop", 0.1f, ((this.field_145850_b.field_73012_v.nextFloat() - this.field_145850_b.field_73012_v.nextFloat()) * 0.7f + 1.0f) * 1.5f);
            }
            if (this.craftingHeat > CRAFTINGHEAT_MAX) {
                this.craftingHeat = CRAFTINGHEAT_MAX;
            }
        }
    }

    private boolean anyGolemHandsFree(List<EntityGolemBase> entities) {
        for (EntityGolemBase golem : entities) {
            if (ThaumcraftExtension.getGolemCarriedItem(golem) != null) continue;
            return true;
        }
        return false;
    }

    public void func_145834_a(World w) {
        super.func_145834_a(w);
        for (int i = 0; i < this.recipes; ++i) {
            if (this.invCrafting[i] == null) continue;
            this.invCrafting[i].setWorld(w);
        }
    }

    public ItemStack getPlaceholderItem() {
        return this.fuzzy ? this.func_70301_a(0) : null;
    }

    public float getCraftingTime(EntityGolemBase golem) {
        int goal = CRAFTING_TIME;
        if (this.craftTimeStrengthUpgrades > 0) {
            int strength = golem.getGolemStrength();
            goal -= strength * this.craftTimeStrengthUpgrades;
        }
        if (this.craftTimeSpeedUpgrades > 0) {
            int speed = baseGolemSpeeds.get(golem.getGolemType());
            if (golem.decoration.contains("B")) {
                ++speed;
            }
            if (golem.decoration.contains("P")) {
                --speed;
            }
            speed += ThaumcraftExtension.getGolemAirUpgrades(golem);
            if (golem.advanced) {
                ++speed;
            }
            goal -= speed * this.craftTimeSpeedUpgrades;
        }
        return Math.max((float)goal, 4.1f);
    }

    protected ItemStack getCraftableResults() {
        if (this.recipeIndex > this.recipes - 1) {
            this.recipeIndex = 0;
        }
        ItemStack result = null;
        boolean checkedPrevIndex = false;
        if (this.progress > 0) {
            result = this.getCraftingResult(this.recipeIndex);
            if (result != null && this.containsAllIngredients(this.recipeIndex)) {
                return result;
            }
            checkedPrevIndex = true;
        }
        int nextIndex = this.recipeIndex;
        boolean hasIngredients = false;
        do {
            if (++nextIndex >= this.recipes) {
                nextIndex = 0;
            }
            if (nextIndex == this.recipeIndex) {
                if (checkedPrevIndex || (result = this.getCraftingResult(nextIndex)) == null) break;
                hasIngredients = this.containsAllIngredients(nextIndex);
                break;
            }
            result = this.getCraftingResult(nextIndex);
            if (result == null) continue;
            hasIngredients = this.containsAllIngredients(nextIndex);
        } while (result == null || !hasIngredients);
        if (this.recipeIndex != nextIndex) {
            this.recipeIndex = nextIndex;
            this.markDirty(false);
        }
        return hasIngredients ? result : null;
    }

    public ItemStack getCraftingResult(int index) {
        if (this.fuzzy) {
            ItemStack placeholder = this.func_70301_a(0);
            if (placeholder == null) {
                this.invCrafting[index].setPlaceholder(null, null);
            } else {
                this.invCrafting[index].setPlaceholder(placeholder, this.getFuzzyReplacement(index));
                ItemStack result = this.invCrafting[index].getCraftingResult();
                if (result == null && this.progress == 0) {
                    int prevIndex = this.replacementIndex[index];
                    do {
                        this.invCrafting[index].setPlaceholder(placeholder, this.getFuzzyReplacement(index));
                    } while ((result = this.invCrafting[index].getCraftingResult()) == null && prevIndex != this.replacementIndex[index]);
                }
                return result;
            }
        }
        return this.invCrafting[index].getCraftingResult();
    }

    protected ItemStack getFuzzyReplacement(int recIndex) {
        if (this.progress == 0) {
            ItemStack result;
            int last = this.replacementIndex[recIndex];
            do {
                int n = recIndex;
                this.replacementIndex[n] = this.replacementIndex[n] + 1;
                if (this.replacementIndex[recIndex] < NUM_COMPONENT_SLOTS) continue;
                this.replacementIndex[recIndex] = 1;
            } while ((result = this.func_70301_a(this.replacementIndex[recIndex])) == null && this.replacementIndex[recIndex] != last);
            if (last != this.replacementIndex[recIndex]) {
                this.markDirty(false);
            }
            return result;
        }
        return this.func_70301_a(this.replacementIndex[recIndex]);
    }

    public boolean containsAllIngredients(int index) {
        int i;
        HashMap<HashableItemWithoutSize, Integer> map = this.invCrafting[index].getItemMap(this.fuzzy);
        FilteringItemList list = new FilteringItemList();
        int n = i = this.fuzzy ? 1 : 0;
        while (i < NUM_COMPONENT_SLOTS) {
            ItemStack stack = this.func_70301_a(i);
            if (stack != null) {
                list.add(stack);
            }
            ++i;
        }
        for (Map.Entry<HashableItemWithoutSize, Integer> entry : map.entrySet()) {
            HashableItemWithoutSize item = entry.getKey();
            int num = entry.getValue();
            if (list.get(item) >= num) continue;
            return false;
        }
        return true;
    }

    protected void consumeCraftingIngredients() {
        block0: for (int craftSlot = 0; craftSlot < 9; ++craftSlot) {
            int slot;
            ItemStack ingredient = this.invCrafting[this.recipeIndex].getStackInSlot(craftSlot, this.fuzzy);
            if (ingredient == null) continue;
            int n = slot = this.fuzzy ? 1 : 0;
            while (slot < NUM_COMPONENT_SLOTS) {
                ItemStack stack = this.func_70301_a(slot);
                if (TjUtil.areItemsEqualIgnoringSize(ingredient, stack)) {
                    this.func_70298_a(slot, 1);
                    ItemStack container = stack.func_77973_b().getContainerItem(stack);
                    if (container != null && container.func_77984_f() && container.func_77960_j() > container.func_77958_k()) continue block0;
                    if (!stack.func_77973_b().func_77630_h(stack) && this.func_70301_a(slot) == null) {
                        this.func_70299_a(slot, container);
                        continue block0;
                    }
                    if (container == null) continue block0;
                    ItemStack leftover = container;
                    if (this.currentGolem != null && ThaumcraftExtension.golemHasOrderUpgrade(this.currentGolem)) {
                        leftover = this.insertItemIntoLastAvailableSlot(container);
                    }
                    if (leftover == null) continue block0;
                    TjUtil.dropItemIntoWorld(leftover.func_77946_l(), this.field_145850_b, this.field_145851_c, (double)this.field_145848_d + 0.6, this.field_145849_e);
                    continue block0;
                }
                ++slot;
            }
        }
    }

    public ItemStack insertItemIntoLastAvailableSlot(ItemStack stack) {
        return TjUtil.addToInventory(stack, (IInventory)this, this.func_70302_i_() - 1, this.fuzzy ? 1 : 0);
    }

    public void clientSendRecipeToServer(ItemStack[] stacks, int index) {
        MessageGUIGolemWorkbenchRecipe.sendToServer(this, stacks, index);
    }

    public void receiveRecipeFromClient(int index, ItemStack[] stacks) {
        if (stacks == null || stacks.length != this.inventorySlots.length || index < 0 || index >= this.invCrafting.length) {
            FMLLog.warning((String)"[Automagy] TileEntityGolemWorkbench received invalid packet data. Ignoring.", (Object[])new Object[0]);
            return;
        }
        if (this.invCrafting[index] == null) {
            return;
        }
        for (int i = 0; i < stacks.length; ++i) {
            this.invCrafting[index].func_70299_a(i, stacks[i]);
        }
        this.func_70296_d();
    }

    public ItemStack[] getUpgradeStacks() {
        ItemStack[] stacks = null;
        for (int i = 0; i < this.upgrades.length; ++i) {
            if (this.upgrades[i] == -1) continue;
            if (stacks == null) {
                stacks = new ItemStack[this.upgrades.length];
            }
            stacks[i] = new ItemStack((Item)ModItems.golemWorkbenchUpgrade, 1, this.upgrades[i]);
        }
        return stacks;
    }

    public boolean installUpgrade(int upgrade, int side) {
        if ((side = TjUtil.getSWNESide(TjUtil.getOppositeSide(side))) < 0 || side >= this.upgrades.length) {
            throw new IllegalArgumentException("Invalid side given as argument.");
        }
        if (upgrade >= 0 && this.upgrades[side] < 0) {
            if (upgrade == 1 && this.recipes >= 3) {
                return false;
            }
            this.upgrades[side] = upgrade;
            this.updateUpgradeEffects();
            this.func_70296_d();
            return true;
        }
        return false;
    }

    public int removeUpgrade(int side) {
        if ((side = TjUtil.getSWNESide(TjUtil.getOppositeSide(side))) < 0 || side >= this.upgrades.length) {
            throw new IllegalArgumentException("Invalid side given as argument.");
        }
        int drop = this.upgrades[side];
        if (drop >= 0) {
            this.upgrades[side] = -1;
            this.updateUpgradeEffects();
            this.func_70296_d();
        }
        return drop;
    }

    public void updateUpgradeEffects() {
        int i;
        this.craftTimeSpeedUpgrades = 0;
        this.craftTimeStrengthUpgrades = 0;
        int prevRecipes = this.recipes;
        this.recipes = 1;
        int lethargyAdjustment = 0;
        boolean prevFuzzy = this.fuzzy;
        this.fuzzy = false;
        block6: for (i = 0; i < this.upgrades.length; ++i) {
            switch (this.upgrades[i]) {
                case 0: {
                    ++this.craftTimeSpeedUpgrades;
                    ++lethargyAdjustment;
                    continue block6;
                }
                case 1: {
                    if (this.recipes >= 3) continue block6;
                    ++this.recipes;
                    if (this.invCrafting[this.recipes - 1] != null) continue block6;
                    this.invCrafting[this.recipes - 1] = new InventoryCraftingWithPlaceholder("Golem Crafting Inventory " + this.recipes);
                    this.invCrafting[this.recipes - 1].setWorld(this.field_145850_b);
                    continue block6;
                }
                case 3: {
                    ++this.craftTimeStrengthUpgrades;
                    lethargyAdjustment -= 2;
                    continue block6;
                }
                case 5: {
                    if (this.fuzzy) continue block6;
                    this.fuzzy = true;
                    lethargyAdjustment += 3;
                }
            }
        }
        this.heatImpactsAt = CRAFTINGHEAT_SLOWER - (int)((float)lethargyAdjustment * ((float)CRAFTINGHEAT_SLOWER * 0.1f));
        if (prevFuzzy != this.fuzzy) {
            if (this.fuzzy) {
                this.accessibleSlots = new int[NUM_COMPONENT_SLOTS - 1];
                for (i = 0; i < NUM_COMPONENT_SLOTS - 1; ++i) {
                    this.accessibleSlots[i] = i + 1;
                }
            } else {
                this.accessibleSlots = new int[NUM_COMPONENT_SLOTS];
                for (i = 0; i < NUM_COMPONENT_SLOTS; ++i) {
                    this.accessibleSlots[i] = i;
                }
            }
        }
        if (prevRecipes > this.recipes) {
            for (i = this.recipes; i < 3; ++i) {
                if (this.invCrafting[i] == null) continue;
                this.invCrafting[i].clearSlots();
            }
        }
    }

    public int onWandRightClick(World world, ItemStack wandstack, EntityPlayer player, int x, int y, int z, int side, int md) {
        int upgrade;
        if (!world.field_72995_K && side > 1 && side < 6 && player.func_70093_af() && (upgrade = this.removeUpgrade(side)) >= 0) {
            ForgeDirection dir = ForgeDirection.getOrientation((int)side);
            TjUtil.dropItemIntoWorldSimple(new ItemStack((Item)ModItems.golemWorkbenchUpgrade, 1, upgrade), world, (double)x + 0.5 + (double)dir.offsetX * 0.6, (double)y + 0.5 + (double)dir.offsetY * 0.6, (double)z + 0.5 + (double)dir.offsetZ * 0.6);
            world.func_72956_a((Entity)player, "thaumcraft:zap", 0.5f, 1.0f);
        }
        return 0;
    }

    public ItemStack onWandRightClick(World world, ItemStack wandstack, EntityPlayer player) {
        return null;
    }

    public void onUsingWandTick(ItemStack wandstack, EntityPlayer player, int count) {
    }

    public void onWandStoppedUsing(ItemStack wandstack, World world, EntityPlayer player, int count) {
    }

    public int getNumRecipes() {
        return this.recipes;
    }

    public boolean usingPlaceholders() {
        return this.fuzzy;
    }

    public ItemStack[] fireCraftingEvent(InventoryCraftingCachedResult craftMatrix, ItemStack output) {
        if (this.fakePlayer == null) {
            this.fakePlayer = FakePlayerFactory.get((WorldServer)((WorldServer)this.field_145850_b), (GameProfile)new GameProfile((UUID)null, "FakeCraftingGolem"));
        }
        ItemStack[] recipe = craftMatrix.getCopyOfStacks();
        try {
            FMLCommonHandler.instance().firePlayerCraftingEvent((EntityPlayer)this.fakePlayer, output, (IInventory)new InventoryFake(recipe));
        }
        catch (Exception ex) {
            FMLLog.log((Level)Level.ERROR, (String)"Exception upon firing crafting event.", (Object[])new Object[0]);
            ex.printStackTrace();
            return null;
        }
        return recipe;
    }

    @Override
    public void readCustomNBT(NBTTagCompound nbttagcompound) {
        super.readCustomNBT(nbttagcompound);
        this.craftingHeat = nbttagcompound.func_74762_e("craftingHeat");
        this.upgrades = TileEntityGolemWorkbench.getIntArrayFromNbtOrDefault(nbttagcompound, "upgrades", -1, 4);
        this.updateUpgradeEffects();
        this.invCrafting[0].readCustomNBT(nbttagcompound);
        for (int i = 0; i < this.recipes; ++i) {
            this.invCrafting[i].readCustomNBT(nbttagcompound);
        }
        this.recipeIndex = nbttagcompound.func_74762_e("recipeIndex");
        if (this.recipeIndex > this.recipes - 1) {
            this.recipeIndex = 0;
        }
        this.replacementIndex = TileEntityGolemWorkbench.getIntArrayFromNbtOrDefault(nbttagcompound, "phReplaceIndex", 1, 3);
    }

    @Override
    public void writeCustomNBT(NBTTagCompound nbttagcompound) {
        super.writeCustomNBT(nbttagcompound);
        nbttagcompound.func_74768_a("craftingHeat", this.craftingHeat);
        nbttagcompound.func_74783_a("upgrades", this.upgrades);
        for (int i = 0; i < this.recipes; ++i) {
            this.invCrafting[i].writeCustomNBT(nbttagcompound);
        }
        nbttagcompound.func_74768_a("recipeIndex", this.recipeIndex);
        nbttagcompound.func_74783_a("phReplaceIndex", this.replacementIndex);
    }

    static {
        baseGolemSpeeds.put(EnumGolemType.STRAW, 5);
        baseGolemSpeeds.put(EnumGolemType.WOOD, 4);
        baseGolemSpeeds.put(EnumGolemType.TALLOW, 3);
        baseGolemSpeeds.put(EnumGolemType.CLAY, 3);
        baseGolemSpeeds.put(EnumGolemType.FLESH, 4);
        baseGolemSpeeds.put(EnumGolemType.STONE, 2);
        baseGolemSpeeds.put(EnumGolemType.IRON, 1);
        baseGolemSpeeds.put(EnumGolemType.THAUMIUM, 2);
    }

    public class EntitySelectorCraftingGolem
    implements IEntitySelector {
        public boolean func_82704_a(Entity entity) {
            EntityGolemBase golem = (EntityGolemBase)entity;
            if (!golem.inactive && !golem.paused && golem.getCore() == 1 && golem.getCarried() == null) {
                ChunkCoordinates coord = golem.func_110172_bL();
                ForgeDirection dir = ForgeDirection.getOrientation((int)golem.homeFacing);
                if (dir != ForgeDirection.UNKNOWN && coord.field_71574_a == TileEntityGolemWorkbench.this.field_145851_c + dir.offsetX && coord.field_71572_b == TileEntityGolemWorkbench.this.field_145848_d + dir.offsetY && coord.field_71573_c == TileEntityGolemWorkbench.this.field_145849_e + dir.offsetZ) {
                    return true;
                }
            }
            return false;
        }
    }
}

