/*
 * Decompiled with CFR 0.152.
 */
package tuhljin.automagy.lib.inventory;

import java.util.HashMap;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import tuhljin.automagy.gui.ContainerEmpty;
import tuhljin.automagy.lib.TjUtil;
import tuhljin.automagy.lib.inventory.HashableItemWithoutSize;
import tuhljin.automagy.lib.inventory.InventoryCraftingCachedResult;

public class InventoryCraftingWithPlaceholder
extends InventoryCraftingCachedResult {
    protected ItemStack placeholder = null;
    protected ItemStack replacement;
    protected InventoryCrafting craftCalc = null;
    private Container container;
    private HashMap<HashableItemWithoutSize, Integer> mapConverted = null;

    public InventoryCraftingWithPlaceholder(Container container, String nbtKey) {
        super(container, nbtKey);
        this.container = container;
    }

    public InventoryCraftingWithPlaceholder(String nbtKey) {
        this(new ContainerEmpty(), nbtKey);
    }

    @Override
    public ItemStack getCraftingResult() {
        if (this.placeholder == null) {
            return super.getCraftingResult();
        }
        if (this.replacement == null) {
            return null;
        }
        if (!this.hasResult) {
            if (this.craftCalc == null) {
                this.craftCalc = new InventoryCrafting(this.container, 3, 3);
            }
            for (int i = 0; i < 9; ++i) {
                ItemStack stack = this.func_70301_a(i);
                if (stack != null && TjUtil.areItemsEqualIgnoringSize(stack, this.placeholder)) {
                    this.craftCalc.func_70299_a(i, this.replacement);
                    continue;
                }
                this.craftCalc.func_70299_a(i, stack);
            }
            this.result = CraftingManager.func_77594_a().func_82787_a(this.craftCalc, this.worldObj);
            this.hasResult = true;
        }
        return this.result;
    }

    public HashMap<HashableItemWithoutSize, Integer> getItemMap(boolean fuzzy) {
        if (!fuzzy || this.placeholder == null) {
            return super.getItemMap();
        }
        if (this.replacement == null) {
            return null;
        }
        if (this.mapConverted == null) {
            HashableItemWithoutSize replaceItem = new HashableItemWithoutSize(this.replacement);
            this.mapConverted = new HashMap();
            int size = this.func_70302_i_();
            for (int slot = 0; slot < size; ++slot) {
                ItemStack stack = this.func_70301_a(slot);
                if (stack == null) continue;
                HashableItemWithoutSize item = TjUtil.areItemsEqualIgnoringSize(stack, this.placeholder) ? replaceItem : new HashableItemWithoutSize(stack);
                if (this.mapConverted.containsKey(item)) {
                    this.mapConverted.put(item, this.mapConverted.get(item) + 1);
                    continue;
                }
                this.mapConverted.put(item, 1);
            }
        }
        return this.mapConverted;
    }

    public void setPlaceholder(ItemStack placeholder, ItemStack replacement) {
        if (!ItemStack.func_77989_b((ItemStack)placeholder, (ItemStack)this.placeholder) || !ItemStack.func_77989_b((ItemStack)replacement, (ItemStack)this.replacement)) {
            this.placeholder = placeholder;
            this.replacement = replacement;
            this.hasResult = false;
            this.mapConverted = null;
        }
    }

    public ItemStack getStackInSlot(int slot, boolean convert) {
        ItemStack stack = this.func_70301_a(slot);
        if (convert && this.placeholder != null && TjUtil.areItemsEqualIgnoringSize(stack, this.placeholder)) {
            return this.replacement;
        }
        return stack;
    }
}

