/*
 * Decompiled with CFR 0.152.
 */
package tuhljin.automagy.lib.events;

import baubles.api.BaublesApi;
import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.common.eventhandler.EventPriority;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.PlayerEvent;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.BlockMobSpawner;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.monster.EntityEnderman;
import net.minecraft.entity.monster.EntitySkeleton;
import net.minecraft.entity.monster.EntitySpider;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.init.Items;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.MobSpawnerBaseLogic;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityMobSpawner;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityDamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.entity.EntityEvent;
import net.minecraftforge.event.entity.living.EnderTeleportEvent;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingSpawnEvent;
import net.minecraftforge.event.entity.player.EntityInteractEvent;
import net.minecraftforge.event.entity.player.EntityItemPickupEvent;
import net.minecraftforge.event.entity.player.FillBucketEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.event.world.WorldEvent;
import thaumcraft.api.research.ScanResult;
import thaumcraft.common.entities.golems.EntityGolemBase;
import thaumcraft.common.lib.research.ScanManager;
import thaumcraft.common.tiles.TileJarBrain;
import tuhljin.automagy.blocks.ModBlocks;
import tuhljin.automagy.config.ModResearchItems;
import tuhljin.automagy.entities.EntityAICharmWalk;
import tuhljin.automagy.entities.GolemLink;
import tuhljin.automagy.entities.GolemTaskData;
import tuhljin.automagy.gui.AutomagyGUIHandler;
import tuhljin.automagy.items.CachedFilterData;
import tuhljin.automagy.items.ItemBaubleEnderDisjunction;
import tuhljin.automagy.items.ItemEnchantedPaper;
import tuhljin.automagy.items.ItemEntityEye;
import tuhljin.automagy.items.ItemGolemLinker;
import tuhljin.automagy.items.ModItems;
import tuhljin.automagy.lib.AutomagyConfig;
import tuhljin.automagy.lib.ThaumcraftExtension;
import tuhljin.automagy.lib.TjUtil;
import tuhljin.automagy.lib.compat.CompatibilityManager;
import tuhljin.automagy.lib.inventory.FilteringItemList;
import tuhljin.automagy.lib.inventory.HashableItemWithoutSize;
import tuhljin.automagy.lib.struct.WorldSpecificCoordinates;
import tuhljin.automagy.network.MessageClientSync;
import tuhljin.automagy.network.MessageParticles;
import tuhljin.automagy.tiles.IGolemLinkableDevice;
import tuhljin.automagy.tiles.TileEntityAmnesiacStone;
import tuhljin.automagy.tiles.TileEntityGolemTaskmaster;
import tuhljin.automagy.tiles.TileEntityInventarium;
import tuhljin.automagy.tiles.TileEntityMobLure;

public class AutomagyEventHandler {
    public static int ENDERMAN_SPAWN_INCREASE_CHANCE = 16;
    protected WorldSpecificCoordinates lastBlazeSpawner = null;
    protected List<Map> entityDataMaps = new ArrayList<Map>();
    private double lastEnderTeleportNewY = -1.0;

    public AutomagyEventHandler() {
        this.entityDataMaps.add(TileEntityMobLure.secondaryCharmedEntitiesStrength);
        this.entityDataMaps.add(TileEntityMobLure.secondaryCharmedEntitiesTime);
        this.entityDataMaps.add(TileEntityMobLure.secondaryCharmedEntitiesCoord);
        this.entityDataMaps.add(EntityAICharmWalk.charmedEntities);
    }

    @SubscribeEvent
    public void onWorldLoad(WorldEvent.Load event) {
        if (!event.world.field_72995_K && event.world.field_73011_w.field_76574_g == 0) {
            ThaumcraftExtension.setupPechTrade();
            TileEntityInventarium.coreLocations.clear();
            TileEntityMobLure.lureLocations.clear();
            CachedFilterData.newCache();
            for (Map map : this.entityDataMaps) {
                map.clear();
            }
        }
    }

    @SubscribeEvent
    public void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
        if (event.player instanceof EntityPlayerMP) {
            MessageClientSync.sendToClient((EntityPlayerMP)event.player);
        }
    }

    @SubscribeEvent
    public void onEntityConstructing(EntityEvent.EntityConstructing event) {
        if (event.entity instanceof EntityGolemBase && GolemLink.get((EntityGolemBase)event.entity) == null) {
            GolemLink link = GolemLink.register((EntityGolemBase)event.entity);
            GolemTaskData golemTaskData = GolemTaskData.register((EntityGolemBase)event.entity);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public void onEntityInteractEvent(EntityInteractEvent event) {
        ItemStack heldStack;
        if (event.entityPlayer != null && (heldStack = event.entityPlayer.func_71045_bC()) != null) {
            Item item = heldStack.func_77973_b();
            if (item instanceof ItemEntityEye && !event.entityPlayer.func_70093_af()) {
                ((ItemEntityEye)item).linkToEntity(heldStack, (EntityLivingBase)event.target, event.entityPlayer);
                event.setCanceled(true);
            } else if (event.target instanceof EntityGolemBase && item instanceof ItemGolemLinker && ((ItemGolemLinker)item).interactWithGolem(heldStack, event.entityPlayer, (EntityGolemBase)event.target)) {
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public void onPlayerInteract(PlayerInteractEvent event) {
        TileEntity te2;
        TileEntity te;
        if (event.world != null && !event.world.field_72995_K && event.action == PlayerInteractEvent.Action.RIGHT_CLICK_BLOCK && event.entityPlayer.func_71045_bC() == null && event.entityPlayer.func_70093_af() && (te = event.world.func_147438_o(event.x, event.y, event.z)) instanceof TileJarBrain && (te2 = event.world.func_147438_o(event.x, event.y - 1, event.z)) instanceof TileEntityAmnesiacStone) {
            ((TileEntityAmnesiacStone)te2).drainAllXPFromBrain((TileJarBrain)te);
        }
    }

    @SubscribeEvent
    public void onCheckSpawn(LivingSpawnEvent.CheckSpawn event) {
        if (event.entityLiving instanceof EntitySkeleton || event.entityLiving instanceof EntitySpider || event.entityLiving instanceof EntityZombie || event.entityLiving instanceof EntityCreeper) {
            World world = event.world;
            HashableItemWithoutSize item = new HashableItemWithoutSize(ModItems.ingredientHorizontal, 0, null);
            if (world.field_73012_v.nextInt(ENDERMAN_SPAWN_INCREASE_CHANCE) == 0 && this.biomeIsValidSpawn(world, (int)event.x, (int)event.y, (int)event.z, EntityEnderman.class) && this.getNearbyPlayerWithItem(item, world, event.x, event.y, event.z, 289.0) != null) {
                EntityLiving enderman;
                float f = event.x + 0.5f;
                float f1 = event.y;
                float f2 = event.z + 0.5f;
                try {
                    enderman = (EntityLiving)EntityEnderman.class.getConstructor(World.class).newInstance(event.world);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    return;
                }
                enderman.func_70012_b((double)f, (double)f1, (double)f2, world.field_73012_v.nextFloat() * 360.0f, 0.0f);
                Event.Result canSpawn = ForgeEventFactory.canEntitySpawn((EntityLiving)enderman, (World)world, (float)f, (float)f1, (float)f2);
                if (canSpawn == Event.Result.ALLOW || canSpawn == Event.Result.DEFAULT && enderman.func_70601_bi()) {
                    event.setResult(Event.Result.DENY);
                    world.func_72838_d((Entity)enderman);
                    if (!ForgeEventFactory.doSpecialSpawn((EntityLiving)enderman, (World)world, (float)f, (float)f1, (float)f2)) {
                        enderman.func_110161_a(null);
                    }
                }
            }
        }
    }

    @SubscribeEvent
    public void onEnderTeleport(EnderTeleportEvent event) {
        double range;
        TileEntityMobLure teML;
        EntityLivingBase entity = event.entityLiving;
        if (entity == null || entity instanceof EntityPlayer) {
            return;
        }
        World world = entity.field_70170_p;
        boolean teleportingToSiren = false;
        if (entity instanceof EntityLiving && ((EntityLiving)entity).func_70638_az() == null && (teML = TileEntityMobLure.getLureNear(world, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v)) != null && ModBlocks.mobLure.canActiveLureAffectEntity(teML, entity, (range = teML.getRange()) * range)) {
            double x1 = (double)teML.field_145851_c + 0.5;
            double x2 = entity.field_70165_t;
            double z1 = (double)teML.field_145849_e + 0.5;
            double z2 = entity.field_70161_v;
            double distanceXZ = (x1 - x2) * (x1 - x2) + (z1 - z2) * (z1 - z2);
            if (distanceXZ <= 16.0) {
                event.setCanceled(true);
                return;
            }
            event.targetX = teML.field_145851_c + (world.field_73012_v.nextBoolean() ? 1 : -1);
            event.targetY = teML.field_145848_d;
            event.targetZ = teML.field_145849_e + (world.field_73012_v.nextBoolean() ? 1 : -1);
            teleportingToSiren = true;
        }
        if (entity.func_110143_aJ() <= 0.0f || entity.field_70128_L) {
            return;
        }
        if (!this.positionIsValidForTeleport(entity, event.targetX, event.targetY, event.targetZ)) {
            if (teleportingToSiren) {
                event.setCanceled(true);
            }
            return;
        }
        if (teleportingToSiren && event.targetY - this.lastEnderTeleportNewY > 5.0) {
            event.setCanceled(true);
            return;
        }
        boolean goingAway = false;
        boolean arriving = false;
        boolean deadBeforeArriving = false;
        Map<EntityPlayer, Float> map = this.getDisjunctionPlayersAndDamage(world, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, ItemBaubleEnderDisjunction.TELEPORT_RIFT_FEEDBACK_SIZE, null);
        if (map.size() > 0) {
            goingAway = true;
            float goingAwayDamage = 0.0f;
            for (Map.Entry<EntityPlayer, Float> entry : map.entrySet()) {
                goingAwayDamage += entry.getValue().floatValue();
            }
            if (entity.func_110143_aJ() <= goingAwayDamage) {
                deadBeforeArriving = true;
            }
        }
        if (!deadBeforeArriving) {
            Map<EntityPlayer, Float> map2 = this.getDisjunctionPlayersAndDamage(world, event.targetX, event.targetY, event.targetZ, ItemBaubleEnderDisjunction.TELEPORT_RIFT_FEEDBACK_SIZE, goingAway ? map : null);
            if (map2.size() > 0) {
                arriving = true;
                if (goingAway) {
                    map.putAll(map2);
                } else {
                    map = map2;
                }
            }
        }
        if (map.size() > 0) {
            double preX = entity.field_70165_t;
            double preY = entity.field_70163_u;
            double preZ = entity.field_70161_v;
            if (!deadBeforeArriving) {
                float damageTotal = 0.0f;
                for (Map.Entry<EntityPlayer, Float> entry : map.entrySet()) {
                    damageTotal += entry.getValue().floatValue();
                }
                if (entity.func_110143_aJ() <= damageTotal) {
                    entity.func_70107_b(event.targetX, event.targetY, event.targetZ);
                }
            }
            for (Map.Entry<EntityPlayer, Float> entry : map.entrySet()) {
                EntityPlayer player = entry.getKey();
                Float damage = entry.getValue();
                DamageSource source = new EntityDamageSource("magic", (Entity)player).func_82726_p();
                entity.field_70172_ad = 0;
                entity.func_70097_a(source, damage.floatValue());
                if (!goingAway || !(entity.func_110143_aJ() <= 0.0f)) continue;
                event.setCanceled(true);
                break;
            }
            if (goingAway) {
                MessageParticles.sendToClients(world, (int)preX, (int)preY, (int)preZ, 0, 0, 0, (short)3);
                world.func_72908_a(preX, preY + 1.0, preZ, "thaumcraft:ice", 0.5f, 1.2f + world.field_73012_v.nextFloat() / 4.0f);
                world.func_72908_a(preX, preY + 1.0, preZ, "thaumcraft:ice", 0.3f, 0.4f + world.field_73012_v.nextFloat() / 4.0f);
            }
            if (arriving) {
                int x = (int)event.targetX;
                int y = (int)event.targetY;
                int z = (int)event.targetZ;
                MessageParticles.sendToClients(world, x, y, z, 0, 0, 0, (short)3);
                world.func_72908_a((double)x + 0.5, (double)(y + 1), (double)z + 0.5, "thaumcraft:ice", 0.5f, 1.2f + world.field_73012_v.nextFloat() / 4.0f);
                world.func_72908_a((double)x + 0.5, (double)(y + 1), (double)z + 0.5, "thaumcraft:ice", 0.3f, 0.4f + world.field_73012_v.nextFloat() / 4.0f);
            }
        }
    }

    @SubscribeEvent
    public void onBreakBlock(BlockEvent.BreakEvent event) {
        MobSpawnerBaseLogic logic;
        TileEntity te;
        this.lastBlazeSpawner = null;
        if (AutomagyConfig.netherHeartDrops && event.block instanceof BlockMobSpawner && (!AutomagyConfig.netherHeartDropNetherOnly || event.world.field_73011_w.field_76574_g == -1) && (te = event.world.func_147438_o(event.x, event.y, event.z)) instanceof TileEntityMobSpawner && "Blaze".equals((logic = ((TileEntityMobSpawner)te).func_145881_a()).func_98276_e())) {
            this.lastBlazeSpawner = new WorldSpecificCoordinates(event.world, event.x, event.y, event.z);
        }
    }

    @SubscribeEvent
    public void onHarvestDrops(BlockEvent.HarvestDropsEvent event) {
        if (this.lastBlazeSpawner != null && event.block instanceof BlockMobSpawner) {
            if (!event.isSilkTouching && event.world.field_73011_w.field_76574_g == this.lastBlazeSpawner.dim && event.x == this.lastBlazeSpawner.x && event.y == this.lastBlazeSpawner.y && event.z == this.lastBlazeSpawner.z) {
                event.drops.add(new ItemStack((Item)ModItems.netherHeart));
            }
            this.lastBlazeSpawner = null;
        }
    }

    @SubscribeEvent
    public void onItemPickup(EntityItemPickupEvent event) {
        EntityPlayer player = event.entityPlayer;
        ItemStack stack = event.item.func_92059_d();
        if (player == null || stack == null || stack.field_77994_a < 1) {
            return;
        }
        int leftover = stack.field_77994_a;
        InventoryPlayer inv = player.field_71071_by;
        HashableItemWithoutSize item = null;
        FilteringItemList playerInvMap = null;
        for (int i = 0; i < inv.field_70462_a.length; ++i) {
            ItemStack invStack = inv.field_70462_a[i];
            if (invStack != null && invStack.func_77973_b() == ModItems.autoHandMirror) {
                if (item == null) {
                    item = new HashableItemWithoutSize(stack);
                    playerInvMap = CachedFilterData.getPlayerInvMap(player, item, leftover);
                }
                leftover = ModItems.autoHandMirror.handlePickup(invStack, playerInvMap, item, leftover, player, player.field_70170_p);
            }
            if (leftover < 1) break;
        }
        stack.field_77994_a = leftover;
    }

    @SubscribeEvent
    public void onLivingUpdate(LivingEvent.LivingUpdateEvent event) {
        TileEntityInventarium teInv;
        IGolemLinkableDevice device;
        EntityGolemBase golem;
        int taskID;
        if (event.entity.field_70170_p != null && !event.entity.field_70170_p.field_72995_K && event.entityLiving instanceof EntityGolemBase && (taskID = GolemTaskData.get(golem = (EntityGolemBase)event.entityLiving).getTaskID()) != 0 && (device = GolemLink.getLinkedDevice(golem)) instanceof TileEntityGolemTaskmaster && (teInv = ((TileEntityGolemTaskmaster)device).getLinkedInventarium()) != null) {
            boolean fetchPhaseTwo = teInv.isTaskInPhaseTwo(taskID);
            ItemStack carried = golem.getCarried();
            if (!fetchPhaseTwo) {
                if (carried != null) {
                    teInv.markRequestPhaseTwo(golem);
                } else if (golem.inactive) {
                    teInv.requestFailedByGolem(golem);
                } else {
                    teInv.golemContinueClaim(golem, taskID);
                }
            } else if (carried == null) {
                teInv.requestFulfilledByGolem(golem);
            } else {
                teInv.golemContinueClaim(golem, taskID);
            }
        }
    }

    @SubscribeEvent
    public void fillBucket(FillBucketEvent event) {
        if (event.target.field_72313_a == MovingObjectPosition.MovingObjectType.BLOCK) {
            World world = event.world;
            int x = event.target.field_72311_b;
            int y = event.target.field_72312_c;
            int z = event.target.field_72309_d;
            Block block = world.func_147439_a(x, y, z);
            if ((block == ModBlocks.milk || block == CompatibilityManager.milkBlock) && world.func_72805_g(x, y, z) == 0) {
                world.func_147468_f(x, y, z);
                event.result = new ItemStack(Items.field_151117_aB);
                event.setResult(Event.Result.ALLOW);
                return;
            }
            if (block == ModBlocks.mushroomFluid && world.func_72805_g(x, y, z) == 0) {
                world.func_147468_f(x, y, z);
                event.result = new ItemStack((Item)ModItems.bucketMushroom);
                event.setResult(Event.Result.ALLOW);
                return;
            }
            if (block == ModBlocks.vishroomFluid && world.func_72805_g(x, y, z) == 0) {
                world.func_147468_f(x, y, z);
                event.result = new ItemStack((Item)ModItems.bucketVishroom);
                event.setResult(Event.Result.ALLOW);
                return;
            }
        }
    }

    @SubscribeEvent
    public void onCrafting(PlayerEvent.ItemCraftedEvent event) {
        if (ItemEnchantedPaper.stackIsFilter(event.crafting)) {
            int meta = event.crafting.func_77960_j();
            ItemStack sourceFilter = null;
            int sourceFilterSlot = 0;
            int filtersFound = 0;
            int size = event.craftMatrix.func_70302_i_();
            for (int i = 0; i < size; ++i) {
                ItemStack stack = event.craftMatrix.func_70301_a(i);
                if (stack == null || !ItemEnchantedPaper.stackIsFilter(stack)) continue;
                if (sourceFilter == null) {
                    sourceFilter = stack;
                    sourceFilterSlot = i;
                }
                if (++filtersFound > 2) break;
            }
            if (sourceFilter != null && filtersFound == 2) {
                ++sourceFilter.field_77994_a;
                event.craftMatrix.func_70299_a(sourceFilterSlot, sourceFilter);
            }
        }
    }

    @SubscribeEvent
    public void onLivingDrops(LivingDropsEvent event) {
        ScanResult sr;
        EntityPlayerMP player;
        String research;
        String sID;
        Entity source;
        if (!event.entity.field_70170_p.field_72995_K && event.recentlyHit && event.entity instanceof IMob && (source = event.source.func_76346_g()) instanceof EntityPlayerMP && !(source instanceof FakePlayer) && (sID = EntityList.func_75621_b((Entity)event.entity)) != null && (research = ModResearchItems.cluesOnKill.get(sID)) != null && (!(event.entity instanceof EntitySkeleton) || ((EntitySkeleton)event.entity).func_82202_m() == 1) && ThaumcraftExtension.isResearchComplete((EntityPlayer)(player = (EntityPlayerMP)source), "DIMENSIONLURE") && !ThaumcraftExtension.isResearchDiscovered((EntityPlayer)player, research) && ScanManager.hasBeenScanned((EntityPlayer)player, (ScanResult)(sr = new ScanResult(2, 0, 0, event.entity, "")))) {
            ThaumcraftExtension.triggerResearchUnlock(player, research);
        }
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void onRenderGameOverlay(RenderGameOverlayEvent.Pre event) {
        if (event.type == RenderGameOverlayEvent.ElementType.CROSSHAIRS && AutomagyGUIHandler.hideCrosshairs) {
            event.setCanceled(true);
        }
    }

    public EntityPlayer getNearbyPlayerWithItem(HashableItemWithoutSize item, World world, double x, double y, double z, double maxDistance) {
        Object entityplayer = null;
        for (int i = 0; i < world.field_73010_i.size(); ++i) {
            EntityPlayer entityplayer1 = (EntityPlayer)world.field_73010_i.get(i);
            double d5 = entityplayer1.func_70092_e(x, y, z);
            if (!(maxDistance < 0.0) && !(d5 < maxDistance * maxDistance) || !TjUtil.playerHasItem(entityplayer1, item)) continue;
            return entityplayer1;
        }
        return null;
    }

    protected Map<EntityPlayer, Float> getDisjunctionPlayersAndDamage(World world, double x, double y, double z, double maxDistance, Map<EntityPlayer, Float> omit) {
        HashMap<EntityPlayer, Float> map = new HashMap<EntityPlayer, Float>();
        double maxDistanceSq = maxDistance * maxDistance;
        for (int i = 0; i < world.field_73010_i.size(); ++i) {
            double d5;
            EntityPlayer player = (EntityPlayer)world.field_73010_i.get(i);
            if (omit != null && omit.containsKey(player) || !((d5 = player.func_70092_e(x, y, z)) < maxDistanceSq)) continue;
            float highestDamage = 0.0f;
            IInventory baubles = BaublesApi.getBaubles((EntityPlayer)player);
            if (baubles == null) continue;
            float damage = 0.0f;
            int size = baubles.func_70302_i_();
            for (int iB = 0; iB < size; ++iB) {
                int newDamage;
                ItemStack stack = baubles.func_70301_a(iB);
                if (stack == null || stack.func_77973_b() != ModItems.ringEnderDisjunction || (newDamage = ModItems.ringEnderDisjunction.getDisjunctionDamageAndConsumeVis(stack, player)) <= 0) continue;
                if ((float)newDamage > highestDamage) {
                    highestDamage = newDamage;
                }
                damage += (float)newDamage;
            }
            if (!(damage > 0.0f)) continue;
            damage = highestDamage + (damage - highestDamage) * ItemBaubleEnderDisjunction.TELEPORT_RIFT_FEEDBACK_DIMINISH;
            map.put(player, Float.valueOf(damage));
        }
        return map;
    }

    public boolean positionIsValidForTeleport(EntityLivingBase entity, double x, double y, double z) {
        int k;
        int j;
        double oldX = entity.field_70165_t;
        double oldY = entity.field_70163_u;
        double oldZ = entity.field_70161_v;
        double newY = y;
        int i = MathHelper.func_76128_c((double)x);
        if (entity.field_70170_p.func_72899_e(i, j = MathHelper.func_76128_c((double)y), k = MathHelper.func_76128_c((double)z))) {
            boolean flag1 = false;
            while (!flag1 && j > 0) {
                Block block = entity.field_70170_p.func_147439_a(i, j - 1, k);
                if (block.func_149688_o().func_76230_c()) {
                    flag1 = true;
                    continue;
                }
                newY -= 1.0;
                --j;
            }
            if (flag1) {
                entity.func_70107_b(x, newY, z);
                if (entity.field_70170_p.func_72945_a((Entity)entity, entity.field_70121_D).isEmpty() && !entity.field_70170_p.func_72953_d(entity.field_70121_D)) {
                    entity.func_70107_b(oldX, oldY, oldZ);
                    this.lastEnderTeleportNewY = newY;
                    return true;
                }
                entity.func_70107_b(oldX, oldY, oldZ);
            }
        }
        return false;
    }

    public boolean biomeIsValidSpawn(World world, int x, int y, int z, Class<? extends EntityLivingBase> entityClass) {
        List list = world.func_72863_F().func_73155_a(EnumCreatureType.monster, x, y, z);
        if (list != null) {
            for (Object entry : list) {
                try {
                    BiomeGenBase.SpawnListEntry spawnEntry = (BiomeGenBase.SpawnListEntry)entry;
                    if (spawnEntry.field_76300_b != entityClass) continue;
                    return true;
                }
                catch (Exception exception) {
                }
            }
        }
        return false;
    }
}

