/*
 * Decompiled with CFR 0.152.
 */
package tuhljin.automagy.blocks;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.text.DecimalFormat;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import tuhljin.automagy.lib.TjUtil;
import tuhljin.automagy.tiles.TileEntityJarXP;

public class ItemBlockJarXP
extends ItemBlock {
    public ItemBlockJarXP(Block block) {
        super(block);
        this.func_77625_d(1);
    }

    public EnumRarity func_77613_e(ItemStack stack) {
        return EnumRarity.uncommon;
    }

    public boolean placeBlockAt(ItemStack stack, EntityPlayer player, World world, int x, int y, int z, int side, float hitX, float hitY, float hitZ, int metadata) {
        int xp;
        boolean placed = super.placeBlockAt(stack, player, world, x, y, z, side, hitX, hitY, hitZ, metadata);
        if (placed && stack.func_77942_o() && (xp = stack.func_77978_p().func_74762_e("xp")) > 0) {
            TileEntityJarXP te = (TileEntityJarXP)world.func_147438_o(x, y, z);
            te.setXP(xp);
        }
        return placed;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, EntityPlayer player, List list, boolean p_77624_4_) {
        int xp;
        if (stack.func_77942_o() && (xp = stack.func_77978_p().func_74762_e("xp")) > 0) {
            String s = ItemBlockJarXP.getLevelXPInfo(xp, "Automagy.tip.jarXP");
            list.add(s);
        }
    }

    public static String getLevelXPInfo(int xp, String translateKey) {
        String sLevel;
        if (xp == 0) {
            return StatCollector.func_74837_a((String)translateKey, (Object[])new Object[]{"0", 0});
        }
        int level = TjUtil.getLevelForExperience(xp);
        int xpBaseForLevel = TjUtil.getExperienceForLevel(level);
        if (xp == xpBaseForLevel) {
            sLevel = String.valueOf(level);
        } else {
            int nextLevelXP = TjUtil.getExperienceForLevel(level + 1);
            float percentDiff = (float)(xp - xpBaseForLevel) / (float)(nextLevelXP - xpBaseForLevel);
            DecimalFormat df = new DecimalFormat("#.00");
            sLevel = String.valueOf(level + df.format(percentDiff));
        }
        return StatCollector.func_74837_a((String)translateKey, (Object[])new Object[]{sLevel, xp});
    }
}

