/*
 * Decompiled with CFR 0.152.
 */
package gcewing.architecture.client.render;

import gcewing.architecture.client.render.ICustomRenderer;
import gcewing.architecture.client.render.ITexture;
import gcewing.architecture.client.render.model.IArchitectureModel;
import gcewing.architecture.client.render.target.IRenderTarget;
import gcewing.architecture.common.block.IBlockArchitecture;
import gcewing.architecture.compat.BlockPos;
import gcewing.architecture.compat.EnumWorldBlockLayer;
import gcewing.architecture.compat.IBlockState;
import gcewing.architecture.compat.Trans3;
import gcewing.architecture.compat.Vector3;
import net.minecraft.item.ItemStack;
import net.minecraft.world.IBlockAccess;

public class RendererBaseModel
implements ICustomRenderer {
    protected final IArchitectureModel model;
    protected final ITexture[] textures;
    protected final Vector3 origin;

    public RendererBaseModel(IArchitectureModel model, ITexture ... textures) {
        this(model, Vector3.zero, textures);
    }

    public RendererBaseModel(IArchitectureModel model, Vector3 origin, ITexture ... textures) {
        this.model = model;
        this.textures = textures;
        this.origin = origin;
    }

    @Override
    public void renderBlock(IBlockAccess world, BlockPos pos, IBlockState state, IRenderTarget target, EnumWorldBlockLayer layer, Trans3 t) {
        IBlockArchitecture block = (IBlockArchitecture)state.getBlock();
        Trans3 t2 = t.t(block.localToGlobalTransformation(world, pos, state, null, Vector3.zero)).translate(this.origin);
        this.model.render(t2, target, this.textures);
    }

    @Override
    public void renderItemStack(ItemStack stack, IRenderTarget target, Trans3 t) {
        this.model.render(t.translate(this.origin), target, this.textures);
    }
}

