/*
 * Decompiled with CFR 0.152.
 */
package gcewing.architecture.client.gui.widget;

import gcewing.architecture.client.gui.widget.Group;
import gcewing.architecture.client.gui.widget.IWidget;
import gcewing.architecture.client.gui.widget.Screen;
import java.util.ArrayList;
import java.util.List;

public class Root
extends Group {
    public final Screen screen;
    public final List<IWidget> popupStack;

    public Root(Screen screen) {
        this.screen = screen;
        this.popupStack = new ArrayList<IWidget>();
    }

    @Override
    public int width() {
        return this.screen.getWidth();
    }

    @Override
    public int height() {
        return this.screen.getHeight();
    }

    @Override
    public IWidget dispatchMousePress(int x, int y, int button) {
        IWidget w = this.topPopup();
        if (w == null) {
            w = super.dispatchMousePress(x, y, button);
        }
        return w;
    }

    @Override
    public void addPopup(int x, int y, IWidget widget) {
        this.add(x, y, widget);
        this.popupStack.add(widget);
        this.screen.focusOn(widget);
    }

    @Override
    public void remove(IWidget widget) {
        super.remove(widget);
        this.popupStack.remove(widget);
        this.focusTopPopup();
    }

    public IWidget topPopup() {
        int n = this.popupStack.size();
        if (n > 0) {
            return this.popupStack.get(n - 1);
        }
        return null;
    }

    void focusTopPopup() {
        IWidget w = this.topPopup();
        if (w != null) {
            this.screen.focusOn(w);
        }
    }
}

