/*
 * Decompiled with CFR 0.152.
 */
package de.katzenpapst.amunra.world.mapgen;

import de.katzenpapst.amunra.AmunRa;
import de.katzenpapst.amunra.world.mapgen.BaseStructureComponent;
import de.katzenpapst.amunra.world.mapgen.BaseStructureStart;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import java.util.stream.Collectors;
import micdoodle8.mods.galacticraft.api.prefab.world.gen.MapGenBaseMeta;
import net.minecraft.block.Block;
import net.minecraft.util.MathHelper;
import net.minecraft.world.ChunkCoordIntPair;
import net.minecraft.world.World;
import net.minecraft.world.chunk.IChunkProvider;

public abstract class StructureGenerator
extends MapGenBaseMeta {
    protected IChunkProvider chunkProvider = null;
    protected BaseStructureMap structureMap = new BaseStructureMap();

    private List<SubComponentData> cloneSubComponentList(List<SubComponentData> subCompData) {
        return subCompData.stream().map(SubComponentData::copy).collect(Collectors.toList());
    }

    private float getProbabilityMaximum(List<SubComponentData> subCompData) {
        return subCompData.parallelStream().map(SubComponentData::getProbability).reduce(Float.valueOf(0.0f), Float::sum).floatValue();
    }

    private BaseStructureComponent generateComponent(SubComponentData entry) {
        try {
            return entry.clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            AmunRa.LOGGER.error("Instantiating " + entry.clazz.getCanonicalName() + " failed", (Throwable)e);
            return null;
        }
    }

    private int findComponentLimit(List<SubComponentData> subCompData, Random rand) {
        int minComponents = 0;
        int maxComponents = 0;
        boolean everythingHasMax = true;
        for (SubComponentData entry : subCompData) {
            minComponents += entry.minAmount;
            if (entry.maxAmount > 0) {
                maxComponents += entry.maxAmount;
                continue;
            }
            everythingHasMax = false;
        }
        if (everythingHasMax) {
            return MathHelper.func_76136_a((Random)rand, (int)minComponents, (int)maxComponents);
        }
        return MathHelper.func_76136_a((Random)rand, (int)minComponents, (int)(minComponents + subCompData.size()));
    }

    protected List<BaseStructureComponent> generateSubComponents(List<SubComponentData> subCompData, Random rand, int limit) {
        ArrayList<BaseStructureComponent> compList = new ArrayList<BaseStructureComponent>();
        HashMap<String, Integer> typeAmountMapping = new HashMap<String, Integer>();
        if (limit <= 0) {
            limit = this.findComponentLimit(subCompData, rand);
        }
        List<SubComponentData> curComponents = this.cloneSubComponentList(subCompData);
        block0: do {
            Iterator<SubComponentData> itr = curComponents.iterator();
            float curValue = 0.0f;
            float total = this.getProbabilityMaximum(curComponents);
            float curRandom = rand.nextFloat() * total;
            while (itr.hasNext()) {
                boolean isBelowMinimum;
                SubComponentData entry = itr.next();
                String typeName = entry.clazz.getCanonicalName();
                if (typeAmountMapping.get(typeName) == null) {
                    typeAmountMapping.put(typeName, 0);
                }
                int curAmount = (Integer)typeAmountMapping.get(typeName);
                boolean bl = isBelowMinimum = entry.minAmount > 0 && curAmount < entry.minAmount;
                if (isBelowMinimum || curValue <= curRandom && curRandom <= entry.probability + curValue) {
                    boolean isMaximumReached;
                    BaseStructureComponent cmp = this.generateComponent(entry);
                    if (cmp != null) {
                        compList.add(cmp);
                    }
                    typeAmountMapping.put(typeName, ++curAmount);
                    boolean bl2 = isMaximumReached = entry.maxAmount > 0 && curAmount >= entry.maxAmount;
                    if (!isMaximumReached && cmp != null) continue block0;
                    itr.remove();
                    total = this.getProbabilityMaximum(curComponents);
                    continue block0;
                }
                curValue += entry.probability;
            }
        } while (compList.size() < limit && !curComponents.isEmpty());
        return compList;
    }

    protected BaseStructureComponent generateOneComponent(List<SubComponentData> subCompData, Random rand) {
        BaseStructureComponent result = null;
        Class<? extends BaseStructureComponent> resultClass = null;
        for (SubComponentData entry : subCompData) {
            if (!(entry.probability < rand.nextFloat())) continue;
            resultClass = entry.clazz;
            break;
        }
        if (resultClass == null) {
            int i = MathHelper.func_76136_a((Random)rand, (int)0, (int)(subCompData.size() - 1));
            resultClass = subCompData.get((int)i).clazz;
        }
        try {
            result = (BaseStructureComponent)resultClass.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            AmunRa.LOGGER.error("Instantiating " + resultClass.getCanonicalName() + " failed", (Throwable)e);
        }
        return result;
    }

    protected abstract long getSalt();

    protected abstract boolean canGenerateHere(int var1, int var2, Random var3);

    protected abstract BaseStructureStart createNewStructure(int var1, int var2);

    public abstract String getName();

    public void generate(IChunkProvider chunkProvider, World world, int origXChunkCoord, int origZChunkCoord, Block[] blocks, byte[] metadata) {
        this.worldObj = world;
        this.chunkProvider = chunkProvider;
        for (int xChunkCoord = origXChunkCoord - this.range; xChunkCoord <= origXChunkCoord + this.range; ++xChunkCoord) {
            for (int zChunkCoord = origZChunkCoord - this.range; zChunkCoord <= origZChunkCoord + this.range; ++zChunkCoord) {
                if (!this.canGenerateHere(xChunkCoord, zChunkCoord, this.rand)) continue;
                this.recursiveGenerate(world, xChunkCoord, zChunkCoord, origXChunkCoord, origZChunkCoord, blocks, metadata);
            }
        }
    }

    protected void recursiveGenerate(World par1World, int xChunkCoord, int zChunkCoord, int origXChunkCoord, int origZChunkCoord, Block[] arrayOfIDs, byte[] arrayOfMeta) {
        this.makeStructure(par1World, xChunkCoord, zChunkCoord, origXChunkCoord, origZChunkCoord, arrayOfIDs, arrayOfMeta);
    }

    public void populate(IChunkProvider chunkProvider, World world, int origXChunkCoord, int origZChunkCoord) {
        this.worldObj = world;
        this.chunkProvider = chunkProvider;
        for (int xChunkCoord = origXChunkCoord - this.range; xChunkCoord <= origXChunkCoord + this.range; ++xChunkCoord) {
            for (int zChunkCoord = origZChunkCoord - this.range; zChunkCoord <= origZChunkCoord + this.range; ++zChunkCoord) {
                if (!this.canGenerateHere(xChunkCoord, zChunkCoord, this.rand)) continue;
                this.recursivePopulate(world, xChunkCoord, zChunkCoord, origXChunkCoord, origZChunkCoord);
            }
        }
    }

    protected void recursivePopulate(World world, int xChunkCoord, int zChunkCoord, int origXChunkCoord, int origZChunkCoord) {
        Long key = ChunkCoordIntPair.func_77272_a((int)xChunkCoord, (int)zChunkCoord);
        if (this.structureMap.containsKey(key)) {
            BaseStructureStart start = (BaseStructureStart)this.structureMap.get(key);
            start.populateChunk(world, origXChunkCoord, origZChunkCoord);
        } else {
            AmunRa.LOGGER.warn("No {} for population for coords {}/{}, that's weird...", new Object[]{this.getName(), xChunkCoord * 16, zChunkCoord * 16});
        }
    }

    protected void makeStructure(World world, int xChunkCoord, int zChunkCoord, int origXChunkCoord, int origZChunkCoord, Block[] arrayOfIDs, byte[] arrayOfMeta) {
        Long key = ChunkCoordIntPair.func_77272_a((int)xChunkCoord, (int)zChunkCoord);
        BaseStructureStart start = null;
        if (!this.structureMap.containsKey(key)) {
            start = this.createNewStructure(xChunkCoord, zChunkCoord);
            this.structureMap.put(key, start);
        } else {
            start = (BaseStructureStart)this.structureMap.get(key);
        }
        start.generateChunk(origXChunkCoord, origZChunkCoord, arrayOfIDs, arrayOfMeta);
    }

    public class SubComponentData {
        public Class<? extends BaseStructureComponent> clazz;
        public float probability;
        public int minAmount;
        public int maxAmount;

        public SubComponentData(Class<? extends BaseStructureComponent> clazz, float probability, int minAmount, int maxAmount) {
            this.clazz = clazz;
            this.probability = probability;
            this.minAmount = minAmount;
            this.maxAmount = maxAmount;
        }

        public SubComponentData copy() {
            return new SubComponentData(this.clazz, this.probability, this.minAmount, this.maxAmount);
        }

        public float getProbability() {
            return this.probability;
        }
    }

    public class BaseStructureMap
    extends HashMap<Long, BaseStructureStart> {
        private static final long serialVersionUID = -4123587272811107730L;
    }
}

