/*
 * Decompiled with CFR 0.152.
 */
package de.katzenpapst.amunra.world.mapgen;

import de.katzenpapst.amunra.world.WorldHelper;
import java.util.Random;
import micdoodle8.mods.galacticraft.api.prefab.core.BlockMetaPair;
import net.minecraft.block.Block;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenerator;
import net.minecraftforge.common.util.ForgeDirection;

public class CrystalFormation
extends WorldGenerator {
    protected BlockMetaPair material;
    protected BlockMetaPair airBlock;
    boolean allowDownward;
    boolean allowUpward;

    public CrystalFormation(BlockMetaPair material, BlockMetaPair airBlock, boolean allowUpward, boolean allowDownward) {
        this.material = material;
        this.airBlock = airBlock;
        this.allowDownward = allowDownward;
        this.allowUpward = allowUpward;
    }

    public CrystalFormation(BlockMetaPair material) {
        this(material, null, true, true);
    }

    public CrystalFormation(BlockMetaPair material, BlockMetaPair airBlock) {
        this(material, airBlock, true, true);
    }

    public CrystalFormation(BlockMetaPair material, boolean allowUpward, boolean allowDownward) {
        this(material, null, allowUpward, allowDownward);
    }

    protected boolean canPlaceHere(World world, int x, int y, int z) {
        if (y < 0 || y > 255) {
            return false;
        }
        if (this.airBlock == null) {
            return world.func_147437_c(x, y, z);
        }
        return WorldHelper.isBlockMetaPair(world, x, y, z, this.airBlock);
    }

    protected boolean isSolidBlock(World world, int x, int y, int z, boolean down) {
        ForgeDirection dir = down ? ForgeDirection.DOWN : ForgeDirection.UP;
        return world.isSideSolid(x, y, z, dir);
    }

    protected int getLowestBlock(World world, int x, int y, int z) {
        for (int curY = y; curY >= 0; --curY) {
            if (this.canPlaceHere(world, x, curY, z)) continue;
            return curY;
        }
        return -1;
    }

    protected int getHighestBlock(World world, int x, int y, int z) {
        for (int curY = y; curY <= 255; ++curY) {
            if (this.canPlaceHere(world, x, curY, z)) continue;
            return curY;
        }
        return -1;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean func_76484_a(World world, Random rand, int x, int y, int z) {
        boolean downwards = true;
        if (!this.canPlaceHere(world, x, y, z)) {
            return false;
        }
        int lowestY = this.getLowestBlock(world, x, y, z);
        int highestY = this.getHighestBlock(world, x, y, z);
        int actualY = 0;
        if (lowestY < 0 && highestY >= 0 && this.allowDownward) {
            downwards = true;
        } else if (lowestY >= 0 && highestY < 0 && this.allowUpward) {
            downwards = false;
        } else {
            if (lowestY < 0 || highestY < 0) return false;
            if (this.allowDownward && this.allowUpward) {
                downwards = rand.nextBoolean();
            } else if (this.allowDownward) {
                downwards = true;
            } else {
                if (!this.allowUpward) return false;
                downwards = false;
            }
        }
        actualY = downwards ? highestY - 1 : lowestY + 1;
        if (!this.canPlaceHere(world, x, actualY, z)) {
            return false;
        }
        world.func_147465_d(x, actualY, z, this.material.getBlock(), (int)this.material.getMetadata(), 2);
        for (int l = 0; l < 1500; ++l) {
            int curX = x + rand.nextInt(8) - rand.nextInt(8);
            int curY = actualY;
            int curZ = z + rand.nextInt(8) - rand.nextInt(8);
            curY = downwards ? (curY -= rand.nextInt(12)) : (curY += rand.nextInt(12));
            if (!this.canPlaceHere(world, curX, curY, curZ)) continue;
            int num = 0;
            for (int neighbour = 0; neighbour < 6; ++neighbour) {
                Block block = null;
                int meta = 0;
                switch (neighbour) {
                    case 0: {
                        block = world.func_147439_a(curX - 1, curY, curZ);
                        meta = world.func_72805_g(curX - 1, curY, curZ);
                        break;
                    }
                    case 1: {
                        block = world.func_147439_a(curX + 1, curY, curZ);
                        meta = world.func_72805_g(curX + 1, curY, curZ);
                        break;
                    }
                    case 2: {
                        block = world.func_147439_a(curX, curY - 1, curZ);
                        meta = world.func_72805_g(curX, curY - 1, curZ);
                        break;
                    }
                    case 3: {
                        block = world.func_147439_a(curX, curY + 1, curZ);
                        meta = world.func_72805_g(curX, curY + 1, curZ);
                        break;
                    }
                    case 4: {
                        block = world.func_147439_a(curX, curY, curZ - 1);
                        meta = world.func_72805_g(curX, curY, curZ - 1);
                        break;
                    }
                    case 5: {
                        block = world.func_147439_a(curX, curY, curZ + 1);
                        meta = world.func_72805_g(curX, curY, curZ + 1);
                    }
                }
                if (block != this.material.getBlock() || meta != this.material.getMetadata()) continue;
                ++num;
            }
            if (num != true) continue;
            world.func_147465_d(curX, curY, curZ, this.material.getBlock(), (int)this.material.getMetadata(), 2);
        }
        return true;
    }
}

