/*
 * Decompiled with CFR 0.152.
 */
package de.katzenpapst.amunra.tile;

import cpw.mods.fml.relauncher.Side;
import de.katzenpapst.amunra.AmunRa;
import de.katzenpapst.amunra.item.ItemDamagePair;
import de.katzenpapst.amunra.world.WorldHelper;
import java.util.EnumSet;
import micdoodle8.mods.galacticraft.api.tile.IDisableableMachine;
import micdoodle8.mods.galacticraft.api.transmission.tile.IConnector;
import micdoodle8.mods.galacticraft.core.energy.item.ItemElectricBase;
import micdoodle8.mods.galacticraft.core.network.IPacketReceiver;
import micdoodle8.mods.galacticraft.core.tile.TileEntityOxygen;
import micdoodle8.mods.galacticraft.core.util.Annotations;
import micdoodle8.mods.galacticraft.core.util.GCCoreUtil;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Items;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraftforge.common.util.ForgeDirection;

public class TileEntityHydroponics
extends TileEntityOxygen
implements IPacketReceiver,
IDisableableMachine,
IInventory,
ISidedInventory,
IConnector {
    public boolean active;
    public static final int OUTPUT_PER_TICK = 100;
    @Annotations.NetworkedField(targetSide=Side.CLIENT)
    public float lastOxygenCollected;
    private ItemStack[] containingItems = new ItemStack[2];
    @Annotations.NetworkedField(targetSide=Side.CLIENT)
    public float plantGrowthStatus = -1.0f;
    public static ItemDamagePair seeds = null;
    public static ItemDamagePair bonemeal = null;

    public TileEntityHydroponics() {
        super(6000.0f, 0.0f);
        if (seeds == null) {
            seeds = new ItemDamagePair(Items.field_151014_N, 0);
        }
        if (bonemeal == null) {
            bonemeal = new ItemDamagePair(Items.field_151100_aR, 15);
        }
        this.storage.setMaxExtract(5.0f);
    }

    public void func_145845_h() {
        super.func_145845_h();
        if (!this.field_145850_b.field_72995_K) {
            this.produceOxygen();
            this.generateOxygen();
            this.growPlant();
        }
    }

    public float getOxygenProvide(ForgeDirection direction) {
        return this.getOxygenOutputDirections().contains(direction) ? Math.min(100.0f, this.getOxygenStored()) : 0.0f;
    }

    public boolean shouldPullOxygen() {
        return false;
    }

    public String func_145825_b() {
        return GCCoreUtil.translate((String)"tile.hydroponics.name");
    }

    public boolean func_145818_k_() {
        return true;
    }

    public boolean func_94041_b(int index, ItemStack stack) {
        boolean bl;
        switch (index) {
            case 0: {
                bl = ItemElectricBase.isElectricItem((Item)stack.func_77973_b());
                break;
            }
            case 1: {
                if (seeds.isSameItem(stack) || bonemeal.isSameItem(stack)) {
                    bl = true;
                    break;
                }
                bl = false;
                break;
            }
            default: {
                bl = false;
            }
        }
        return bl;
    }

    public boolean shouldUseEnergy() {
        return !this.getDisabled(0);
    }

    public int[] func_94128_d(int p_94128_1_) {
        return new int[]{0, 1};
    }

    public boolean func_102007_a(int p_102007_1_, ItemStack p_102007_2_, int p_102007_3_) {
        return this.func_94041_b(p_102007_1_, p_102007_2_);
    }

    public boolean func_102008_b(int p_102008_1_, ItemStack p_102008_2_, int p_102008_3_) {
        return p_102008_1_ == 0 || p_102008_1_ == 1;
    }

    public int func_70302_i_() {
        return this.containingItems.length;
    }

    public ItemStack func_70301_a(int slotIn) {
        return this.containingItems[slotIn];
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.containingItems = this.readStandardItemsFromNBT(compound);
        this.plantGrowthStatus = compound.func_74760_g("growthStatus");
    }

    public void func_145841_b(NBTTagCompound compound) {
        super.func_145841_b(compound);
        this.writeStandardItemsToNBT(compound);
        compound.func_74776_a("growthStatus", this.plantGrowthStatus);
    }

    public ItemStack[] readStandardItemsFromNBT(NBTTagCompound nbt) {
        NBTTagList itemTag = nbt.func_150295_c("Items", 10);
        int length = this.containingItems.length;
        ItemStack[] result = new ItemStack[length];
        for (int i = 0; i < itemTag.func_74745_c(); ++i) {
            NBTTagCompound stackNbt = itemTag.func_150305_b(i);
            int slotNr = stackNbt.func_74771_c("Slot") & 0xFF;
            if (slotNr >= length) continue;
            result[slotNr] = ItemStack.func_77949_a((NBTTagCompound)stackNbt);
        }
        return result;
    }

    public void writeStandardItemsToNBT(NBTTagCompound nbt) {
        NBTTagList list = new NBTTagList();
        int length = this.containingItems.length;
        for (int i = 0; i < length; ++i) {
            if (this.containingItems[i] == null) continue;
            NBTTagCompound stackNbt = new NBTTagCompound();
            stackNbt.func_74774_a("Slot", (byte)i);
            this.containingItems[i].func_77955_b(stackNbt);
            list.func_74742_a((NBTBase)stackNbt);
        }
        nbt.func_74782_a("Items", (NBTBase)list);
    }

    public ItemStack func_70298_a(int index, int count) {
        ItemStack newStack;
        if (this.containingItems[index] == null) {
            return null;
        }
        if (this.containingItems[index].field_77994_a <= count) {
            newStack = this.containingItems[index];
            this.containingItems[index] = null;
        } else {
            newStack = this.containingItems[index].func_77979_a(count);
            if (this.containingItems[index].field_77994_a == 0) {
                this.containingItems[index] = null;
            }
        }
        return newStack;
    }

    public ItemStack func_70304_b(int index) {
        if (this.containingItems[index] != null) {
            ItemStack var2 = this.containingItems[index];
            this.containingItems[index] = null;
            return var2;
        }
        return null;
    }

    protected void generateOxygen() {
        if (this.field_145850_b.field_73012_v.nextInt(10) == 0) {
            if (this.hasEnoughEnergyToRun && this.plantGrowthStatus > 0.0f) {
                float generationRate = 3.0f * this.plantGrowthStatus * AmunRa.config.hydroponicsFactor;
                this.lastOxygenCollected = generationRate / 10.0f;
                this.storedOxygen = Math.max(Math.min(this.storedOxygen + generationRate, this.maxOxygen), 0.0f);
            } else {
                this.lastOxygenCollected = 0.0f;
            }
        }
    }

    protected void growPlant() {
        if (this.plantGrowthStatus == -1.0f || this.plantGrowthStatus == 1.0f || this.field_145850_b.func_72957_l(this.field_145851_c, this.field_145848_d + 1, this.field_145849_e) < 9) {
            return;
        }
        if (this.ticks % 20 == 0 && this.field_145850_b.field_73012_v.nextFloat() < 0.1f) {
            this.plantGrowthStatus += 0.01f;
            if (this.plantGrowthStatus > 1.0f) {
                this.plantGrowthStatus = 1.0f;
            }
            this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }
    }

    public void func_70299_a(int index, ItemStack stack) {
        this.containingItems[index] = stack;
        if (stack != null && stack.field_77994_a > this.func_70297_j_()) {
            stack.field_77994_a = this.func_70297_j_();
        }
    }

    public int func_70297_j_() {
        return 64;
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    public boolean shouldUseOxygen() {
        return false;
    }

    public ForgeDirection getElectricInputDirection() {
        return ForgeDirection.DOWN;
    }

    public EnumSet<ForgeDirection> getOxygenOutputDirections() {
        return EnumSet.of(ForgeDirection.EAST, ForgeDirection.WEST, ForgeDirection.NORTH, ForgeDirection.SOUTH);
    }

    public EnumSet<ForgeDirection> getOxygenInputDirections() {
        return EnumSet.noneOf(ForgeDirection.class);
    }

    public ItemStack getBatteryInSlot() {
        return this.func_70301_a(0);
    }

    public float getPlantGrowthStatus() {
        return this.plantGrowthStatus;
    }

    public void plantSeed() {
        this.plantGrowthStatus = 0.0f;
    }

    public void fertilize() {
        this.plantGrowthStatus += 0.125f;
    }

    public ItemStack[] getHarvest() {
        if (this.plantGrowthStatus < 0.0f) {
            return new ItemStack[0];
        }
        if (this.plantGrowthStatus < 1.0f) {
            return new ItemStack[]{seeds.getItemStack(1)};
        }
        int numSeeds = this.field_145850_b.field_73012_v.nextInt(4);
        return new ItemStack[]{new ItemStack(Items.field_151015_O, 1, 0), seeds.getItemStack(numSeeds)};
    }

    public void harvest(EntityPlayer player) {
        ItemStack[] harvest;
        for (ItemStack stack : harvest = this.getHarvest()) {
            if (player.field_71071_by.func_70441_a(stack)) continue;
            WorldHelper.dropItemInWorld(this.field_145850_b, stack, (Entity)player);
        }
        this.plantGrowthStatus = 0.0f;
    }

    public void performOperation(int op, EntityPlayerMP playerBase) {
        OperationType realOp = OperationType.values()[op];
        switch (realOp) {
            case PLANT_SEED: {
                ItemStack stack = this.containingItems[1];
                if (this.plantGrowthStatus != -1.0f || stack == null || stack.field_77994_a <= 0 || !seeds.isSameItem(stack)) break;
                --stack.field_77994_a;
                if (stack.field_77994_a <= 0) {
                    stack = null;
                }
                this.containingItems[1] = stack;
                this.plantSeed();
                break;
            }
            case FERTILIZE: {
                ItemStack stack = this.containingItems[1];
                if (!(this.plantGrowthStatus >= 0.0f) || !(this.plantGrowthStatus < 1.0f) || stack == null || stack.field_77994_a <= 0 || !bonemeal.isSameItem(stack)) break;
                --stack.field_77994_a;
                if (stack.field_77994_a <= 0) {
                    stack = null;
                }
                this.containingItems[1] = stack;
                this.fertilize();
                break;
            }
            case HARVEST: {
                if (this.plantGrowthStatus != 1.0f) break;
                this.harvest((EntityPlayer)playerBase);
            }
        }
    }

    public boolean func_70300_a(EntityPlayer par1EntityPlayer) {
        return this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d, this.field_145849_e) == this && par1EntityPlayer.func_70092_e((double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5) <= 64.0;
    }

    public static enum OperationType {
        PLANT_SEED,
        FERTILIZE,
        HARVEST;

    }
}

