/*
 * Decompiled with CFR 0.152.
 */
package de.katzenpapst.amunra.block.machine;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import de.katzenpapst.amunra.AmunRa;
import de.katzenpapst.amunra.block.BlockMachineMeta;
import de.katzenpapst.amunra.block.SubBlockMachine;
import de.katzenpapst.amunra.helper.CoordHelper;
import de.katzenpapst.amunra.tile.TileEntityIsotopeGenerator;
import micdoodle8.mods.galacticraft.core.util.GCCoreUtil;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class BlockIsotopeGenerator
extends SubBlockMachine {
    private IIcon iconOutput = null;
    private IIcon iconBlank = null;
    protected final String outputTexture;
    protected final String sideTexture;
    public final float energyGeneration;

    public BlockIsotopeGenerator(String name, String frontTexture, String outputTexture, String sideTexture, float energyGeneration) {
        super(name, frontTexture);
        this.outputTexture = outputTexture;
        this.sideTexture = sideTexture;
        this.energyGeneration = energyGeneration;
    }

    public static boolean isSideEnergyOutput(int side) {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister reg) {
        super.func_149651_a(reg);
        this.iconBlank = reg.func_94245_a(this.sideTexture);
        this.iconOutput = reg.func_94245_a(this.outputTexture);
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149691_a(int side, int meta) {
        int realMeta = ((BlockMachineMeta)this.parent).getRotationMeta(meta);
        ForgeDirection front = CoordHelper.rotateForgeDirection(ForgeDirection.SOUTH, realMeta);
        if (side == ForgeDirection.UP.ordinal() || side == ForgeDirection.DOWN.ordinal()) {
            return this.iconBlank;
        }
        if (side == front.ordinal()) {
            return this.field_149761_L;
        }
        return this.iconOutput;
    }

    @Override
    public boolean onMachineActivated(World world, int x, int y, int z, EntityPlayer entityPlayer, int side, float hitX, float hitY, float hitZ) {
        entityPlayer.openGui((Object)AmunRa.instance, 1, world, x, y, z);
        return true;
    }

    @Override
    public TileEntity createTileEntity(World world, int metadata) {
        return new TileEntityIsotopeGenerator();
    }

    public boolean hasTileEntity(int metadata) {
        return true;
    }

    @Override
    public String getShiftDescription(int meta) {
        return GCCoreUtil.translate((String)"tile.isotopeGenerator.description");
    }
}

