/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level;

import com.mojang.logging.LogUtils;
import com.mojang.serialization.DynamicOps;
import java.util.Optional;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.util.random.SimpleWeightedRandomList;
import net.minecraft.world.Difficulty;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnPlacements;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.SpawnData;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.eventbus.api.Event;
import org.slf4j.Logger;

public abstract class BaseSpawner {
    private static final Logger f_45441_ = LogUtils.getLogger();
    private static final int f_151303_ = 1;
    private int f_45442_ = 20;
    private SimpleWeightedRandomList<SpawnData> f_45443_ = SimpleWeightedRandomList.m_185864_();
    private SpawnData f_45444_ = new SpawnData();
    private double f_45445_;
    private double f_45446_;
    private int f_45447_ = 200;
    private int f_45448_ = 800;
    private int f_45449_ = 4;
    @Nullable
    private Entity f_45450_;
    private int f_45451_ = 6;
    private int f_45452_ = 16;
    private int f_45453_ = 4;

    public void m_45462_(EntityType<?> p_45463_) {
        this.f_45444_.m_186567_().m_128359_("id", Registry.f_122826_.m_7981_(p_45463_).toString());
    }

    private boolean m_151343_(Level p_151344_, BlockPos p_151345_) {
        return p_151344_.m_45914_((double)p_151345_.m_123341_() + 0.5, (double)p_151345_.m_123342_() + 0.5, (double)p_151345_.m_123343_() + 0.5, this.f_45452_);
    }

    public void m_151319_(Level p_151320_, BlockPos p_151321_) {
        if (!this.m_151343_(p_151320_, p_151321_)) {
            this.f_45446_ = this.f_45445_;
        } else {
            RandomSource randomsource = p_151320_.m_213780_();
            double d0 = (double)p_151321_.m_123341_() + randomsource.m_188500_();
            double d1 = (double)p_151321_.m_123342_() + randomsource.m_188500_();
            double d2 = (double)p_151321_.m_123343_() + randomsource.m_188500_();
            p_151320_.m_7106_((ParticleOptions)ParticleTypes.f_123762_, d0, d1, d2, 0.0, 0.0, 0.0);
            p_151320_.m_7106_((ParticleOptions)ParticleTypes.f_123744_, d0, d1, d2, 0.0, 0.0, 0.0);
            if (this.f_45442_ > 0) {
                --this.f_45442_;
            }
            this.f_45446_ = this.f_45445_;
            this.f_45445_ = (this.f_45445_ + (double)(1000.0f / ((float)this.f_45442_ + 200.0f))) % 360.0;
        }
    }

    public void m_151311_(ServerLevel p_151312_, BlockPos p_151313_) {
        if (this.m_151343_(p_151312_, p_151313_)) {
            if (this.f_45442_ == -1) {
                this.m_151350_(p_151312_, p_151313_);
            }
            if (this.f_45442_ > 0) {
                --this.f_45442_;
            } else {
                boolean flag = false;
                for (int i = 0; i < this.f_45449_; ++i) {
                    SpawnData.CustomSpawnRules spawndata$customspawnrules;
                    double d2;
                    CompoundTag compoundtag = this.f_45444_.m_186567_();
                    Optional<EntityType<?>> optional = EntityType.m_20637_(compoundtag);
                    if (optional.isEmpty()) {
                        this.m_151350_(p_151312_, p_151313_);
                        return;
                    }
                    ListTag listtag = compoundtag.m_128437_("Pos", 6);
                    int j = listtag.size();
                    RandomSource randomsource = p_151312_.m_213780_();
                    double d0 = j >= 1 ? listtag.m_128772_(0) : (double)p_151313_.m_123341_() + (randomsource.m_188500_() - randomsource.m_188500_()) * (double)this.f_45453_ + 0.5;
                    double d1 = j >= 2 ? listtag.m_128772_(1) : (double)(p_151313_.m_123342_() + randomsource.m_188503_(3) - 1);
                    double d = d2 = j >= 3 ? listtag.m_128772_(2) : (double)p_151313_.m_123343_() + (randomsource.m_188500_() - randomsource.m_188500_()) * (double)this.f_45453_ + 0.5;
                    if (!p_151312_.m_45772_(optional.get().m_20585_(d0, d1, d2))) continue;
                    BlockPos blockpos = new BlockPos(d0, d1, d2);
                    if (!this.f_45444_.m_186574_().isPresent() ? !SpawnPlacements.m_217074_(optional.get(), (ServerLevelAccessor)p_151312_, MobSpawnType.SPAWNER, blockpos, p_151312_.m_213780_()) : !optional.get().m_20674_().m_21609_() && p_151312_.m_46791_() == Difficulty.PEACEFUL || !(spawndata$customspawnrules = (SpawnData.CustomSpawnRules)this.f_45444_.m_186574_().get()).f_186584_().m_184578_((Comparable)Integer.valueOf(p_151312_.m_45517_(LightLayer.BLOCK, blockpos))) || !spawndata$customspawnrules.f_186585_().m_184578_((Comparable)Integer.valueOf(p_151312_.m_45517_(LightLayer.SKY, blockpos)))) continue;
                    Entity entity = EntityType.m_20645_(compoundtag, p_151312_, p_151310_ -> {
                        p_151310_.m_7678_(d0, d1, d2, p_151310_.m_146908_(), p_151310_.m_146909_());
                        return p_151310_;
                    });
                    if (entity == null) {
                        this.m_151350_(p_151312_, p_151313_);
                        return;
                    }
                    int k = p_151312_.m_45976_(((Object)((Object)entity)).getClass(), new AABB((double)p_151313_.m_123341_(), (double)p_151313_.m_123342_(), (double)p_151313_.m_123343_(), (double)(p_151313_.m_123341_() + 1), (double)(p_151313_.m_123342_() + 1), (double)(p_151313_.m_123343_() + 1)).m_82400_((double)this.f_45453_)).size();
                    if (k >= this.f_45451_) {
                        this.m_151350_(p_151312_, p_151313_);
                        return;
                    }
                    entity.m_7678_(entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), randomsource.m_188501_() * 360.0f, 0.0f);
                    if (entity instanceof Mob) {
                        Mob mob = (Mob)entity;
                        Event.Result res = ForgeEventFactory.canEntitySpawn((Mob)mob, (LevelAccessor)p_151312_, (double)((float)entity.m_20185_()), (double)((float)entity.m_20186_()), (double)((float)entity.m_20189_()), (BaseSpawner)this, (MobSpawnType)MobSpawnType.SPAWNER);
                        if (res == Event.Result.DENY || res == Event.Result.DEFAULT && (this.f_45444_.m_186574_().isEmpty() && !mob.m_5545_(p_151312_, MobSpawnType.SPAWNER) || !mob.m_6914_((LevelReader)((Object)p_151312_)))) continue;
                        if (this.f_45444_.m_186567_().m_128440_() == 1 && this.f_45444_.m_186567_().m_128425_("id", 8) && !ForgeEventFactory.doSpecialSpawn((Mob)mob, (LevelAccessor)p_151312_, (float)((float)entity.m_20185_()), (float)((float)entity.m_20186_()), (float)((float)entity.m_20189_()), (BaseSpawner)this, (MobSpawnType)MobSpawnType.SPAWNER)) {
                            ((Mob)entity).m_6518_((ServerLevelAccessor)p_151312_, p_151312_.m_6436_(entity.m_20183_()), MobSpawnType.SPAWNER, null, null);
                        }
                    }
                    if (!p_151312_.m_8860_(entity)) {
                        this.m_151350_(p_151312_, p_151313_);
                        return;
                    }
                    p_151312_.m_46796_(2004, p_151313_, 0);
                    p_151312_.m_142346_(entity, GameEvent.f_157810_, blockpos);
                    if (entity instanceof Mob) {
                        ((Mob)entity).m_21373_();
                    }
                    flag = true;
                }
                if (flag) {
                    this.m_151350_(p_151312_, p_151313_);
                }
            }
        }
    }

    private void m_151350_(Level p_151351_, BlockPos p_151352_) {
        RandomSource randomsource = p_151351_.f_46441_;
        this.f_45442_ = this.f_45448_ <= this.f_45447_ ? this.f_45447_ : this.f_45447_ + randomsource.m_188503_(this.f_45448_ - this.f_45447_);
        this.f_45443_.m_216829_(randomsource).ifPresent(p_186386_ -> this.m_142667_(p_151351_, p_151352_, (SpawnData)p_186386_.m_146310_()));
        this.m_142523_(p_151351_, p_151352_, 1);
    }

    public void m_151328_(@Nullable Level p_151329_, BlockPos p_151330_, CompoundTag p_151331_) {
        this.f_45442_ = p_151331_.m_128448_("Delay");
        boolean flag = p_151331_.m_128425_("SpawnPotentials", 9);
        boolean flag1 = p_151331_.m_128425_("SpawnData", 10);
        if (!flag) {
            SpawnData spawndata = flag1 ? SpawnData.f_186559_.parse((DynamicOps)NbtOps.f_128958_, (Object)p_151331_.m_128469_("SpawnData")).resultOrPartial(p_186391_ -> f_45441_.warn("Invalid SpawnData: {}", p_186391_)).orElseGet(SpawnData::new) : new SpawnData();
            this.f_45443_ = SimpleWeightedRandomList.m_185862_((Object)spawndata);
            this.m_142667_(p_151329_, p_151330_, spawndata);
        } else {
            ListTag listtag = p_151331_.m_128437_("SpawnPotentials", 10);
            this.f_45443_ = SpawnData.f_186560_.parse((DynamicOps)NbtOps.f_128958_, (Object)listtag).resultOrPartial(p_186388_ -> f_45441_.warn("Invalid SpawnPotentials list: {}", p_186388_)).orElseGet(SimpleWeightedRandomList::m_185864_);
            if (flag1) {
                SpawnData spawndata1 = SpawnData.f_186559_.parse((DynamicOps)NbtOps.f_128958_, (Object)p_151331_.m_128469_("SpawnData")).resultOrPartial(p_186380_ -> f_45441_.warn("Invalid SpawnData: {}", p_186380_)).orElseGet(SpawnData::new);
                this.m_142667_(p_151329_, p_151330_, spawndata1);
            } else {
                this.f_45443_.m_216829_(p_151329_.m_213780_()).ifPresent(p_186378_ -> this.m_142667_(p_151329_, p_151330_, (SpawnData)p_186378_.m_146310_()));
            }
        }
        if (p_151331_.m_128425_("MinSpawnDelay", 99)) {
            this.f_45447_ = p_151331_.m_128448_("MinSpawnDelay");
            this.f_45448_ = p_151331_.m_128448_("MaxSpawnDelay");
            this.f_45449_ = p_151331_.m_128448_("SpawnCount");
        }
        if (p_151331_.m_128425_("MaxNearbyEntities", 99)) {
            this.f_45451_ = p_151331_.m_128448_("MaxNearbyEntities");
            this.f_45452_ = p_151331_.m_128448_("RequiredPlayerRange");
        }
        if (p_151331_.m_128425_("SpawnRange", 99)) {
            this.f_45453_ = p_151331_.m_128448_("SpawnRange");
        }
        this.f_45450_ = null;
    }

    public CompoundTag m_186381_(CompoundTag p_186382_) {
        p_186382_.m_128376_("Delay", (short)this.f_45442_);
        p_186382_.m_128376_("MinSpawnDelay", (short)this.f_45447_);
        p_186382_.m_128376_("MaxSpawnDelay", (short)this.f_45448_);
        p_186382_.m_128376_("SpawnCount", (short)this.f_45449_);
        p_186382_.m_128376_("MaxNearbyEntities", (short)this.f_45451_);
        p_186382_.m_128376_("RequiredPlayerRange", (short)this.f_45452_);
        p_186382_.m_128376_("SpawnRange", (short)this.f_45453_);
        p_186382_.m_128365_("SpawnData", (Tag)SpawnData.f_186559_.encodeStart((DynamicOps)NbtOps.f_128958_, (Object)this.f_45444_).result().orElseThrow(() -> new IllegalStateException("Invalid SpawnData")));
        p_186382_.m_128365_("SpawnPotentials", (Tag)SpawnData.f_186560_.encodeStart((DynamicOps)NbtOps.f_128958_, this.f_45443_).result().orElseThrow());
        return p_186382_;
    }

    @Nullable
    public Entity m_151314_(Level p_151315_) {
        if (this.f_45450_ == null) {
            this.f_45450_ = EntityType.m_20645_(this.f_45444_.m_186567_(), p_151315_, Function.identity());
            if (this.f_45444_.m_186567_().m_128440_() != 1 || !this.f_45444_.m_186567_().m_128425_("id", 8) || this.f_45450_ instanceof Mob) {
                // empty if block
            }
        }
        return this.f_45450_;
    }

    public boolean m_151316_(Level p_151317_, int p_151318_) {
        if (p_151318_ == 1) {
            if (p_151317_.f_46443_) {
                this.f_45442_ = this.f_45447_;
            }
            return true;
        }
        return false;
    }

    public void m_142667_(@Nullable Level p_151325_, BlockPos p_151326_, SpawnData p_151327_) {
        this.f_45444_ = p_151327_;
    }

    public abstract void m_142523_(Level var1, BlockPos var2, int var3);

    public double m_45473_() {
        return this.f_45445_;
    }

    public double m_45474_() {
        return this.f_45446_;
    }

    @Nullable
    public Entity getSpawnerEntity() {
        return null;
    }

    @Nullable
    public BlockEntity getSpawnerBlockEntity() {
        return null;
    }
}

