/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.client;

import com.google.common.collect.ImmutableMap;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.renderer.DimensionSpecialEffects;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.dimension.BuiltinDimensionTypes;
import net.minecraftforge.client.event.RegisterDimensionSpecialEffectsEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.fml.ModLoader;
import net.minecraftforge.fml.ModLoadingContext;
import org.jetbrains.annotations.ApiStatus;

public final class DimensionSpecialEffectsManager {
    private static ImmutableMap<ResourceLocation, DimensionSpecialEffects> EFFECTS;
    private static DimensionSpecialEffects DEFAULT_EFFECTS;

    public static DimensionSpecialEffects getForType(ResourceLocation type) {
        return (DimensionSpecialEffects)EFFECTS.getOrDefault((Object)type, (Object)DEFAULT_EFFECTS);
    }

    @ApiStatus.Internal
    public static void init() {
        HashMap<ResourceLocation, DimensionSpecialEffects> effects = new HashMap<ResourceLocation, DimensionSpecialEffects>();
        DEFAULT_EFFECTS = DimensionSpecialEffectsManager.preRegisterVanillaEffects(effects);
        RegisterDimensionSpecialEffectsEvent event = new RegisterDimensionSpecialEffectsEvent(effects);
        ModLoader.get().postEventWithWrapInModOrder((Event)event, (mc, e) -> ModLoadingContext.get().setActiveContainer(mc), (mc, e) -> ModLoadingContext.get().setActiveContainer(null));
        EFFECTS = ImmutableMap.copyOf(effects);
    }

    private static DimensionSpecialEffects preRegisterVanillaEffects(Map<ResourceLocation, DimensionSpecialEffects> effects) {
        DimensionSpecialEffects.OverworldEffects overworldEffects = new DimensionSpecialEffects.OverworldEffects();
        effects.put(BuiltinDimensionTypes.f_223542_, (DimensionSpecialEffects)overworldEffects);
        effects.put(BuiltinDimensionTypes.f_223543_, (DimensionSpecialEffects)new DimensionSpecialEffects.NetherEffects());
        effects.put(BuiltinDimensionTypes.f_223544_, (DimensionSpecialEffects)new DimensionSpecialEffects.EndEffects());
        return overworldEffects;
    }

    private DimensionSpecialEffectsManager() {
    }
}

