/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui.screens.worldselection;

import com.mojang.datafixers.util.Pair;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.Lifecycle;
import it.unimi.dsi.fastutil.booleans.BooleanConsumer;
import java.io.IOException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import javax.annotation.Nullable;
import net.minecraft.CrashReport;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.toasts.SystemToast;
import net.minecraft.client.gui.screens.BackupConfirmScreen;
import net.minecraft.client.gui.screens.ConfirmScreen;
import net.minecraft.client.gui.screens.DatapackLoadFailureScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.worldselection.CreateWorldScreen;
import net.minecraft.client.gui.screens.worldselection.EditWorldScreen;
import net.minecraft.commands.Commands;
import net.minecraft.core.RegistryAccess;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.RegistryOps;
import net.minecraft.server.ReloadableServerResources;
import net.minecraft.server.WorldLoader;
import net.minecraft.server.WorldStem;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.repository.FolderRepositorySource;
import net.minecraft.server.packs.repository.PackRepository;
import net.minecraft.server.packs.repository.PackSource;
import net.minecraft.server.packs.repository.RepositorySource;
import net.minecraft.server.packs.repository.ServerPacksSource;
import net.minecraft.server.packs.resources.CloseableResourceManager;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.world.level.DataPackConfig;
import net.minecraft.world.level.LevelSettings;
import net.minecraft.world.level.levelgen.WorldGenSettings;
import net.minecraft.world.level.storage.LevelResource;
import net.minecraft.world.level.storage.LevelStorageSource;
import net.minecraft.world.level.storage.PrimaryLevelData;
import net.minecraft.world.level.storage.WorldData;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.ForgeHooksClient;
import org.slf4j.Logger;

@OnlyIn(value=Dist.CLIENT)
public class WorldOpenFlows {
    private static final Logger f_233088_ = LogUtils.getLogger();
    private final Minecraft f_233089_;
    private final LevelStorageSource f_233090_;

    public WorldOpenFlows(Minecraft p_233093_, LevelStorageSource p_233094_) {
        this.f_233089_ = p_233093_;
        this.f_233090_ = p_233094_;
    }

    public void m_233133_(Screen p_233134_, String p_233135_) {
        this.m_233145_(p_233134_, p_233135_, false, true);
    }

    public void m_233157_(String p_233158_, LevelSettings p_233159_, RegistryAccess p_233160_, WorldGenSettings p_233161_) {
        LevelStorageSource.LevelStorageAccess levelstoragesource$levelstorageaccess = this.m_233155_(p_233158_);
        if (levelstoragesource$levelstorageaccess != null) {
            PackRepository packrepository = WorldOpenFlows.m_233105_(levelstoragesource$levelstorageaccess);
            DataPackConfig datapackconfig = p_233159_.m_46934_();
            try {
                WorldLoader.PackConfig worldloader$packconfig = new WorldLoader.PackConfig(packrepository, datapackconfig, false);
                WorldStem worldstem = this.m_233096_(worldloader$packconfig, (WorldLoader.WorldDataSupplier<WorldData>)((WorldLoader.WorldDataSupplier)(p_233103_, p_233104_) -> Pair.of((Object)new PrimaryLevelData(p_233159_, p_233161_, Lifecycle.stable()), (Object)p_233160_.m_203557_())));
                this.f_233089_.m_231380_(p_233158_, levelstoragesource$levelstorageaccess, packrepository, worldstem);
            }
            catch (Exception exception) {
                f_233088_.warn("Failed to load datapacks, can't proceed with server load", (Throwable)exception);
                WorldOpenFlows.m_233116_(levelstoragesource$levelstorageaccess, p_233158_);
            }
        }
    }

    @Nullable
    private LevelStorageSource.LevelStorageAccess m_233155_(String p_233156_) {
        try {
            return this.f_233090_.m_78260_(p_233156_);
        }
        catch (IOException ioexception) {
            f_233088_.warn("Failed to read level {} data", (Object)p_233156_, (Object)ioexception);
            SystemToast.m_94852_((Minecraft)this.f_233089_, (String)p_233156_);
            this.f_233089_.m_91152_(null);
            return null;
        }
    }

    public void m_233107_(LevelStorageSource.LevelStorageAccess p_233108_, ReloadableServerResources p_233109_, RegistryAccess.Frozen p_233110_, WorldData p_233111_) {
        PackRepository packrepository = WorldOpenFlows.m_233105_(p_233108_);
        CloseableResourceManager closeableresourcemanager = (CloseableResourceManager)new WorldLoader.PackConfig(packrepository, p_233111_.m_7513_(), false).m_214399_().getSecond();
        this.f_233089_.m_231380_(p_233108_.m_78277_(), p_233108_, packrepository, new WorldStem(closeableresourcemanager, p_233109_, p_233110_, p_233111_));
    }

    private static PackRepository m_233105_(LevelStorageSource.LevelStorageAccess p_233106_) {
        return new PackRepository(PackType.SERVER_DATA, new RepositorySource[]{new ServerPacksSource(), new FolderRepositorySource(p_233106_.m_78283_(LevelResource.f_78180_).toFile(), PackSource.f_10529_)});
    }

    private WorldStem m_233122_(LevelStorageSource.LevelStorageAccess p_233123_, boolean p_233124_, PackRepository p_233125_) throws Exception {
        DataPackConfig datapackconfig = p_233123_.m_78309_();
        if (datapackconfig == null) {
            throw new IllegalStateException("Failed to load data pack config");
        }
        WorldLoader.PackConfig worldloader$packconfig = new WorldLoader.PackConfig(p_233125_, datapackconfig, p_233124_);
        return this.m_233096_(worldloader$packconfig, (WorldLoader.WorldDataSupplier<WorldData>)((WorldLoader.WorldDataSupplier)(p_233114_, p_233115_) -> {
            RegistryAccess.Writable registryaccess$writable = RegistryAccess.m_206197_();
            RegistryOps dynamicops = RegistryOps.m_206813_((DynamicOps)NbtOps.f_128958_, (RegistryAccess.Writable)registryaccess$writable, (ResourceManager)p_233114_);
            WorldData worlddata = p_233123_.m_211747_((DynamicOps<Tag>)dynamicops, p_233115_, registryaccess$writable.m_211816_());
            if (worlddata == null) {
                throw new IllegalStateException("Failed to load world");
            }
            return Pair.of((Object)worlddata, (Object)registryaccess$writable.m_203557_());
        }));
    }

    public WorldStem m_233119_(LevelStorageSource.LevelStorageAccess p_233120_, boolean p_233121_) throws Exception {
        PackRepository packrepository = WorldOpenFlows.m_233105_(p_233120_);
        return this.m_233122_(p_233120_, p_233121_, packrepository);
    }

    private WorldStem m_233096_(WorldLoader.PackConfig p_233097_, WorldLoader.WorldDataSupplier<WorldData> p_233098_) throws Exception {
        WorldLoader.InitConfig worldloader$initconfig = new WorldLoader.InitConfig(p_233097_, Commands.CommandSelection.INTEGRATED, 2);
        CompletableFuture completablefuture = WorldStem.m_214415_((WorldLoader.InitConfig)worldloader$initconfig, p_233098_, (Executor)Util.m_183991_(), (Executor)((Object)this.f_233089_));
        this.f_233089_.m_18701_(completablefuture::isDone);
        return (WorldStem)completablefuture.get();
    }

    private void m_233145_(Screen p_233146_, String p_233147_, boolean p_233148_, boolean p_233149_) {
        this.doLoadLevel(p_233146_, p_233147_, p_233148_, p_233149_, false);
    }

    private void doLoadLevel(Screen p_233146_, String p_233147_, boolean p_233148_, boolean p_233149_, boolean confirmExperimentalWarning) {
        LevelStorageSource.LevelStorageAccess levelstoragesource$levelstorageaccess = this.m_233155_(p_233147_);
        if (levelstoragesource$levelstorageaccess != null) {
            PrimaryLevelData pld;
            boolean skipConfirmation;
            WorldStem worldstem;
            PackRepository packrepository = WorldOpenFlows.m_233105_(levelstoragesource$levelstorageaccess);
            try {
                WorldData worldData;
                levelstoragesource$levelstorageaccess.readAdditionalLevelSaveData();
                worldstem = this.m_233122_(levelstoragesource$levelstorageaccess, p_233148_, packrepository);
                if (confirmExperimentalWarning && (worldData = worldstem.f_206895_()) instanceof PrimaryLevelData) {
                    PrimaryLevelData pld2 = (PrimaryLevelData)worldData;
                    pld2.withConfirmedWarning(true);
                }
            }
            catch (Exception exception) {
                f_233088_.warn("Failed to load datapacks, can't proceed with server load", (Throwable)exception);
                this.f_233089_.m_91152_((Screen)new DatapackLoadFailureScreen(() -> this.m_233145_(p_233146_, p_233147_, true, p_233149_)));
                WorldOpenFlows.m_233116_(levelstoragesource$levelstorageaccess, p_233147_);
                return;
            }
            WorldData worlddata = worldstem.f_206895_();
            boolean flag = worlddata.m_5961_().m_64670_();
            boolean flag1 = worlddata.m_5754_() != Lifecycle.stable();
            boolean bl = skipConfirmation = worlddata instanceof PrimaryLevelData && (pld = (PrimaryLevelData)worlddata).hasConfirmedExperimentalWarning();
            if (skipConfirmation || !p_233149_ || !flag && !flag1) {
                ((CompletableFuture)((CompletableFuture)((CompletableFuture)this.f_233089_.m_91100_().m_235003_(levelstoragesource$levelstorageaccess).thenApply(p_233177_ -> true)).exceptionallyComposeAsync(p_233183_ -> {
                    f_233088_.warn("Failed to load pack: ", p_233183_);
                    return this.m_233095_();
                }, (Executor)((Object)this.f_233089_))).thenAcceptAsync(p_233168_ -> {
                    if (p_233168_.booleanValue()) {
                        this.f_233089_.m_231380_(p_233147_, levelstoragesource$levelstorageaccess, packrepository, worldstem);
                    } else {
                        worldstem.close();
                        WorldOpenFlows.m_233116_(levelstoragesource$levelstorageaccess, p_233147_);
                        this.f_233089_.m_91100_().m_235009_().thenRunAsync(() -> this.f_233089_.m_91152_(p_233146_), (Executor)((Object)this.f_233089_));
                    }
                }, (Executor)((Object)this.f_233089_))).exceptionally(p_233175_ -> {
                    this.f_233089_.m_231412_(CrashReport.m_127521_(p_233175_, "Load world"));
                    return null;
                });
            } else {
                if (flag) {
                    this.m_233140_(p_233146_, p_233147_, flag, () -> this.m_233145_(p_233146_, p_233147_, p_233148_, false));
                } else {
                    ForgeHooksClient.createWorldConfirmationScreen(() -> this.doLoadLevel(p_233146_, p_233147_, p_233148_, false, true));
                }
                worldstem.close();
                WorldOpenFlows.m_233116_(levelstoragesource$levelstorageaccess, p_233147_);
            }
        }
    }

    private CompletableFuture<Boolean> m_233095_() {
        CompletableFuture<Boolean> completablefuture = new CompletableFuture<Boolean>();
        this.f_233089_.m_91152_((Screen)new ConfirmScreen(completablefuture::complete, (Component)Component.m_237115_((String)"multiplayer.texturePrompt.failure.line1"), (Component)Component.m_237115_((String)"multiplayer.texturePrompt.failure.line2"), CommonComponents.f_130659_, CommonComponents.f_130656_));
        return completablefuture;
    }

    private static void m_233116_(LevelStorageSource.LevelStorageAccess p_233117_, String p_233118_) {
        try {
            p_233117_.close();
        }
        catch (IOException ioexception) {
            f_233088_.warn("Failed to unlock access to level {}", (Object)p_233118_, (Object)ioexception);
        }
    }

    private void m_233140_(Screen p_233141_, String p_233142_, boolean p_233143_, Runnable p_233144_) {
        MutableComponent component1;
        MutableComponent component;
        if (p_233143_) {
            component = Component.m_237115_((String)"selectWorld.backupQuestion.customized");
            component1 = Component.m_237115_((String)"selectWorld.backupWarning.customized");
        } else {
            component = Component.m_237115_((String)"selectWorld.backupQuestion.experimental");
            component1 = Component.m_237115_((String)"selectWorld.backupWarning.experimental");
        }
        this.f_233089_.m_91152_((Screen)new BackupConfirmScreen(p_233141_, (p_233172_, p_233173_) -> {
            if (p_233172_) {
                EditWorldScreen.m_101260_((LevelStorageSource)this.f_233090_, (String)p_233142_);
            }
            p_233144_.run();
        }, (Component)component, (Component)component1, false));
    }

    public static void m_233126_(Minecraft p_233127_, CreateWorldScreen p_233128_, Lifecycle p_233129_, Runnable p_233130_) {
        BooleanConsumer booleanconsumer = p_233154_ -> {
            if (p_233154_) {
                p_233130_.run();
            } else {
                p_233127_.m_91152_(p_233128_);
            }
        };
        if (p_233129_ == Lifecycle.stable()) {
            p_233130_.run();
        } else if (p_233129_ == Lifecycle.experimental()) {
            p_233127_.m_91152_((Screen)new ConfirmScreen(booleanconsumer, (Component)Component.m_237115_((String)"selectWorld.import_worldgen_settings.experimental.title"), (Component)Component.m_237115_((String)"selectWorld.import_worldgen_settings.experimental.question")));
        } else {
            p_233127_.m_91152_((Screen)new ConfirmScreen(booleanconsumer, (Component)Component.m_237115_((String)"selectWorld.import_worldgen_settings.deprecated.title"), (Component)Component.m_237115_((String)"selectWorld.import_worldgen_settings.deprecated.question")));
        }
    }
}

