/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fml.earlydisplay;

import com.sun.management.OperatingSystemMXBean;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.management.MemoryUsage;
import net.minecraftforge.fml.loading.FMLConfig;

public class PerformanceInfo {
    private final boolean showCPUUsage = FMLConfig.getBoolConfigValue((FMLConfig.ConfigValue)FMLConfig.ConfigValue.EARLY_WINDOW_SHOW_CPU);
    private final OperatingSystemMXBean osBean = this.showCPUUsage ? ManagementFactory.getPlatformMXBean(OperatingSystemMXBean.class) : null;
    private final MemoryMXBean memoryBean = ManagementFactory.getMemoryMXBean();
    float memory;
    private String text;

    PerformanceInfo() {
    }

    void update() {
        MemoryUsage heapusage = this.memoryBean.getHeapMemoryUsage();
        this.memory = (float)heapusage.getUsed() / (float)heapusage.getMax();
        if (!this.showCPUUsage) {
            this.text = "Heap: %d/%d MB (%.1f%%) OffHeap: %d MB".formatted(heapusage.getUsed() >> 20, heapusage.getMax() >> 20, (double)this.memory * 100.0, this.memoryBean.getNonHeapMemoryUsage().getUsed() >> 20);
            return;
        }
        double cpuLoad = this.osBean.getProcessCpuLoad();
        String cpuText = cpuLoad == -1.0 ? "*CPU: %.1f%%".formatted(this.osBean.getCpuLoad() * 100.0) : "CPU: %.1f%%".formatted(cpuLoad * 100.0);
        this.text = "Heap: %d/%d MB (%.1f%%) OffHeap: %d MB  %s".formatted(heapusage.getUsed() >> 20, heapusage.getMax() >> 20, (double)this.memory * 100.0, this.memoryBean.getNonHeapMemoryUsage().getUsed() >> 20, cpuText);
    }

    String text() {
        return this.text;
    }

    float memory() {
        return this.memory;
    }
}

